/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;

public class BufferedRandomAccessFileTest
extends TestCase {
    private static final String tmpPath = System.getProperty("java.io.tmpdir");

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBytes() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        BufferedRandomAccessFileTest.assertEquals((int)file.read(bytes, 0, bytes.length), (int)1024);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[0], (int)1);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[1], (int)2);
        file.close();
    }

    public void testBytes11() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "Buffer123"), "rw", 1000, -1000);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        BufferedRandomAccessFileTest.assertEquals((int)file.read(bytes, 0, bytes.length), (int)1024);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[0], (int)1);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[1], (int)2);
        file.close();
    }

    public void testBytes2() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 100, -100);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        BufferedRandomAccessFileTest.assertEquals((int)file.read(bytes, 0, bytes.length), (int)1024);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[0], (int)1);
        BufferedRandomAccessFileTest.assertEquals((int)bytes[1], (int)2);
        file.close();
    }

    public void testInteger() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeInt(i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)i);
            ++i;
        }
        file.seek(400L);
        BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)100);
        file.seek(804L);
        BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)201);
        BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)202);
        file.seek(2804L);
        file.writeInt(1000001);
        BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)702);
        file.seek(2804L);
        BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)1000001);
        file.close();
    }

    public void testString() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeUTF("string" + i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessFileTest.assertEquals((String)file.readUTF(), (String)("string" + i));
            ++i;
        }
        file.close();
    }

    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessFileTest.assertEquals((Object)file.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        file.close();
    }

    public void testDate() throws IOException {
        int objectNumber = 4101;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeDate(new Date(1900100000 + i * 1000));
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessFileTest.assertEquals((Object)file.readDate(), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        file.close();
    }

    public void testMixed() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeInt(i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessFileTest.assertEquals((int)file.readInt(), (int)i);
            ++i;
        }
        file.writeBigDecimal(new BigDecimal("1010101010101"));
        file.writeDate(new Date(12202000L));
        file.writeUTF("testString");
        file.writeShort(1300);
        file.writeLong(300000111L);
        file.seek(0L);
        file.skipBytes(objectNumber * 4);
        BufferedRandomAccessFileTest.assertEquals((Object)file.readBigDecimal(), (Object)new BigDecimal("1010101010101"));
        BufferedRandomAccessFileTest.assertEquals((Object)file.readDate(), (Object)new Date(12202000L));
        BufferedRandomAccessFileTest.assertEquals((String)file.readUTF(), (String)"testString");
        BufferedRandomAccessFileTest.assertEquals((int)file.readShort(), (int)1300);
        BufferedRandomAccessFileTest.assertEquals((long)file.readLong(), (long)300000111L);
        file.close();
    }
}

