/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;

public class OlapExpressionCompilerTest
extends TestCase {
    public void testGetReferencedDimensionName() {
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ScriptExpression("dimension[\"dim1\"][\"level1\"]"), (String)"dimension"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ScriptExpression("ra[\"abc\"]+dimension[\"dim1\"][\"level1\"]"), (String)"dimension"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ScriptExpression("ra[\"abc\"]+dimension[\"dim1\"][\"level1\"]+15"), (String)"dimension"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ScriptExpression("ra[\"abc\"]+dimension[\"dim1\"]+dimension[\"dim2\"][\"level1\"]+15"), (String)"dimension"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ScriptExpression("ra[\"abc\"]+rb[\"dim2\"]+dimension[\"dim1\"][\"level1\"]+15"), (String)"dimension"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1", (String)OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)new ConditionalExpression("ra[\"abc\"]+dimension[\"dim1\"][\"level1\"]", 0, "dim[\"abc\"]"), (String)"dimension"));
    }

    public void testGetReferencedDimLevel() throws DataException {
        Binding binding1 = new Binding("b1", (IBaseExpression)new ScriptExpression("dimension[\"dim1\"][\"level1\"]"));
        Binding binding2 = new Binding("b2", (IBaseExpression)new ScriptExpression("dimension.dim1.level2 + 1"));
        Binding binding3 = new Binding("b3", (IBaseExpression)new ScriptExpression("dimension[\"dim1\"][\"level3\"] + dimension.dim1.level2"));
        Binding binding4 = new Binding("b4", (IBaseExpression)new ScriptExpression("data.b1"));
        Binding binding5 = new Binding("b5", (IBaseExpression)new ScriptExpression("dimension.dim1.level1 + 25"));
        Binding binding6 = new Binding("b6", (IBaseExpression)new ScriptExpression("data.b4 + 1"));
        Binding binding7 = new Binding("b7", (IBaseExpression)new ScriptExpression("if( true ) data.b2; else data.b3;"));
        Binding binding8 = new Binding("b8", (IBaseExpression)new ScriptExpression("BirtComp.equalTo( dimension[\"customerRegions\"][\"COUNTRY\"], \"USA\" )"));
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        bindings.add(binding1);
        bindings.add(binding2);
        bindings.add(binding3);
        bindings.add(binding4);
        bindings.add(binding5);
        bindings.add(binding6);
        bindings.add(binding7);
        Set s1 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding1.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s1.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)((DimLevel)s1.iterator().next()).getDimensionName().equals("dim1"));
        OlapExpressionCompilerTest.assertTrue((boolean)((DimLevel)s1.iterator().next()).getLevelName().equals("level1"));
        Set s2 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding2.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s2.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)((DimLevel)s2.iterator().next()).getDimensionName().equals("dim1"));
        OlapExpressionCompilerTest.assertTrue((boolean)((DimLevel)s2.iterator().next()).getLevelName().equals("level2"));
        Set s21 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding2.getExpression(), bindings, (boolean)true);
        OlapExpressionCompilerTest.assertTrue((s21.size() == 0 ? 1 : 0) != 0);
        Set s3 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding3.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s3.size() == 2 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s3.contains(new DimLevel("dim1", "level3")));
        OlapExpressionCompilerTest.assertTrue((boolean)s3.contains(new DimLevel("dim1", "level2")));
        Set s4 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding4.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s4.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s4.contains(new DimLevel("dim1", "level1")));
        Set s41 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding4.getExpression(), bindings, (boolean)true);
        OlapExpressionCompilerTest.assertTrue((s41.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s41.contains(new DimLevel("dim1", "level1")));
        Set s5 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding5.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s5.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s5.contains(new DimLevel("dim1", "level1")));
        Set s6 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding6.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s6.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s6.contains(new DimLevel("dim1", "level1")));
        Set s61 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding6.getExpression(), bindings, (boolean)true);
        OlapExpressionCompilerTest.assertTrue((s61.size() == 0 ? 1 : 0) != 0);
        Set s7 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding7.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s7.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s7.contains(new DimLevel("dim1", "level2")));
        Set s8 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding8.getExpression(), bindings);
        OlapExpressionCompilerTest.assertTrue((s8.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s8.contains(new DimLevel("customerRegions", "COUNTRY")));
        Set s9 = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)new ScriptExpression("dimension[\"\\\"dim1\"][\"level1\\\"\"][\"attr1\"]"), (List)Collections.EMPTY_LIST);
        OlapExpressionCompilerTest.assertTrue((s9.size() == 1 ? 1 : 0) != 0);
        OlapExpressionCompilerTest.assertTrue((boolean)s9.contains(new DimLevel("\"dim1", "level1\"", "attr1")));
    }
}

