/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.perf;

import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.perf.QueryInfo;
import org.eclipse.birt.data.engine.perf.util.SizeOfUtil;
import org.eclipse.birt.data.engine.perf.util.TimeUtil;

public class APIPerfTestUtil {
    private QueryInfo queryInfo;

    public static APIPerfTestUtil newInstance() {
        return new APIPerfTestUtil();
    }

    public void setQueryInfo(QueryInfo queryInfo) {
        assert (queryInfo != null);
        this.queryInfo = queryInfo;
    }

    public void runTimeBenchMark(boolean isAverageValue) throws Exception {
        assert (this.queryInfo != null);
        String[] eventStr = new String[]{APIPerfTestUtil.formatStr1("start data engine", 23), APIPerfTestUtil.formatStr1("do query execution", 23), APIPerfTestUtil.formatStr1("do retreive data", 23), APIPerfTestUtil.formatStr1("whole operation", 23)};
        String prefix = "time consumed for event: ";
        String[] eventOutputStr = new String[eventStr.length];
        int i = 0;
        while (i < eventOutputStr.length) {
            eventOutputStr[i] = String.valueOf(prefix) + eventStr[i];
            ++i;
        }
        int loopCount = isAverageValue ? 4 : 1;
        long[] timeSpan = this.doTimeBenchMark(4, loopCount);
        int i2 = 0;
        while (i2 < eventStr.length) {
            System.out.println(String.valueOf(eventOutputStr[i2]) + ":" + TimeUtil.instance.getTimePointSpanStr(timeSpan[i2]));
            ++i2;
        }
    }

    private long[] doTimeBenchMark(int eventCount, int loopCount) throws Exception {
        assert (eventCount > 0);
        assert (loopCount > 0);
        long[][] timeSpanArray = new long[loopCount][eventCount];
        int j = 0;
        while (j < loopCount) {
            TimeUtil.TimePoint[] tpArray = new TimeUtil.TimePoint[eventCount];
            this.doTimeBenchMarkOnce(tpArray);
            int i = 0;
            while (i < eventCount) {
                long timeSpan = i < eventCount - 1 ? TimeUtil.instance.getTimePointSpan(tpArray[i], tpArray[i + 1]) : TimeUtil.instance.getTimePointSpan(tpArray[0], tpArray[i]);
                timeSpanArray[j][i] = timeSpan;
                ++i;
            }
            ++j;
        }
        long[] aveTimeSpan = new long[eventCount];
        int i = 0;
        while (i < eventCount) {
            long totalTimeSpan = 0L;
            if (loopCount == 1) {
                aveTimeSpan[i] = timeSpanArray[0][i];
            } else {
                int j2 = 1;
                while (j2 < loopCount) {
                    totalTimeSpan += timeSpanArray[j2][i];
                    ++j2;
                }
                aveTimeSpan[i] = totalTimeSpan / (long)(loopCount - 1);
            }
            ++i;
        }
        return aveTimeSpan;
    }

    private void doTimeBenchMarkOnce(TimeUtil.TimePoint[] tpArray) throws Exception {
        tpArray[0] = TimeUtil.instance.getTimePoint();
        DataEngine dataEngine1 = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
        dataEngine1.defineDataSource(this.queryInfo.getDataSource());
        dataEngine1.defineDataSet(this.queryInfo.getDataSet());
        tpArray[1] = TimeUtil.instance.getTimePoint();
        IPreparedQuery preparedQuery = dataEngine1.prepare((IQueryDefinition)this.queryInfo.getQueryDefn());
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator ri = queryResults.getResultIterator();
        tpArray[2] = TimeUtil.instance.getTimePoint();
        String[] exprs = this.queryInfo.getExprNames();
        while (ri.next()) {
            if (exprs == null) continue;
            int j = 0;
            while (j < exprs.length) {
                ri.getValue(exprs[j]);
                ++j;
            }
        }
        tpArray[3] = TimeUtil.instance.getTimePoint();
        ri.close();
        queryResults.close();
        dataEngine1.shutdown();
    }

    public void runSpaceBenchMark(boolean isAverageValue) throws Exception {
        assert (this.queryInfo != null);
        String[] eventStr = new String[]{APIPerfTestUtil.formatStr1("do query execution", 23), APIPerfTestUtil.formatStr1("do retreive data", 23), APIPerfTestUtil.formatStr1("close result iterator", 23), APIPerfTestUtil.formatStr1("close query results", 23), APIPerfTestUtil.formatStr1("close data engine", 23), APIPerfTestUtil.formatStr1("whole operation", 23)};
        String prefix = "memory consumed for event: ";
        String[] eventOutputStr = new String[eventStr.length];
        int i = 0;
        while (i < eventOutputStr.length) {
            eventOutputStr[i] = String.valueOf(prefix) + eventStr[i];
            ++i;
        }
        int loopCount = isAverageValue ? 4 : 1;
        long[] sizeSpan = this.doSpaceBenchMark(6, loopCount);
        int i2 = 0;
        while (i2 < eventStr.length) {
            System.out.println(String.valueOf(eventOutputStr[i2]) + ":" + APIPerfTestUtil.formatLong(sizeSpan[i2], 10) + " bytes");
            ++i2;
        }
    }

    private long[] doSpaceBenchMark(int eventCount, int loopCount) throws Exception {
        assert (eventCount > 0);
        assert (loopCount > 0);
        long[][] spaceSpan = new long[loopCount][eventCount];
        int j = 0;
        while (j < loopCount) {
            SizeOfUtil.SizePoint[] spArray = new SizeOfUtil.SizePoint[eventCount];
            this.doSpaceBenchMarkOnce(spArray);
            int i = 0;
            while (i < eventCount) {
                long sizeSpan = i < eventCount - 1 ? SizeOfUtil.instance.getSizePointSpan(spArray[i], spArray[i + 1]) : SizeOfUtil.instance.getSizePointSpan(spArray[0], spArray[i]);
                spaceSpan[j][i] = sizeSpan;
                ++i;
            }
            ++j;
        }
        long[] aveSpaceSpan = new long[eventCount];
        int i = 0;
        while (i < eventCount) {
            long totalSpaceSpan = 0L;
            if (loopCount == 1) {
                aveSpaceSpan[i] = spaceSpan[0][i];
            } else {
                int j2 = 1;
                while (j2 < loopCount) {
                    totalSpaceSpan += spaceSpan[j2][i];
                    ++j2;
                }
                aveSpaceSpan[i] = totalSpaceSpan / (long)(loopCount - 1);
            }
            ++i;
        }
        return aveSpaceSpan;
    }

    private void doSpaceBenchMarkOnce(SizeOfUtil.SizePoint[] spArray) throws Exception {
        DataEngine dataEngine1 = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
        dataEngine1.defineDataSource(this.queryInfo.getDataSource());
        dataEngine1.defineDataSet(this.queryInfo.getDataSet());
        spArray[0] = SizeOfUtil.instance.getUsedMemorySizePoint();
        IPreparedQuery preparedQuery = dataEngine1.prepare((IQueryDefinition)this.queryInfo.getQueryDefn());
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator ri = queryResults.getResultIterator();
        spArray[1] = SizeOfUtil.instance.getUsedMemorySizePoint();
        String[] exprs = this.queryInfo.getExprNames();
        while (ri.next()) {
            int j = 0;
            while (j < exprs.length) {
                ri.getValue(exprs[j]);
                ++j;
            }
        }
        spArray[2] = SizeOfUtil.instance.getUsedMemorySizePoint();
        ri.close();
        spArray[3] = SizeOfUtil.instance.getUsedMemorySizePoint();
        queryResults.close();
        spArray[4] = SizeOfUtil.instance.getUsedMemorySizePoint();
        dataEngine1.shutdown();
        spArray[5] = SizeOfUtil.instance.getUsedMemorySizePoint();
    }

    private static String formatLong(long value, int length) {
        boolean isPostive = value >= 0L;
        value = isPostive ? value : value * -1L;
        String result = APIPerfTestUtil.formatStr2("" + value, length - 1);
        result = isPostive ? " " + result : "-" + result;
        return result;
    }

    private static String formatStr1(String inputStr, int length) {
        return APIPerfTestUtil.formatStr(inputStr, length, true);
    }

    private static String formatStr2(String inputStr, int length) {
        return APIPerfTestUtil.formatStr(inputStr, length, false);
    }

    private static String formatStr(String inputStr, int length, boolean appendToTail) {
        if (inputStr == null) {
            return null;
        }
        int inputLen = inputStr.length();
        if (inputLen >= length) {
            return inputStr;
        }
        int appendLen = length - inputLen;
        char[] appendChar = new char[appendLen];
        int i = 0;
        while (i < appendLen) {
            appendChar[i] = 32;
            ++i;
        }
        String result = appendToTail ? String.valueOf(inputStr) + new String(appendChar) : String.valueOf(new String(appendChar)) + inputStr;
        return result;
    }
}

