/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFileFactory;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveFileFactoryTest
extends TestCase {
    static final int TEST_COUNT = 50;
    static final String TEST_FOLDER = "./utest/";
    static final String ARCHIVE_FILE = "./utest/archiveFileName";
    static final String VIEW_FILE = "./utest/viewFileName";
    static final String ARCHIVE_ID = "archiveId";
    static final String VIEW_ID = "viewId";

    public void setUp() {
        new File(TEST_FOLDER).mkdirs();
    }

    public void tearDown() {
        new File(ARCHIVE_FILE).delete();
        new File(VIEW_FILE).delete();
        new File(TEST_FOLDER).delete();
    }

    public void testCreateAndOpenArchive() throws IOException {
        ArchiveFileFactory factory = new ArchiveFileFactory();
        IArchiveFile writeArchive = factory.createArchive(ARCHIVE_ID);
        byte[] mes = new byte[100];
        int index = 0;
        while (index < 50) {
            ArchiveEntry entry = writeArchive.createEntry("/entry/" + index);
            entry.write(0L, mes, 0, index);
            entry.close();
            ++index;
        }
        writeArchive.close();
        IArchiveFile readArchive = factory.openArchive(ARCHIVE_ID, "r");
        ArchiveFileFactoryTest.assertEquals((String)ARCHIVE_ID, (String)readArchive.getSystemId());
        ArchiveFileFactoryTest.assertEquals(null, (String)readArchive.getDependId());
        int index2 = 0;
        while (index2 < 50) {
            ArchiveEntry entry = readArchive.openEntry("/entry/" + index2);
            ArchiveFileFactoryTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveFileFactoryTest.assertTrue((entry.getLength() == (long)index2 ? 1 : 0) != 0);
            entry.close();
            ++index2;
        }
        readArchive.close();
    }

    public void testCreateAndOpenView() throws IOException {
        ArchiveEntry entry;
        ArchiveFileFactory factory = new ArchiveFileFactory();
        IArchiveFile dependArchive = factory.createArchive(ARCHIVE_ID);
        byte[] mes = new byte[100];
        int index = 0;
        while (index < 10) {
            ArchiveEntry entry2 = dependArchive.createEntry("/entry/1." + index);
            entry2.write(0L, mes, 0, index);
            entry2.close();
            ++index;
        }
        IArchiveFile viewArchive = factory.createView(VIEW_ID, dependArchive);
        int index2 = 10;
        while (index2 < 20) {
            ArchiveEntry entry3 = viewArchive.createEntry("/entry/2." + index2);
            entry3.write(0L, mes, 0, index2);
            entry3.close();
            ++index2;
        }
        viewArchive.flush();
        viewArchive.close();
        IArchiveFile openView = factory.openView(VIEW_ID, "r", dependArchive);
        ArchiveFileFactoryTest.assertEquals((String)ARCHIVE_ID, (String)dependArchive.getSystemId());
        ArchiveFileFactoryTest.assertEquals(null, (String)dependArchive.getDependId());
        ArchiveFileFactoryTest.assertEquals((String)VIEW_ID, (String)openView.getSystemId());
        ArchiveFileFactoryTest.assertEquals((String)ARCHIVE_ID, (String)openView.getDependId());
        int index3 = 0;
        while (index3 < 10) {
            entry = openView.openEntry("/entry/1." + index3);
            ArchiveFileFactoryTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveFileFactoryTest.assertTrue((entry.getLength() == (long)index3 ? 1 : 0) != 0);
            entry.close();
            ++index3;
        }
        index3 = 10;
        while (index3 < 20) {
            entry = openView.openEntry("/entry/2." + index3);
            ArchiveFileFactoryTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveFileFactoryTest.assertTrue((entry.getLength() == (long)index3 ? 1 : 0) != 0);
            entry.close();
            ++index3;
        }
        openView.close();
        dependArchive.close();
        IArchiveFile openView2 = factory.openArchive(VIEW_ID, "r");
        ArchiveFileFactoryTest.assertEquals((String)VIEW_ID, (String)openView2.getSystemId());
        ArchiveFileFactoryTest.assertEquals((String)ARCHIVE_ID, (String)openView2.getDependId());
        openView2.close();
    }
}

