/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveView;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveViewTest
extends TestCase {
    static final String TEST_FOLDER = "./utest/";
    static final String ARCHIVE_FILE = "./utest/archive.rptdocument";
    static final String VIEW_FILE = "./utest/view.rptdocument";
    static final String REPORT_DOCUMENT_RESOURCE = "org/eclipse/birt/core/archive/compound/ArchiveViewTest.rptdocument";

    public void setUp() {
        new File(TEST_FOLDER).mkdirs();
        this.copyResource(REPORT_DOCUMENT_RESOURCE, ARCHIVE_FILE);
    }

    public void tearDown() {
        new File(ARCHIVE_FILE).delete();
        new File(VIEW_FILE).delete();
        new File(TEST_FOLDER).delete();
        new File(ARCHIVE_FILE).delete();
    }

    public void testModify() throws IOException {
        ArchiveEntry entry;
        byte[] mes = new byte[200];
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        int index = 1;
        while (index <= 50) {
            ArchiveEntry entry2 = archive.createEntry("/entry/" + index);
            entry2.write(0L, mes, 0, index);
            entry2.close();
            ++index;
        }
        archive.flush();
        ArchiveFile viewFile = new ArchiveFile(VIEW_FILE, "rw");
        ArchiveView view = new ArchiveView((IArchiveFile)viewFile, (IArchiveFile)archive, false);
        int index2 = 1;
        while (index2 <= 50) {
            entry = view.openEntry("/entry/" + index2);
            ArchiveViewTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveViewTest.assertEquals((long)index2, (long)entry.getLength());
            entry.close();
            ++index2;
        }
        index2 = 51;
        while (index2 <= 100) {
            ArchiveViewTest.assertTrue((!view.exists("/entry/" + index2) ? 1 : 0) != 0);
            ++index2;
        }
        index2 = 1;
        while (index2 <= 100) {
            entry = view.createEntry("/entry/" + index2);
            entry.write(0L, mes, 0, index2 * 2);
            entry.close();
            ++index2;
        }
        index2 = 1;
        while (index2 <= 100) {
            entry = view.openEntry("/entry/" + index2);
            ArchiveViewTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveViewTest.assertTrue((entry.getLength() == (long)(index2 * 2) ? 1 : 0) != 0);
            entry.close();
            ++index2;
        }
        view.close();
        viewFile.close();
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        index2 = 1;
        while (index2 <= 50) {
            entry = archive.openEntry("/entry/" + index2);
            ArchiveViewTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveViewTest.assertTrue((entry.getLength() == (long)index2 ? 1 : 0) != 0);
            entry.close();
            ++index2;
        }
    }

    public void testReadAndWrite() throws IOException {
        ArchiveFile archiveFile = new ArchiveFile(ARCHIVE_FILE, "rw");
        ArchiveFile viewFile = new ArchiveFile(VIEW_FILE, "rw");
        ArchiveView view = new ArchiveView((IArchiveFile)viewFile, (IArchiveFile)archiveFile, false);
        view.setCacheSize(65536L);
        this.createArchive((IArchiveFile)view);
        this.checkArchive((IArchiveFile)view);
        ArchiveViewTest.assertTrue((view.getUsedCache() > 0L ? 1 : 0) != 0);
        ArchiveViewTest.assertTrue((view.getUsedCache() <= 65536L ? 1 : 0) != 0);
        view.close();
        ArchiveViewTest.assertTrue((view.getUsedCache() == 0L ? 1 : 0) != 0);
    }

    public void testReadAndWriteV2() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "r");
        ArchiveFile viewFile = new ArchiveFile(VIEW_FILE, "rw");
        ArchiveView view = new ArchiveView((IArchiveFile)viewFile, (IArchiveFile)archive, false);
        view.setCacheSize(65536L);
        this.createArchive((IArchiveFile)view);
        this.checkArchive((IArchiveFile)view);
        ArchiveViewTest.assertTrue((view.getUsedCache() > 0L ? 1 : 0) != 0);
        ArchiveViewTest.assertTrue((view.getUsedCache() <= 65536L ? 1 : 0) != 0);
        view.close();
        ArchiveViewTest.assertTrue((view.getUsedCache() == 0L ? 1 : 0) != 0);
    }

    private void copyResource(String src, String tgt) {
        InputStream in;
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        ArchiveViewTest.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ArchiveViewTest.fail();
        }
    }

    public void createArchive(IArchiveFile archive) throws IOException {
        int entryCount = 1024;
        byte[] b = new byte[entryCount];
        int i = 0;
        while (i < entryCount) {
            ArchiveEntry entry = archive.createEntry("/entry/" + i);
            entry.write(0L, b, 0, i);
            entry.close();
            ++i;
        }
    }

    void checkArchive(IArchiveFile archive) throws IOException {
        int entryCount = 1024;
        int i = 0;
        while (i < entryCount) {
            ArchiveEntry entry = archive.openEntry("/entry/" + i);
            try {
                ArchiveViewTest.assertTrue((entry != null ? 1 : 0) != 0);
                ArchiveViewTest.assertEquals((long)i, (long)entry.getLength());
            }
            finally {
                entry.close();
            }
            ++i;
        }
    }
}

