/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.FileBTreeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeMultipleThreadTest
extends TestCase {
    static int KEY_COUNT = 10000;
    static boolean hasError;

    public void testCursor() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            BTreeOption option = new BTreeOption();
            option.setFile((BTreeFile)file, true);
            BTree btree = new BTree(option);
            try {
                BTreeMultipleThreadTest.createBTree((BTree<String, String>)btree);
                int i = 0;
                while (i < 4) {
                    new Thread(new TestThread((BTreeCursor<String, String>)btree.createCursor())).start();
                    ++i;
                }
                while (TestThread.hasActiveThread()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                btree.close();
            }
            if (TestThread.hasErrors()) {
                TestThread.printErrors();
                BTreeMultipleThreadTest.fail((String)"HAS ERROR!");
            }
        }
        finally {
            file.close();
        }
    }

    static void createBTree(BTree<String, String> btree) throws IOException {
        int i = 0;
        while (i < KEY_COUNT) {
            String value = String.valueOf(i);
            btree.insert((Object)value, (Object)value);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestThread
    implements Runnable {
        static int threadCount;
        static ArrayList<Throwable> errors;
        BTreeCursor<String, String> cursor;

        static {
            errors = new ArrayList();
        }

        static synchronized void increaseThreadCount() {
            ++threadCount;
        }

        static synchronized void decreaseThreadCount() {
            --threadCount;
        }

        static synchronized boolean hasActiveThread() {
            return threadCount > 0;
        }

        static boolean hasErrors() {
            return !errors.isEmpty();
        }

        static synchronized void throwError(Throwable ex) {
            errors.add(ex);
        }

        static synchronized void printErrors() throws Exception {
            for (Throwable ex : errors) {
                ex.printStackTrace();
            }
        }

        TestThread(BTreeCursor<String, String> cursor) {
            this.cursor = cursor;
        }

        @Override
        public void run() {
            block8: {
                TestThread.increaseThreadCount();
                try {
                    try {
                        int rowCount = 0;
                        while (this.cursor.next()) {
                            String value;
                            String key = (String)this.cursor.getKey();
                            if (!key.equals(value = (String)this.cursor.getValue())) {
                                throw new IOException(String.valueOf(key) + " != " + value);
                            }
                            ++rowCount;
                        }
                        if (rowCount != KEY_COUNT) {
                            throw new IOException("KEY_COUNT INCORRECT");
                        }
                    }
                    catch (Throwable ex) {
                        TestThread.throwError(ex);
                        this.cursor.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.cursor.close();
                    throw throwable;
                }
                this.cursor.close();
            }
            TestThread.decreaseThreadCount();
        }
    }
}

