/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.GregorianCalendar;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.BaseScriptable;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class DataTypeUtilTest
extends TestCase {
    public Object[] testObject;
    public Object[] resultInteger;
    public Object[] resultBigDecimal;
    public Object[] resultBoolean;
    public Object[] resultDate;
    public Object[] resultDouble;
    public Object[] resultString;
    public Object[] resultLocaleNeutralString;
    public Object[] autoValueInputObject;
    public Object[] autoValueExpectedResult;
    public Object[] testObjectDecimal;
    public Object[] resultObjectDecimal;
    public Object[] testObjectDouble;
    public Object[] resultObjectDouble;
    private DateFormat df = DateFormat.getDateTimeInstance((int)2, (int)3, (Locale)Locale.getDefault());

    protected void setUp() throws Exception {
        super.setUp();
        Object[] objectArray = new Object[18];
        objectArray[0] = new Integer(1);
        objectArray[1] = new Integer(0);
        objectArray[2] = BigDecimal.valueOf(Integer.MAX_VALUE);
        objectArray[3] = BigDecimal.valueOf(Integer.MIN_VALUE);
        objectArray[4] = BigDecimal.valueOf(Integer.MIN_VALUE);
        objectArray[5] = BigDecimal.valueOf(Integer.MAX_VALUE);
        objectArray[6] = BigDecimal.valueOf(0L);
        objectArray[7] = true;
        objectArray[8] = false;
        objectArray[9] = new GregorianCalendar(3904, 1, 1).getTime();
        objectArray[10] = Double.valueOf("1.1");
        objectArray[11] = Double.valueOf("0");
        objectArray[13] = "testString";
        objectArray[14] = "12345";
        objectArray[15] = "10/11/2005";
        objectArray[16] = "10/11/2005 2:30 am";
        objectArray[17] = "10/11/2005 2:25:46 pm";
        this.testObject = objectArray;
        Object[] objectArray2 = new Object[19];
        objectArray2[0] = "1";
        objectArray2[1] = "0";
        objectArray2[2] = String.valueOf(Integer.MAX_VALUE);
        objectArray2[3] = String.valueOf(Integer.MIN_VALUE);
        objectArray2[4] = String.valueOf(Integer.MIN_VALUE);
        objectArray2[5] = String.valueOf(Integer.MAX_VALUE);
        objectArray2[6] = String.valueOf(0L);
        objectArray2[7] = "true";
        objectArray2[8] = "false";
        objectArray2[9] = new GregorianCalendar(3904, 1, 1).getTime().toString();
        objectArray2[10] = "1.1";
        objectArray2[11] = "0";
        objectArray2[13] = "1.00000000001";
        objectArray2[14] = "testString";
        objectArray2[15] = "12345";
        objectArray2[16] = "10/11/2005";
        objectArray2[17] = "10/11/2005 2:30 am";
        objectArray2[18] = "10/11/2005 2:25:46 pm";
        this.autoValueInputObject = objectArray2;
        Object[] objectArray3 = new Object[18];
        objectArray3[0] = new Exception("");
        objectArray3[1] = new Exception("");
        objectArray3[2] = new Exception("");
        objectArray3[3] = new Exception("");
        objectArray3[4] = new Exception("");
        objectArray3[5] = new Exception("");
        objectArray3[6] = new Exception("");
        objectArray3[7] = new Exception("");
        objectArray3[8] = new Exception("");
        objectArray3[9] = new GregorianCalendar(3904, 1, 1).getTime();
        objectArray3[10] = new Exception("");
        objectArray3[11] = new Exception("");
        objectArray3[13] = new Exception("");
        objectArray3[14] = new Exception("");
        objectArray3[15] = new GregorianCalendar(2005, 9, 11).getTime();
        objectArray3[16] = new GregorianCalendar(2005, 9, 11, 2, 30).getTime();
        objectArray3[17] = new GregorianCalendar(2005, 9, 11, 14, 25, 46).getTime();
        this.resultDate = objectArray3;
        Object[] objectArray4 = new Object[18];
        objectArray4[0] = new Integer(1);
        objectArray4[1] = new Integer(0);
        objectArray4[2] = new Integer(Integer.MAX_VALUE);
        objectArray4[3] = new Integer(Integer.MIN_VALUE);
        objectArray4[4] = new Integer(Integer.MIN_VALUE);
        objectArray4[5] = new Integer(Integer.MAX_VALUE);
        objectArray4[6] = new Integer(0);
        objectArray4[7] = new Integer(1);
        objectArray4[8] = new Integer(0);
        objectArray4[9] = new Exception("");
        objectArray4[10] = new Integer(1);
        objectArray4[11] = new Integer(0);
        objectArray4[13] = new Exception("");
        objectArray4[14] = new Integer("12345");
        objectArray4[15] = new Integer(10);
        objectArray4[16] = new Integer(10);
        objectArray4[17] = new Integer(10);
        this.resultInteger = objectArray4;
        Object[] objectArray5 = new Object[18];
        objectArray5[0] = new BigDecimal("1");
        objectArray5[1] = new BigDecimal("0");
        objectArray5[2] = new BigDecimal(Integer.MAX_VALUE);
        objectArray5[3] = new BigDecimal(Integer.MIN_VALUE);
        objectArray5[4] = new BigDecimal(Integer.MIN_VALUE);
        objectArray5[5] = new BigDecimal(Integer.MAX_VALUE);
        objectArray5[6] = new BigDecimal(0);
        objectArray5[7] = new BigDecimal(1);
        objectArray5[8] = new BigDecimal(0);
        objectArray5[9] = new BigDecimal(((java.util.Date)this.resultDate[9]).getTime());
        objectArray5[10] = new BigDecimal("1.1");
        objectArray5[11] = new BigDecimal("0.0");
        objectArray5[13] = new Exception("");
        objectArray5[14] = new BigDecimal("12345");
        objectArray5[15] = new BigDecimal(10);
        objectArray5[16] = new BigDecimal(10);
        objectArray5[17] = new BigDecimal(10);
        this.resultBigDecimal = objectArray5;
        this.resultBoolean = new Object[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, new Exception(""), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, new Exception(""), Boolean.TRUE, new Exception(""), new Exception(""), new Exception("")};
        Object[] objectArray6 = new Object[18];
        objectArray6[0] = new Double(1.0);
        objectArray6[1] = new Double(0.0);
        objectArray6[2] = new Double(2.147483647E9);
        objectArray6[3] = new Double(-2.147483648E9);
        objectArray6[4] = new Double(-2.147483648E9);
        objectArray6[5] = new Double(2.147483647E9);
        objectArray6[6] = new Double(0.0);
        objectArray6[7] = new Double(1.0);
        objectArray6[8] = new Double(0.0);
        objectArray6[9] = new Double(((java.util.Date)this.resultDate[9]).getTime());
        objectArray6[10] = new Double(1.1);
        objectArray6[11] = new Double(0.0);
        objectArray6[13] = new Exception("");
        objectArray6[14] = new Double("12345");
        objectArray6[15] = new Double(10.0);
        objectArray6[16] = new Double(10.0);
        objectArray6[17] = new Double(10.0);
        this.resultDouble = objectArray6;
        Object[] objectArray7 = new Object[18];
        objectArray7[0] = "1";
        objectArray7[1] = "0";
        objectArray7[2] = String.valueOf(Integer.MAX_VALUE);
        objectArray7[3] = String.valueOf(Integer.MIN_VALUE);
        objectArray7[4] = String.valueOf(Integer.MIN_VALUE);
        objectArray7[5] = String.valueOf(Integer.MAX_VALUE);
        objectArray7[6] = "0";
        objectArray7[7] = "true";
        objectArray7[8] = "false";
        objectArray7[9] = this.df.format(this.resultDate[9]);
        objectArray7[10] = "1.1";
        objectArray7[11] = "0.0";
        objectArray7[13] = "testString";
        objectArray7[14] = "12345";
        objectArray7[15] = "10/11/2005";
        objectArray7[16] = "10/11/2005 2:30 am";
        objectArray7[17] = "10/11/2005 2:25:46 pm";
        this.resultString = objectArray7;
        Object[] objectArray8 = new Object[19];
        objectArray8[0] = new Integer(1);
        objectArray8[1] = new Integer(0);
        objectArray8[2] = new Integer(Integer.MAX_VALUE);
        objectArray8[3] = new Integer(Integer.MIN_VALUE);
        objectArray8[4] = new Integer(Integer.MIN_VALUE);
        objectArray8[5] = new Integer(Integer.MAX_VALUE);
        objectArray8[6] = new Integer(0);
        objectArray8[7] = "true";
        objectArray8[8] = "false";
        objectArray8[9] = ((java.util.Date)this.resultDate[9]).toString();
        objectArray8[10] = new Double(1.1);
        objectArray8[11] = new Integer(0);
        objectArray8[13] = new Integer(1);
        objectArray8[14] = "testString";
        objectArray8[15] = new Integer("12345");
        objectArray8[16] = new GregorianCalendar(2005, 9, 11).getTime();
        objectArray8[17] = new GregorianCalendar(2005, 9, 11, 2, 30).getTime();
        objectArray8[18] = new GregorianCalendar(2005, 9, 11, 14, 25, 46).getTime();
        this.autoValueExpectedResult = objectArray8;
        Object[] objectArray9 = new Object[18];
        objectArray9[0] = "1";
        objectArray9[1] = "0";
        objectArray9[2] = String.valueOf(Integer.MAX_VALUE);
        objectArray9[3] = String.valueOf(Integer.MIN_VALUE);
        objectArray9[4] = String.valueOf(Integer.MIN_VALUE);
        objectArray9[5] = String.valueOf(Integer.MAX_VALUE);
        objectArray9[6] = "0";
        objectArray9[7] = "true";
        objectArray9[8] = "false";
        objectArray9[9] = "3904-02-01 00:00:00.000";
        objectArray9[10] = "1.1";
        objectArray9[11] = "0.0";
        objectArray9[13] = "testString";
        objectArray9[14] = "12345";
        objectArray9[15] = "10/11/2005";
        objectArray9[16] = "10/11/2005 2:30 am";
        objectArray9[17] = "10/11/2005 2:25:46 pm";
        this.resultLocaleNeutralString = objectArray9;
        Object[] objectArray10 = new Object[19];
        objectArray10[0] = new Integer(1);
        objectArray10[1] = new Integer(0);
        objectArray10[2] = new Integer(Integer.MAX_VALUE);
        objectArray10[3] = new Integer(Integer.MIN_VALUE);
        objectArray10[4] = new Integer(Integer.MIN_VALUE);
        objectArray10[5] = new Integer(Integer.MAX_VALUE);
        objectArray10[6] = new Integer(0);
        objectArray10[7] = "true";
        objectArray10[8] = "false";
        objectArray10[9] = ((java.util.Date)this.resultDate[9]).toString();
        objectArray10[10] = new Double(1.1);
        objectArray10[11] = new Integer(0);
        objectArray10[13] = new Integer(1);
        objectArray10[14] = "testString";
        objectArray10[15] = new Integer("12345");
        objectArray10[16] = new GregorianCalendar(2005, 9, 11).getTime();
        objectArray10[17] = new GregorianCalendar(2005, 9, 11, 2, 30).getTime();
        objectArray10[18] = new GregorianCalendar(2005, 9, 11, 14, 25, 46).getTime();
        this.autoValueExpectedResult = objectArray10;
        this.testObjectDecimal = new Object[]{new Double(Double.NaN), new Double(Double.POSITIVE_INFINITY), new Double(Double.NEGATIVE_INFINITY), new Double(Double.MAX_VALUE), new Double(Double.MIN_VALUE)};
        this.resultObjectDecimal = new Object[]{new Exception(""), new Exception(""), new Exception(""), new BigDecimal(new Double(Double.MAX_VALUE).toString()), new BigDecimal(new Double(Double.MIN_VALUE).toString())};
        this.testObjectDouble = new Object[]{new Float(1.0f)};
        this.resultObjectDouble = new Object[]{new Double(1.0)};
    }

    protected void tearDown() throws Exception {
        this.testObject = null;
        super.tearDown();
    }

    public void testToInteger() throws BirtException {
        Integer result;
        int i = 0;
        while (i < this.testObject.length) {
            block8: {
                try {
                    result = DataTypeUtil.toInteger((Object)this.testObject[i]);
                    if (this.resultInteger[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultInteger[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultInteger[i] instanceof Exception) break block8;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
        DataTypeUtilTest.assertEquals((Object)DataTypeUtil.toInteger((Object)"1.8"), (Object)new Integer(1));
        try {
            result = DataTypeUtil.toInteger((Object)Long.MAX_VALUE);
            DataTypeUtilTest.fail((String)"Should throw exception ");
        }
        catch (BirtException birtException) {}
        try {
            result = DataTypeUtil.toInteger((Object)Long.MIN_VALUE);
            DataTypeUtilTest.fail((String)"Should throw exception ");
        }
        catch (BirtException birtException) {}
    }

    public void testToBigDecimal() {
        BigDecimal result;
        int i = 0;
        while (i < this.testObject.length) {
            block10: {
                try {
                    result = DataTypeUtil.toBigDecimal((Object)this.testObject[i]);
                    if (this.resultBigDecimal[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultBigDecimal[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultBigDecimal[i] instanceof Exception) break block10;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.testObjectDecimal.length) {
            try {
                result = DataTypeUtil.toBigDecimal((Object)this.testObjectDecimal[i]);
                if (this.resultObjectDecimal[i] instanceof Exception) {
                    DataTypeUtilTest.fail((String)"Should throw Exception.");
                }
                DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultObjectDecimal[i]);
            }
            catch (BirtException birtException) {
                if (!(this.resultObjectDecimal[i] instanceof Exception)) {
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            catch (Exception exception) {
                DataTypeUtilTest.fail((String)"Should throw BirtException.");
            }
            ++i;
        }
    }

    public void testToBoolean() {
        int i = 0;
        while (i < this.testObject.length) {
            block6: {
                System.out.println(i);
                try {
                    Boolean result = DataTypeUtil.toBoolean((Object)this.testObject[i]);
                    if (this.resultBoolean[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultBoolean[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultBoolean[i] instanceof Exception) break block6;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
        try {
            DataTypeUtilTest.assertTrue((boolean)DataTypeUtil.toBoolean((Object)new Double(0.1)));
            DataTypeUtilTest.assertTrue((boolean)DataTypeUtil.toBoolean((Object)new Double(-0.1)));
            DataTypeUtilTest.assertTrue((boolean)DataTypeUtil.toBoolean((Object)new Double(1.0)));
            DataTypeUtilTest.assertTrue((boolean)DataTypeUtil.toBoolean((Object)new Double(1.0)));
            DataTypeUtilTest.assertFalse((boolean)DataTypeUtil.toBoolean((Object)new Double(0.0)));
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    public void testToSqlDate() throws BirtException {
        Date date1;
        Date date = DataTypeUtil.toSqlDate((Object)"1999-2-11");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1999, 1, 11);
        cal.getTime();
        DataTypeUtilTest.assertEquals((Object)cal.getTime(), (Object)date);
        try {
            date1 = DataTypeUtil.toSqlDate((Object)"99-2-11");
            cal.set(99, 1, 11);
            DataTypeUtilTest.assertEquals((Object)cal.getTime(), (Object)date1);
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        try {
            date1 = DataTypeUtil.toSqlDate((Object)"9921111");
            DataTypeUtilTest.assertEquals((Object)cal.getTime(), (Object)date1);
            DataTypeUtilTest.fail((String)"Should not arrive here");
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    public void testToSqlTime() throws BirtException {
        Time temp = this.getTime(11, 11, 25, 0);
        Time time = DataTypeUtil.toSqlTime((Object)"11:11:25");
        DataTypeUtilTest.assertEquals((String)time.toString(), (String)temp.toString());
        time = DataTypeUtil.toSqlTime((Object)"11:11:25 am");
        DataTypeUtilTest.assertEquals((String)time.toString(), (String)temp.toString());
        time = DataTypeUtil.toSqlTime((Object)"11:11:25am");
        DataTypeUtilTest.assertEquals((String)time.toString(), (String)temp.toString());
        temp = this.getTime(18, 11, 25, 0);
        time = DataTypeUtil.toSqlTime((Object)"18:11:25");
        DataTypeUtilTest.assertEquals((String)time.toString(), (String)temp.toString());
        temp = this.getTime(18, 11, 25, 12);
        time = DataTypeUtil.toSqlTime((Object)"18:11:25.12");
        DataTypeUtilTest.assertEquals((String)time.toString(), (String)temp.toString());
        time = DataTypeUtil.toSqlTime((Object)"6:11:25 pm");
        DataTypeUtilTest.assertEquals((Object)time, (Object)temp);
        time = DataTypeUtil.toSqlTime((Object)"6:11:25pm");
        DataTypeUtilTest.assertEquals((Object)time, (Object)temp);
        this.failSqlTimeString("99dfa-2-11");
        this.failSqlTimeString("18:11:25 pm");
        this.failSqlTimeString("18:11:25 am");
        this.failSqlTimeString("1:11:25 pmm");
        this.failSqlTimeString("1:11:65 am");
        this.failSqlTimeString("1:61:25 pm");
    }

    private Time getTime(int hour, int minute, int second, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return new Time(calendar.getTimeInMillis());
    }

    private void failSqlTimeString(String value) {
        try {
            DataTypeUtil.toSqlTime((Object)value);
            DataTypeUtilTest.fail((String)"Should not arrive here");
        }
        catch (BirtException birtException) {}
    }

    public void testToDate() {
        int i = 0;
        while (i < this.testObject.length) {
            block4: {
                try {
                    java.util.Date result = DataTypeUtil.toDate((Object)this.testObject[i]);
                    if (this.resultDate[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultDate[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultDate[i] instanceof Exception) break block4;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
    }

    public void testToDate1() {
        String[] testStrings = new String[]{"1997", "1997-07", "1997-07-16", "1997-07-16T19:20+02", "1997-07-16T19:20:30GMT+01:00", "1997-07-16T19:20:30.045+01:00", "1997-07-16 19:20+01:00", "1997-07-16 19:20:30+01:00", "1997-07-16 19:20:30.045+01:00", "1997-07-16 19:20:30.045 GMT+01:00", "1997-07-16T19:20:30.045-01:00"};
        Calendar calendar = Calendar.getInstance();
        java.util.Date[] resultDates = new java.util.Date[11];
        calendar.clear();
        calendar.set(1997, 0, 1);
        resultDates[0] = calendar.getTime();
        calendar.set(1997, 6, 1);
        resultDates[1] = calendar.getTime();
        calendar.set(1997, 6, 16);
        resultDates[2] = calendar.getTime();
        calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT+00:00"));
        calendar.set(1997, 6, 16, 17, 20, 0);
        resultDates[3] = calendar.getTime();
        calendar.set(1997, 6, 16, 18, 20, 30);
        resultDates[4] = calendar.getTime();
        calendar.set(1997, 6, 16, 18, 20, 30);
        calendar.set(14, 45);
        resultDates[5] = calendar.getTime();
        calendar.set(1997, 6, 16, 18, 20, 0);
        calendar.set(14, 0);
        resultDates[6] = calendar.getTime();
        calendar.set(1997, 6, 16, 18, 20, 30);
        resultDates[7] = calendar.getTime();
        calendar.set(1997, 6, 16, 18, 20, 30);
        calendar.set(14, 45);
        resultDates[8] = calendar.getTime();
        resultDates[9] = calendar.getTime();
        calendar.set(1997, 6, 16, 20, 20, 30);
        calendar.set(14, 45);
        resultDates[10] = calendar.getTime();
        int i = 0;
        while (i < testStrings.length) {
            try {
                java.util.Date dateResult = DataTypeUtil.toDate((Object)testStrings[i]);
                DataTypeUtilTest.assertEquals((Object)dateResult, (Object)resultDates[i]);
            }
            catch (BirtException birtException) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i;
        }
    }

    public void testToDate2() {
        String[] dateStrings = new String[]{"Jan 11, 2002", "Jan 11, 2002", "Feb 12, 1981 6:17 AM"};
        String[] timeZoneIDs = new String[]{"GMT+00:00", "GMT-02:00", "GMT+03:00"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT+00:00"));
        java.util.Date[] resultDates = new java.util.Date[3];
        calendar.clear();
        calendar.set(2002, 0, 11, 0, 0, 0);
        resultDates[0] = calendar.getTime();
        calendar.clear();
        calendar.set(2002, 0, 11, 2, 0, 0);
        resultDates[1] = calendar.getTime();
        calendar.clear();
        calendar.set(1981, 1, 12, 3, 17, 0);
        resultDates[2] = calendar.getTime();
        int i = 0;
        while (i < dateStrings.length) {
            try {
                java.util.Date dateResult = DataTypeUtil.toDate((String)dateStrings[i], (ULocale)ULocale.US, (TimeZone)TimeZone.getTimeZone((String)timeZoneIDs[i]));
                DataTypeUtilTest.assertEquals((Object)dateResult, (Object)resultDates[i]);
            }
            catch (BirtException birtException) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i;
        }
    }

    public void testToDateForMysql() throws BirtException {
        String source = "12/30/2008 13:00";
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2008, 11, 30, 13, 0, 0);
        DataTypeUtilTest.assertEquals((Object)DataTypeUtil.toDate((Object)source), (Object)calendar.getTime());
    }

    public void testToDate3() {
        String[] dateStrings = new String[]{"Jan 11, 2002", "Jan 11, 2002", "Feb 12, 1981 6:17 AM"};
        String[] timeZoneIDs = new String[]{"GMT+00:00", "GMT-02:00", "GMT+03:00"};
        String[] ISODateStrings = new String[]{"1997-07-16", "1997-07-16T19:20", "1997-07-16T19:20:30"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT+00:00"));
        java.util.Date[] resultDates1 = new java.util.Date[3];
        calendar.clear();
        calendar.set(2002, 0, 11, 0, 0, 0);
        resultDates1[0] = calendar.getTime();
        calendar.clear();
        calendar.set(2002, 0, 11, 2, 0, 0);
        resultDates1[1] = calendar.getTime();
        calendar.clear();
        calendar.set(1981, 1, 12, 3, 17, 0);
        resultDates1[2] = calendar.getTime();
        int i = 0;
        while (i < dateStrings.length) {
            try {
                java.util.Date dateResult = DataTypeUtil.toDate((String)dateStrings[i], (ULocale)ULocale.US, (TimeZone)TimeZone.getTimeZone((String)timeZoneIDs[i]));
                DataTypeUtilTest.assertEquals((Object)dateResult, (Object)resultDates1[i]);
            }
            catch (BirtException birtException) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i;
        }
        calendar = Calendar.getInstance();
        java.util.Date[] resultDates2 = new java.util.Date[3];
        calendar.clear();
        calendar.set(1997, 6, 16, 0, 0, 0);
        resultDates2[0] = calendar.getTime();
        calendar.clear();
        calendar.set(1997, 6, 16, 19, 20, 0);
        resultDates2[1] = calendar.getTime();
        calendar.clear();
        calendar.set(1997, 6, 16, 19, 20, 30);
        resultDates2[2] = calendar.getTime();
        int i2 = 0;
        while (i2 < dateStrings.length) {
            try {
                java.util.Date dateResult = DataTypeUtil.toDate((Object)ISODateStrings[i2]);
                DataTypeUtilTest.assertEquals((Object)dateResult, (Object)resultDates2[i2]);
            }
            catch (BirtException birtException) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i2;
        }
        calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT+00:00"));
        java.util.Date[] resultDates3 = new java.util.Date[3];
        calendar.clear();
        calendar.set(1997, 6, 16, 0, 0, 0);
        resultDates3[0] = calendar.getTime();
        calendar.clear();
        calendar.set(1997, 6, 16, 21, 20, 0);
        resultDates3[1] = calendar.getTime();
        calendar.clear();
        calendar.set(1997, 6, 16, 16, 20, 30);
        resultDates3[2] = calendar.getTime();
        int i3 = 0;
        while (i3 < dateStrings.length) {
            try {
                java.util.Date dateResult = DataTypeUtil.toDate((String)ISODateStrings[i3], (TimeZone)TimeZone.getTimeZone((String)timeZoneIDs[i3]));
                DataTypeUtilTest.assertEquals((Object)dateResult, (Object)resultDates3[i3]);
            }
            catch (BirtException birtException) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i3;
        }
    }

    public void testToTime() throws BirtException {
        String timeValue = "11:15:38";
        Object obj = DataTypeUtil.convert((Object)timeValue, Time.class);
        DataTypeUtilTest.assertEquals((String)timeValue, (String)obj.toString());
    }

    public void testToTimeFailure() {
        String timeValue = "11:15";
        boolean hasException = false;
        try {
            DataTypeUtil.convert((Object)timeValue, Time.class);
        }
        catch (BirtException birtException) {
            hasException = true;
        }
        DataTypeUtilTest.assertTrue((boolean)hasException);
    }

    public void testToDouble() {
        Double result;
        int i = 0;
        while (i < this.testObject.length) {
            block18: {
                try {
                    result = DataTypeUtil.toDouble((Object)this.testObject[i]);
                    if (this.resultDouble[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)("Should throw exception for " + i + "th object"));
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultDouble[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultDouble[i] instanceof Exception) break block18;
                    DataTypeUtilTest.fail((String)("Should not throw exception for " + i + "th object"));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.testObjectDouble.length) {
            try {
                result = DataTypeUtil.toDouble((Object)this.testObjectDouble[i]);
                if (this.resultObjectDouble[i] instanceof Exception) {
                    DataTypeUtilTest.fail((String)("Should throw exception for " + i + "th object"));
                }
                DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultObjectDouble[i]);
            }
            catch (BirtException birtException) {
                if (!(this.resultObjectDouble[i] instanceof Exception)) {
                    DataTypeUtilTest.fail((String)("Should not throw exception for " + i + "th object"));
                }
            }
            catch (Exception exception) {
                DataTypeUtilTest.fail((String)"Should throw BirtException.");
            }
            ++i;
        }
        try {
            DataTypeUtilTest.assertTrue((Double.POSITIVE_INFINITY == DataTypeUtil.toDouble((Object)Double.POSITIVE_INFINITY) ? 1 : 0) != 0);
            DataTypeUtilTest.assertTrue((Double.NEGATIVE_INFINITY == DataTypeUtil.toDouble((Object)Double.NEGATIVE_INFINITY) ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            DataTypeUtilTest.fail((String)"Should not throw exception ");
        }
        try {
            result = DataTypeUtil.toDouble((Object)Float.valueOf(Float.POSITIVE_INFINITY));
            DataTypeUtilTest.fail((String)"Should throw exception ");
        }
        catch (BirtException birtException) {}
        try {
            result = DataTypeUtil.toDouble((Object)new BigDecimal("1.7976931348623157e+309"));
            DataTypeUtilTest.fail((String)"Should throw exception ");
        }
        catch (BirtException birtException) {}
        try {
            result = DataTypeUtil.toDouble((Object)new BigDecimal("1.7976931348623157e+309").negate());
            DataTypeUtilTest.fail((String)"Should throw exception ");
        }
        catch (BirtException birtException) {}
    }

    public void testToStringObject() {
        int i = 0;
        while (i < this.testObject.length) {
            block7: {
                try {
                    String result = DataTypeUtil.toString((Object)this.testObject[i]);
                    if (this.resultString[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    if (this.testObject[i] instanceof Double) {
                        result = DataTypeUtil.toDouble((Object)result).toString();
                    } else if (this.testObject[i] instanceof Integer || this.testObject[i] instanceof BigDecimal) {
                        result = DataTypeUtil.toInteger((Object)result).toString();
                    }
                    DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultString[i]);
                }
                catch (BirtException birtException) {
                    if (this.resultString[i] instanceof Exception) break block7;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
    }

    public void testToLocaleNeutralStringObject() {
        int i = 0;
        while (i < this.testObject.length) {
            block9: {
                try {
                    String result = DataTypeUtil.toLocaleNeutralString((Object)this.testObject[i]);
                    if (this.resultLocaleNeutralString[i] instanceof Exception) {
                        DataTypeUtilTest.fail((String)"Should throw Exception.");
                    }
                    if (this.testObject[i] instanceof Double) {
                        result = DataTypeUtil.toDouble((Object)result).toString();
                    } else if (this.testObject[i] instanceof Integer || this.testObject[i] instanceof BigDecimal) {
                        result = DataTypeUtil.toInteger((Object)result).toString();
                    }
                    if (i == 9) {
                        DataTypeUtilTest.assertEquals((Object)result.replaceFirst("\\Q+\\E.*", ""), (Object)this.resultLocaleNeutralString[i]);
                    } else {
                        DataTypeUtilTest.assertEquals((Object)result, (Object)this.resultLocaleNeutralString[i]);
                    }
                }
                catch (BirtException birtException) {
                    if (this.resultLocaleNeutralString[i] instanceof Exception) break block9;
                    DataTypeUtilTest.fail((String)"Should not throw Exception.");
                }
            }
            ++i;
        }
    }

    public void testToDateWithCheck() {
        String dateStr = "25/11/16";
        Locale locale = Locale.UK;
        try {
            DataTypeUtil.toDateWithCheck((String)dateStr, (Locale)locale);
        }
        catch (BirtException birtException) {
            DataTypeUtilTest.fail((String)"should not throw Exception");
        }
        dateStr = "25/13/16";
        locale = Locale.UK;
        try {
            DataTypeUtil.toDateWithCheck((String)dateStr, (Locale)locale);
            DataTypeUtilTest.fail((String)"should throw Exception");
        }
        catch (BirtException birtException) {}
        dateStr = "2005/11/11";
        locale = Locale.UK;
        try {
            DataTypeUtil.toDateWithCheck((String)dateStr, (Locale)locale);
            DataTypeUtilTest.fail((String)"should throw Exception");
        }
        catch (BirtException birtException) {}
        dateStr = "2005-11-11";
        locale = Locale.CHINA;
        try {
            DataTypeUtil.toDateWithCheck((String)dateStr, (Locale)locale);
        }
        catch (BirtException birtException) {
            DataTypeUtilTest.fail((String)"should throw Exception");
        }
        dateStr = "11-11-2005";
        locale = Locale.CHINA;
        try {
            DataTypeUtil.toDateWithCheck((String)dateStr, (Locale)locale);
            DataTypeUtilTest.fail((String)"should throw Exception");
        }
        catch (BirtException birtException) {}
    }

    public void testToAutoValue() {
        int i = 0;
        while (i < this.autoValueInputObject.length) {
            try {
                Object result = DataTypeUtil.toAutoValue((Object)this.autoValueInputObject[i]);
                DataTypeUtilTest.assertEquals((Object)result, (Object)this.autoValueExpectedResult[i]);
            }
            catch (Exception exception) {
                DataTypeUtilTest.fail((String)"Should not throw Exception.");
            }
            ++i;
        }
    }

    public void testToStringAndDate() {
        java.util.Date date = new GregorianCalendar(1998, 0, 25).getTime();
        String str = "1/25/1998";
        try {
            DataTypeUtilTest.assertEquals((Object)DataTypeUtil.toDate((Object)str), (Object)date);
            DataTypeUtilTest.assertEquals((String)DataTypeUtil.toString((Object)DataTypeUtil.toDate((Object)str)), (String)DataTypeUtil.toString((Object)date));
        }
        catch (BirtException birtException) {
            DataTypeUtilTest.fail((String)"Should not throw Exception.");
        }
    }

    public void testConvert() throws BirtException {
        Date date = Date.valueOf("2006-1-1");
        Object ob = DataTypeUtil.convert((Object)date, Date.class);
        DataTypeUtilTest.assertEquals((Object)date, (Object)ob);
    }

    public void testConvert2() throws BirtException {
        WrappedObject obj = new WrappedObject();
        Object ob = DataTypeUtil.convert((Object)((Object)obj), (int)0);
        DataTypeUtilTest.assertEquals((Object)"I am an unwrapped object", (Object)ob);
    }

    public void testToApiFromOdaDataType() throws BirtException {
        DataTypeUtilTest.assertEquals((int)5, (int)DataTypeUtil.toApiDataType((int)1));
        DataTypeUtilTest.assertEquals((int)2, (int)DataTypeUtil.toApiDataType((int)4));
        DataTypeUtilTest.assertEquals((int)3, (int)DataTypeUtil.toApiDataType((int)8));
        DataTypeUtilTest.assertEquals((int)4, (int)DataTypeUtil.toApiDataType((int)3));
        DataTypeUtilTest.assertEquals((int)9, (int)DataTypeUtil.toApiDataType((int)91));
        DataTypeUtilTest.assertEquals((int)10, (int)DataTypeUtil.toApiDataType((int)92));
        DataTypeUtilTest.assertEquals((int)6, (int)DataTypeUtil.toApiDataType((int)93));
        DataTypeUtilTest.assertEquals((int)7, (int)DataTypeUtil.toApiDataType((int)2004));
        DataTypeUtilTest.assertEquals((int)5, (int)DataTypeUtil.toApiDataType((int)2005));
        DataTypeUtilTest.assertEquals((int)-1, (int)DataTypeUtil.toApiDataType((int)0));
        boolean hasException = false;
        try {
            DataTypeUtil.toApiDataType((int)1111);
        }
        catch (BirtException birtException) {
            hasException = true;
        }
        DataTypeUtilTest.assertTrue((boolean)hasException);
    }

    class WrappedObject
    extends BaseScriptable
    implements Wrapper {
        WrappedObject() {
        }

        public Object unwrap() {
            return "I am an unwrapped object";
        }

        public Object get(String name, Scriptable start) {
            return "I am an unwrapped object";
        }

        public String getClassName() {
            return "WrappedObject";
        }

        public boolean has(String name, Scriptable start) {
            return true;
        }

        public void put(String name, Scriptable start, Object value) {
        }
    }
}

