/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.core.data.ExpressionParserUtility;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.Messages;
import org.eclipse.birt.core.exception.BirtException;

public class ExpressionParserUtilityTest
extends TestCase {
    String[] oldExpressions;

    public ExpressionParserUtilityTest() {
        String[] stringArray = new String[13];
        stringArray[1] = "   " + Messages.getString("ExpressionUtilTest.old.0");
        stringArray[2] = Messages.getString("ExpressionUtilTest.old.1");
        stringArray[3] = Messages.getString("ExpressionUtilTest.old.2");
        stringArray[4] = Messages.getString("ExpressionUtilTest.old.3");
        stringArray[5] = Messages.getString("ExpressionUtilTest.old.4");
        stringArray[6] = Messages.getString("ExpressionUtilTest.old.5");
        stringArray[7] = Messages.getString("ExpressionUtilTest.old.6");
        stringArray[8] = Messages.getString("ExpressionUtilTest.old.7");
        stringArray[9] = Messages.getString("ExpressionUtilTest.old.8");
        stringArray[10] = Messages.getString("ExpressionUtilTest.old.9");
        stringArray[11] = Messages.getString("ExpressionUtilTest.old.10");
        stringArray[12] = Messages.getString("ExpressionUtilTest.old.11");
        this.oldExpressions = stringArray;
    }

    public void testExpression1() {
        String expression = this.oldExpressions[1];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression2() {
        String expression = this.oldExpressions[2];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression3() {
        String expression = this.oldExpressions[3];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression4() {
        String expression = this.oldExpressions[4];
        try {
            ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.fail((String)"Should throw a BirtException.");
        }
        catch (BirtException birtException) {}
    }

    public void testExpression5() {
        String expression = this.oldExpressions[5];
        try {
            ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.fail((String)"Should throw a BirtException.");
        }
        catch (BirtException birtException) {}
    }

    public void testExpression6() {
        String expression = this.oldExpressions[6];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression7() {
        String expression = this.oldExpressions[7];
        try {
            ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.fail((String)"Should throw a BirtException.");
        }
        catch (BirtException birtException) {}
    }

    public void testExpression8() {
        String expression = this.oldExpressions[8];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression9() {
        String expression = this.oldExpressions[9];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression10() {
        String expression = this.oldExpressions[10];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression11() {
        String expression = this.oldExpressions[11];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression12() {
        String expression = this.oldExpressions[12];
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testAggregationExpression13() {
        String expression = "row[\"customer\"].replace(\"aa\",\"bb\")";
        String expression2 = "( row[\"customer\"]+ row.customer ).replace(\"aa\",\"bb\")";
        String expression3 = "( row[\"customer\"]+ row.customer ).replace(row.aaa.replace(\"aa\",\"bb\"), row.bbb );";
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression2);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression3);
            ExpressionParserUtilityTest.assertTrue((list.size() == 4 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testAggregationExpression14() {
        String expression = "row._outer[\"aaa\"]";
        String expression2 = "row._outer._outer._outer[\"aaa\"]";
        String expression3 = "row._outer._outer._outer._outer[\"aaa\"]+ row._outer[\"bbb\"] + 123";
        String expression4 = "row._outer._outer._outer._outer.__rownum + row._outer[\"bbb\"]/row.aaa + 123";
        String expression5 = "Total.sum(row._outer._outer.aaa) + Total.sum(row._outer._outer.aaa + 1 ) +Total.ave( row._rownum._outer.bbb)";
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(0)).getResultSetColumnName().equals("aaa"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(0)).getOuterLevel() == 1 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression2);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(0)).getResultSetColumnName().equals("aaa"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(0)).getOuterLevel() == 3 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression3);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(0)).getResultSetColumnName().equals("aaa"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(0)).getOuterLevel() == 4 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(1)).getResultSetColumnName().equals("bbb"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(1)).getOuterLevel() == 1 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression4);
            ExpressionParserUtilityTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(0)).getResultSetColumnName().equals("__rownum"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(0)).getOuterLevel() == 4 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(1)).getResultSetColumnName().equals("bbb"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(1)).getOuterLevel() == 1 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)((IColumnBinding)list.get(2)).getResultSetColumnName().equals("aaa"));
            ExpressionParserUtilityTest.assertTrue((((IColumnBinding)list.get(2)).getOuterLevel() == 0 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression5);
            ExpressionParserUtilityTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"An exception occurs");
        }
    }

    public void testHasAggregation() {
        String expression0 = "Totla.aaa(ccc)+ ";
        String expression1 = "row[\"customer\"].replace(\"aa\",\"bb\")";
        String expression2 = "Total.sum(row.aaa)";
        String expression3 = "row.aaa+Total.runningSum( row.bbb+ row.ccc ) + row.eee";
        String expression4 = "row.aaa+Total.runningSum( Total.sum(row.aaa)+ row.ccc ) + row.eee";
        try {
            ExpressionParserUtility.hasAggregation((String)expression0);
            ExpressionParserUtilityTest.fail((String)"Should not get here");
        }
        catch (BirtException birtException) {}
        try {
            ExpressionParserUtilityTest.assertTrue((!ExpressionParserUtility.hasAggregation((String)expression1) ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)ExpressionParserUtility.hasAggregation((String)expression2));
            ExpressionParserUtilityTest.assertTrue((boolean)ExpressionParserUtility.hasAggregation((String)expression3));
            ExpressionParserUtilityTest.assertTrue((boolean)ExpressionParserUtility.hasAggregation((String)expression4));
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)" An exception occurs");
        }
    }

    public void testHasCarriageReturn() {
        String expression0 = "if(row.aaa>0)  \r\n row.bbb = Total.sum(row.aaa) \n else row.bbb=Total.sum(row.aaa)";
        String expression1 = " function a( ){ if(row.aaa>0) row.ccc = Total.sum(row.bbb);}";
        String expression2 = "if (row[\"STATE\"])\n{\n   row[\"CITY\"] + \", \" + row[\"STATE\"] + \" - \" + row[\"POSTALCODE\"];\n}\nelse\n{\n   row[\"CITY\"] + \", \" + row[\"POSTALCODE\"];\n}";
        String expression3 = "row[\"aaa\"]= \nrow.bbb";
        String expression4 = "if (Total.sum( row[\"CUSTOMERNUMBER\"])>1)  Total.sum( row[\"CUSTOMERNUMBER_1\"]); else \"bbb\";";
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression0);
            ExpressionParserUtilityTest.assertTrue((list.size() == 5 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression1);
            ExpressionParserUtilityTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression2);
            ExpressionParserUtilityTest.assertTrue((list.size() == 6 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression3);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression4);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"should not get there ");
        }
    }

    public void testRows0Expr() {
        String expression0 = "rows[0][\"aaa\"] = 0";
        String expression1 = "if(row.aaa>0)  \r\n row.bbb = Total.sum(rows[0][\"aaa\"]) \n else row.bbb=Total.sum(row.aaa)";
        String expression2 = " function a( ){ if(row.aaa>0) rows[0][\"ccc\"] = Total.sum(row.bbb);}";
        String expression3 = "if (row[\"STATE\"])\n{\n   rows[0][\"CITY\"] + \", \" + row[\"STATE\"] + \" - \" + row[\"POSTALCODE\"];\n}\nelse\n{\n   row[\"CITY\"] + \", \" + row[\"POSTALCODE\"];\n}";
        String expression4 = "row[\"aaa\"]= \nrows[0][\"bbb\"]";
        String expression5 = "if (Total.sum( rows[0][\"CUSTOMERNUMBER\"])>1)  Total.sum( row[\"CUSTOMERNUMBER_1\"]); else \"bbb\";";
        String expression6 = "rows[1][\"bbb\"]=1; rows[0][\"aaa\"] = 5;";
        String expression7 = "rows[0][\"aaa\"][\"bbb\"]+5";
        try {
            List list = ExpressionParserUtility.compileColumnExpression((String)expression0);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            ExpressionParserUtilityTest.assertTrue((boolean)"aaa".equals(((IColumnBinding)list.get(0)).getResultSetColumnName()));
            ExpressionParserUtilityTest.assertTrue((boolean)"dataSetRow[\"aaa\"]".equals(((IColumnBinding)list.get(0)).getBoundExpression()));
            ExpressionParserUtilityTest.assertTrue((1 == ((IColumnBinding)list.get(0)).getOuterLevel() ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression1);
            ExpressionParserUtilityTest.assertTrue((list.size() == 5 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression2);
            ExpressionParserUtilityTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression3);
            ExpressionParserUtilityTest.assertTrue((list.size() == 6 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression4);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression5);
            ExpressionParserUtilityTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression6);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            list = ExpressionParserUtility.compileColumnExpression((String)expression7);
            ExpressionParserUtilityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionParserUtilityTest.fail((String)"should not get there ");
        }
    }
}

