/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.NativeNamedList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class NativeNamedListTest
extends TestCase {
    Context cx;
    Scriptable scope;
    boolean hasException;
    StringBuffer buffer = new StringBuffer();

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.registerBeans();
    }

    public void tearDown() {
        Context.exit();
    }

    protected Object evaluate(String script) {
        try {
            this.hasException = false;
            return this.cx.evaluateString(this.scope, script, "inline", 1, null);
        }
        catch (Throwable throwable) {
            this.hasException = true;
            return null;
        }
    }

    protected void registerBeans() {
        String[] names = new String[]{"a", "b", "c", "d"};
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("a", new Integer(123));
        values.put("b", "STRING");
        values.put("c", new Date());
        values.put("d", null);
        NativeNamedList params = new NativeNamedList(this.scope, names, values);
        this.scope.put("params", this.scope, (Object)params);
        this.scope.put("buffer", this.scope, Context.javaToJS((Object)this.buffer, (Scriptable)this.scope));
    }

    public void testIn() {
        String script = "for (var a in params) { buffer.append(a); }";
        this.buffer.setLength(0);
        this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((String)"abcd", (String)this.buffer.toString());
    }

    public void testLength() {
        String script = "params.length";
        Object value = this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((int)4, (int)((Number)value).intValue());
    }

    public void testNameAccess() {
        String script = "params['a'] + params.b";
        Object value = this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((String)"123STRING", (String)value.toString());
    }

    public void testIndexAccess() {
        String script = "params[0] + params[params.length-3]";
        Object value = this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((String)"123STRING", (String)value.toString());
    }

    public void testEntryName() {
        String script = "params[0].name";
        Object value = this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((String)"a", (String)value.toString());
    }

    public void testEntryValue() {
        String script = "params[0].value + params[0]";
        Object value = this.evaluate(script);
        NativeNamedListTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeNamedListTest.assertEquals((int)246, (int)((Number)value).intValue());
    }
}

