/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtDateTimeTest
extends TestCase {
    private Context cx;
    private Scriptable scope;

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    public void tearDown() {
        Context.exit();
    }

    public void testYear() {
        String script1 = "BirtDateTime.year(new Date(23,11,11))";
        BirtDateTimeTest.assertTrue((((Number)this.cx.evaluateString(this.scope, script1, "inline", 1, null)).intValue() == 1923 ? 1 : 0) != 0);
    }

    public void testQuarter() {
        String script1 = "BirtDateTime.quarter(\"1905-10-11\")";
        String script2 = "BirtDateTime.quarter( new Date( 05,11,15))";
        String script3 = "BirtDateTime.quarter(\"1900-3-15\")";
        String script4 = "BirtDateTime.quarter( new Date( 0,11,15))";
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script1, "inline", 1, null)).intValue(), (int)4);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script2, "inline", 1, null)).intValue(), (int)4);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script3, "inline", 1, null)).intValue(), (int)1);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script4, "inline", 1, null)).intValue(), (int)4);
    }

    public void testMonthDate() {
        String script1 = "BirtDateTime.month(new Date(75,0,15),1)";
        String script2 = "BirtDateTime.month( new Date( 105,11,15),1)";
        String script3 = "BirtDateTime.month(\"1900-3-15\",1)";
        String script4 = "BirtDateTime.month( new Date( 10,11,15),1)";
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)"1");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (String)"12");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script3, "inline", 1, null)), (String)"3");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script4, "inline", 1, null)), (String)"12");
    }

    public void testWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.week(new Date(2006, 0, 1) )", "BirtDateTime.week(new Date(2006, 0, 3) )", "BirtDateTime.week(new Date(2006, 0, 7) )", "BirtDateTime.week(new Date(2006, 0, 8) )", "BirtDateTime.week(new Date(2006, 0, 14))", "BirtDateTime.week(\"1855-1-1\")", "BirtDateTime.week( new Date(1780, 0, 2))", "BirtDateTime.week(new Date(1780, 0, 8))", "BirtDateTime.week(new Date(1780, 0, 9))", "BirtDateTime.week(new Date(1780, 1, 9))", "BirtDateTime.week( new Date(1780, 2, 9))", "BirtDateTime.week(new Date(1780, 3, 9, 11, 0, 0) )", "BirtDateTime.week(new Date(1780, 4, 9, 23, 0, 0) )"};
        int[] values = new int[]{1, 1, 1, 2, 2, 1, 2, 2, 3, 7, 11, 16, 20};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.day(new Date(2006, 0, 1) )", "BirtDateTime.day(new Date(2006, 0, 3) )", "BirtDateTime.day( new Date(1780, 0, 1))", "BirtDateTime.day(new Date(1780, 3, 9, 11, 0, 0) )", "BirtDateTime.day(new Date(1780, 4, 9, 23, 0, 0) )"};
        int[] values = new int[]{1, 3, 1, 9, 9};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testWeekDayDate() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.weekDay(new Date(2006, 0, 1), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 1 )", "BirtDateTime.weekDay(new Date(1780, 0, 1))", "BirtDateTime.weekDay(new Date(1780, 0, 2))", "BirtDateTime.weekDay(new Date(1780, 0, 8))", "BirtDateTime.weekDay(new Date(1780, 0, 9))", "BirtDateTime.weekDay(new Date(2006, 0, 1), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 2 )", "BirtDateTime.weekDay(new Date(1780, 0, 1), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 2), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 8), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 9), 2)", "BirtDateTime.weekDay(new Date(2006, 0, 1), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 3 )", "BirtDateTime.weekDay(new Date(1780, 0, 1), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 2), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 8), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 9), 3)"};
        String[] values = new String[]{"1", "3", "7", "1", "7", "1", "7", "1", "7", "2", "6", "7", "6", "7", "6", "7", "6", "1", "5", "6", "5", "6", "5", "6"};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testToday() {
        Calendar c = Calendar.getInstance();
        c.clear();
        Date d = (Date)this.cx.evaluateString(this.scope, "BirtDateTime.today()", "inline", 1, null);
        c.setTime(d);
        System.out.println("year:" + c.get(1) + " month:" + c.get(2) + " day:" + c.get(5) + " hour:" + c.get(10));
    }

    public void testNow() {
        Calendar c = Calendar.getInstance();
        c.clear();
        Date d = (Date)this.cx.evaluateString(this.scope, "BirtDateTime.now()", "inline", 1, null);
        c.setTime(d);
        System.out.println("year:" + c.get(1) + " month:" + c.get(2) + " day:" + c.get(5) + " hour:" + c.get(10) + " minute:" + c.get(12) + "second:" + c.get(13));
    }

    public void testDiffYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 0, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffYear(new Date(2007, 10, 15),new Date(2005, 0, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(1793, 0, 15) )"};
        int[] values = new int[]{2, 2, 3, -2, -212};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 0, 8) )", "BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffMonth(new Date(2007, 10, 15),new Date(2005, 0, 1) )", "BirtDateTime.diffMonth(new Date(1910, 10, 15),new Date(1890, 0, 15) )"};
        int[] values = new int[]{14, 25, 26, -34, -250};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 0, 8) )", "BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffQuarter(new Date(2007, 10, 15),new Date(2005, 0, 1) )", "BirtDateTime.diffQuarter(new Date(1910, 10, 15),new Date(1890, 0, 15) )"};
        int[] values = new int[]{5, 8, 9, -11, -83};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffWeek(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 7) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 8) )", "BirtDateTime.diffWeek(new Date(1779, 11, 31),new Date(1780, 0, 1) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1),new Date(1780, 0, 2) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1),new Date(1780, 0, 8) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1),new Date(1780, 0, 9) )"};
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[4] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        int[] values = nArray;
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffDay(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 2, 7) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 2, 8) )", "BirtDateTime.diffDay(new Date(1793, 0, 1),new Date(1794, 2, 8) )"};
        int[] values = new int[]{-2, -1, 2, 37, 65, 66, 431};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffHour() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffHour(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 2, 7,11,2,0) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 2, 8,22,0,0) )", "BirtDateTime.diffHour(new Date(1793, 0, 1),new Date(1794, 2, 8) )"};
        int[] values = new int[]{-48, -24, 48, 888, 1571, 1606, 10344};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffMinute() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffMinute(\"1930-1-8 12:1:1\",\"1930-1-8 12:2:58\" )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 2, 7,11,2,0) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 2, 8,22,3,0) )", "BirtDateTime.diffMinute(\"1993-1-1\",new Date(1994, 2, 8) )"};
        int[] values = new int[]{1, -1440, 2880, 53280, 94262, 96363, 620640};
        int i = 0;
        while (i < values.length) {
            System.out.println(i);
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testDiffSecond() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffSecond(new Date(1900, 0, 8,12,1,1),new Date(1900, 0, 8,12,2,58) )", "BirtDateTime.diffSecond(new Date(1900, 0, 8,12,1,58),new Date(1900, 0, 8,12,2,1) )", "BirtDateTime.diffSecond(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffSecond(new Date(2006, 0, 1),new Date(2006, 2, 8,22,3,0) )", "BirtDateTime.diffSecond(\"1993-1-1\",new Date(1994, 2, 8) )"};
        int[] values = new int[]{117, 3, 172800, 5781780, 37238400};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    public void testAddYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addYear(new Date(2005, 10, 15),10 )", "BirtDateTime.addYear(new Date(1795, 10, 15),10 )", "BirtDateTime.addYear(\"1910-11-15\",10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2015, 10, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1805, 10, 15, 0, 0, 0);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1920, 10, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 1;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addMonth(new Date(2005, 10, 15),10 )", "BirtDateTime.addMonth(\"1995-1-15\",10 )", "BirtDateTime.addMonth(\"1940-2-15\",11 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2006, 8, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1941, 0, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addQuarter(new Date(2005, 10, 15),2 )", "BirtDateTime.addQuarter(\"1995-1-15\",9 )", "BirtDateTime.addQuarter(\"1930-6-15\",11 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2006, 4, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1997, 3, 15);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1933, 2, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addWeek(new Date(2005, 10, 15),1 )", "BirtDateTime.addWeek(new Date(2006, 9, 15),3 )", "BirtDateTime.addWeek(\"1995-11-15\",2 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 29);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addDay(new Date(2005, 10, 15),7 )", "BirtDateTime.addDay(new Date(2006, 9, 15),21 )", "BirtDateTime.addDay(\"1995-11-15\",10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 25);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddHour() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addHour(new Date(2005, 10, 15),7*24 )", "BirtDateTime.addHour(new Date(2006, 9, 15),21*24 )", "BirtDateTime.addHour(\"1995-11-15\",10 )", "BirtDateTime.addHour(null,21*24 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15, 10, 0, 0);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1970, 0, 22, 0, 0, 0);
        c.clear();
        Date[] dateArray = new Date[4];
        dateArray[0] = d1;
        dateArray[1] = d2;
        dateArray[2] = d3;
        Date[] values = dateArray;
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddMinute() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addMinute(new Date(2005, 10, 15),7*24*60 )", "BirtDateTime.addMinute(new Date(2006, 9, 15),21*24*60 )", "BirtDateTime.addMinute(\"1995-11-15\",10*60+10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15, 10, 10, 0);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    public void testAddSecond() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addSecond(new Date(2005, 10, 15),7*24*60*60 )", "BirtDateTime.addSecond(new Date(2006, 9, 15),21*24*60*60 )", "BirtDateTime.addSecond(\"1995-11-15\",(10*60+10)*60+9 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15, 10, 10, 9);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }
}

