/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtDurationTest
extends TestCase {
    private Context cx;
    private Scriptable scope;

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    public void tearDown() {
        Context.exit();
    }

    public void testAdd() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.add( \"P1Y2M1D\", \"P1Y2M2D\" )";
        String script2 = "BirtDuration.add( \"P1Y2M1DT3S\", \"P1Y2M2D\" )";
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (Object)BirtDurationTest.toDuration("P2Y4M3D"));
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (Object)BirtDurationTest.toDuration("P2Y4M3DT3S"));
    }

    public void testAddTo() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.addTo( \"P1Y2M1D\", new Date(53,11,11) )";
        String script2 = "BirtDuration.addTo( \"P1Y2M1DT3S\", new Date(53,11,11) )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)new Date(55, 1, 12));
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)new Date(55, 1, 12, 0, 0, 3));
    }

    public void testTimeInMills() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.timeInMills( \"PT1S\", new Date(53,11,11) )";
        String script2 = "BirtDuration.timeInMills( \"PT3S\", new Date(53,11,11) )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)1000L);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)3000L);
    }

    public void testSubstract() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.subtract( \"P1Y2M1D\", \"P1Y2M2D\" )";
        String script2 = "BirtDuration.subtract( \"P1Y2M2DT3S\", \"P1Y2M2D\" )";
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (Object)BirtDurationTest.toDuration("-P1D"));
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (Object)BirtDurationTest.toDuration("PT3S"));
    }

    public void testMultiply() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.multiply( \"P1Y2M1D\", 1 )";
        String script2 = "BirtDuration.multiply( \"P1Y2M2DT3S\", 2 )";
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (Object)BirtDurationTest.toDuration("P1Y2M1D"));
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (Object)BirtDurationTest.toDuration("P2Y4M4DT6S"));
    }

    public void testCompare() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.compare( \"P1Y2M1D\", \"P1Y2M2D\" )";
        String script2 = "BirtDuration.compare( \"P1Y2M2DT3S\", \"P1Y2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)-1);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)0);
    }

    public void testIsLongerThan() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.isLongerThan( \"P1Y2M3D\", \"P1Y2M2D\" )";
        String script2 = "BirtDuration.isLongerThan( \"P1Y2M2DT2S\", \"P1Y2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)true);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)false);
    }

    public void testIsShorterThan() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.isShorterThan( \"P1Y2M3D\", \"P1Y2M2D\" )";
        String script2 = "BirtDuration.isShorterThan( \"P1Y2M2DT2S\", \"P1Y2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)false);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)true);
    }

    public void testGetSign() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.getSign( \"-P1Y2M1D\" )";
        String script2 = "BirtDuration.getSign( \"P1Y2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)-1);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)1);
    }

    public void testNegate() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.negate( \"-P1Y2M1D\" )";
        String script2 = "BirtDuration.negate( \"P1Y2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (Object)BirtDurationTest.toDuration("P1Y2M1D"));
        BirtDurationTest.assertEquals((Object)BirtDurationTest.toDuration((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (Object)BirtDurationTest.toDuration("-P1Y2M2DT3S"));
    }

    public void testYear() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.year( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.year( \"P2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)1);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)0);
    }

    public void testMonth() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.month( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.month( \"P2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)2);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)0);
    }

    public void testDay() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.day( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.day( \"P2M2DT3S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)1);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)2);
    }

    public void testHour() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.hour( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.hour( \"P2M2DT4H\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)0);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)4);
    }

    public void testMinute() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.minute( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.minute( \"P2M2DT4M\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)0);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)4);
    }

    public void testSecond() throws DatatypeConfigurationException {
        String script1 = "BirtDuration.second( \"P1Y2M1D\" )";
        String script2 = "BirtDuration.second( \"P2M2DT4S\" )";
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)0);
        BirtDurationTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)4);
    }

    private static Duration toDuration(String arg) throws DatatypeConfigurationException {
        Duration duration = DatatypeFactory.newInstance().newDuration(arg);
        return duration;
    }
}

