/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;

public class CmdBaseTestCase
extends BaseTestCase {
    protected TableHandle table;
    protected TableHandleAdapter adapter;
    protected RowHandle firstRow;
    protected RowHandle secondRow;
    protected CellHandle firstCell;
    protected CellHandle secondCell;
    protected DataItemHandle dataItem;
    protected ColumnHandle firstColumn;
    protected DataSourceHandle dataSource;
    protected DataSetHandle dataSet;
    protected static final String TEST_TABLE_NAME = "Table";
    protected static final String DATA_SOURCE_NAME = "Data Source";
    protected static final String DATA_SET_NAME = "Data Set";

    protected void setUp() throws Exception {
        super.setUp();
        this.table = this.getElementFactory().newTableItem(TEST_TABLE_NAME);
        this.getReportDesignHandle().getBody().add((DesignElementHandle)this.table);
        this.adapter = new TableHandleAdapter((ReportItemHandle)this.table, null);
    }

    protected void tearDown() throws SemanticException {
        this.clearAll(this.getReportDesignHandle().getBody());
        this.clearAll(this.getReportDesignHandle().getDataSources());
        this.clearAll(this.getReportDesignHandle().getDataSets());
        this.dataItem = null;
        this.firstColumn = null;
        this.secondCell = null;
        this.firstCell = null;
        this.secondRow = null;
        this.firstRow = null;
        this.adapter = null;
        this.table = null;
        this.dataSource = null;
    }

    protected ElementFactory getElementFactory() {
        return this.getReportDesignHandle().getElementFactory();
    }

    protected void createFirstRow() {
        SlotHandle container = this.table.getDetail();
        this.firstRow = this.getElementFactory().newTableRow();
        HashMap<String, RowHandle> map = new HashMap<String, RowHandle>();
        map.put("newObject", this.firstRow);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)container);
        command.execute();
    }

    protected void createSecondRow() {
        this.secondRow = this.getElementFactory().newTableRow();
        HashMap<String, RowHandle> map = new HashMap<String, RowHandle>();
        map.put("newObject", this.secondRow);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)this.table.getDetail());
        command.setAfter((Object)this.firstRow);
        command.execute();
    }

    protected void createFirstCell() {
        this.firstCell = this.getElementFactory().newCell();
        try {
            this.firstCell.setColumn(1);
        }
        catch (SemanticException e) {
            e.printStackTrace();
            CmdBaseTestCase.fail((String)"setColumn 1");
        }
        HashMap<String, CellHandle> map = new HashMap<String, CellHandle>();
        map.put("newObject", this.firstCell);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)this.firstRow);
        command.execute();
    }

    protected void createSecondCell() {
        this.secondCell = this.getElementFactory().newCell();
        try {
            this.secondCell.setColumn(2);
        }
        catch (SemanticException e) {
            e.printStackTrace();
            CmdBaseTestCase.fail((String)"set Column 2");
        }
        HashMap<String, CellHandle> map = new HashMap<String, CellHandle>();
        map.put("newObject", this.secondCell);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)this.firstRow);
        command.setAfter((Object)this.firstCell);
        command.execute();
    }

    protected void addDataItems() {
        this.dataItem = this.getElementFactory().newDataItem("DataItem1");
        HashMap<String, DataItemHandle> map = new HashMap<String, DataItemHandle>();
        map.put("newObject", this.dataItem);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)this.firstCell);
        command.execute();
    }

    protected void createColumn() {
        this.firstColumn = this.getElementFactory().newTableColumn();
        try {
            this.table.getColumns().add((DesignElementHandle)this.firstColumn);
        }
        catch (ContentException e) {
            e.printStackTrace();
        }
        catch (NameException e) {
            e.printStackTrace();
            CmdBaseTestCase.fail((String)"create Column failed");
        }
    }

    protected void createDataSource() {
        this.dataSource = this.getElementFactory().newOdaDataSource(DATA_SOURCE_NAME);
        HashMap<String, DataSourceHandle> map = new HashMap<String, DataSourceHandle>();
        map.put("newObject", this.dataSource);
        CreateCommand command = new CreateCommand(map);
        SlotHandle parent = this.getReportDesignHandle().getDataSources();
        command.setParent((Object)parent);
        command.execute();
    }

    protected void createDataSet() {
        this.dataSet = this.getElementFactory().newOdaDataSet(DATA_SET_NAME);
        HashMap<String, DataSetHandle> map = new HashMap<String, DataSetHandle>();
        map.put("newObject", this.dataSet);
        CreateCommand command = new CreateCommand(map);
        SlotHandle parent = this.getReportDesignHandle().getDataSets();
        command.setParent((Object)parent);
        command.execute();
        if (this.dataSource == null) {
            this.createDataSource();
        }
        try {
            this.dataSet.setDataSource(DATA_SOURCE_NAME);
        }
        catch (SemanticException e) {
            e.printStackTrace();
            CmdBaseTestCase.fail((String)"add data source to dataset");
        }
    }

    protected void clearAll(SlotHandle handle) throws SemanticException {
        int i = 0;
        while (i < handle.getCount()) {
            handle.drop(0);
            ++i;
        }
    }
}

