/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.commands.SetPropertyCommand;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class SetPropertyCommandTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSetLabelProperty() {
        LabelHandle label = this.getReportDesignHandle().getElementFactory().newLabel("Label");
        try {
            label.setText("Label Test");
        }
        catch (SemanticException e) {
            e.printStackTrace();
            SetPropertyCommandTest.fail((String)"Set label text");
        }
        SetPropertyCommandTest.assertTrue((boolean)label.getText().equals("Label Test"));
        HashMap<String, String> extendsData = new HashMap<String, String>();
        extendsData.put("labelContent", "New Test");
        SetPropertyCommand cmd = new SetPropertyCommand((Object)label, extendsData);
        cmd.execute();
        SetPropertyCommandTest.assertTrue((boolean)label.getText().equals("New Test"));
    }

    public void testSetTextProperty() {
        TextItemHandle text = this.getReportDesignHandle().getElementFactory().newTextItem("Text");
        try {
            text.setContent("TextItem Test");
        }
        catch (SemanticException e) {
            e.printStackTrace();
            SetPropertyCommandTest.fail((String)"Set TextItem Content");
        }
        SetPropertyCommandTest.assertTrue((boolean)text.getContent().equals("TextItem Test"));
        HashMap<String, String> extendsData = new HashMap<String, String>();
        extendsData.put("labelContent", "New TextItem Test");
        SetPropertyCommand cmd = new SetPropertyCommand((Object)text, extendsData);
        cmd.execute();
        SetPropertyCommandTest.assertTrue((boolean)text.getContent().equals("New TextItem Test"));
    }
}

