/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.tests.data.engine.api;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.APITestCase;
import testutil.ConfigText;

public class MultiPass_NestedQueryTest
extends APITestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(this, ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void test_NestedAggregation() throws Exception {
        String sqlStatement = "select COUNTRY,AMOUNT,SALE_DATE from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(sqlStatement);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0)};
        String[] names = new String[]{"COL_COUNTRY", "COL_AMOUNT", "COL_SALE_DATE"};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum( Total.ave( dataSetRow.AMOUNT,null,1 ),null,1)", 6, "0.2"));
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("dataSetRow.COUNTRY");
        groupDefn.addFilter((IFilterDefinition)filterDefn);
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        int i = 0;
        while (i < expressions.length) {
            queryDefn.addResultSetExpression(names[i], expressions[i]);
            ++i;
        }
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResult = preparedQuery.execute(null);
        IResultIterator resultIt = queryResult.getResultIterator();
        this.outputQueryResult(resultIt, names);
        this.checkOutputFile();
    }
}

