/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.tests.data.engine.api;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import testutil.APITestCase;
import testutil.ConfigText;

public class MultiPass_SortTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(this, ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void test_SortOnAggregationExpression() throws Exception {
        String testSQL = "select COUNTRY, AMOUNT from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.AMOUNT", 2), new ScriptExpression("Total.runningSum(dataSetRow.AMOUNT)", 2)};
        String[] names = new String[]{"COL_COUNTRY", "COL_AMOUNT"};
        SortDefinition[] sortDef = new SortDefinition[]{new SortDefinition()};
        sortDef[0].setExpression("dataSetRow.AMOUNT/Total.sum(dataSetRow.AMOUNT)");
        sortDef[0].setSortDirection(1);
        QueryDefinition queryDefn = this.newReportQuery();
        queryDefn.addSort(sortDef[0]);
        int i = 0;
        while (i < 2) {
            queryDefn.addResultSetExpression(names[i], expressions[i]);
            ++i;
        }
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        MultiPass_SortTest.assertTrue((boolean)resultIt.next());
        resultIt.getValue(names[0]);
        resultIt.getValue(names[1]);
        System.out.print(resultIt.getValue(names[0]));
        System.out.print(resultIt.getValue(names[1]));
        resultIt.next();
        System.out.print(resultIt.getValue(names[0]));
        System.out.print(resultIt.getValue(names[1]));
        resultIt.next();
        System.out.print(resultIt.getValue(names[0]));
        System.out.print(resultIt.getValue(names[1]));
        resultIt.next();
        System.out.print(resultIt.getValue(names[0]));
        System.out.print(resultIt.getValue(names[1]));
        resultIt.next();
        System.out.print(resultIt.getValue(names[0]));
        System.out.print(resultIt.getValue(names[1]));
    }

    public void test_sortGroup() throws Exception {
        String testSQL = "select COUNTRY, AMOUNT from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0)};
        String[] names = new String[]{"GROUP_COUNTRY"};
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum( dataSetRow.AMOUNT )");
        sortDefn.setSortDirection(1);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[0].addSort(sortDefn);
        String[] bindingNameRow = new String[]{"country", "amount"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(names, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void test_sortOnGroupKey() throws Exception {
        String sqlStatement = "select COUNTRY, AMOUNT from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(sqlStatement);
    }
}

