/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.tests.data.engine.api;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.APITestCase;
import testutil.ConfigText;

public class ResultIteratorTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(this, ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void test_isFirstAndBeforeFirst() throws Exception {
        String testSQL = "select COUNTRY, COUNTRY, CITY from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        String[] bindingNameRow = new String[]{"Row_COUNTRY", "Row_CITY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        ResultIteratorTest.assertTrue((boolean)resultIt.isBeforeFirst());
        while (resultIt.next()) {
            if (resultIt.isFirst()) {
                ResultIteratorTest.assertEquals((Object)resultIt.getValue("Row_COUNTRY"), (Object)"CHINA");
                ResultIteratorTest.assertFalse((boolean)resultIt.isBeforeFirst());
            }
            ResultIteratorTest.assertFalse((boolean)resultIt.isBeforeFirst());
        }
    }

    public void test_isBeforeFirstAgainstEmptyResult() throws Exception {
        String testSQL = "select COUNTRY, COUNTRY, CITY from " + this.getTestTableName() + " where COUNTRY = 'JAPAN'";
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        String[] bindingNameRow = null;
        IBaseExpression[] bindingExprRow = null;
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        ResultIteratorTest.assertTrue((boolean)resultIt.isEmpty());
        ResultIteratorTest.assertFalse((boolean)resultIt.isBeforeFirst());
    }
}

