/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ShowAsViewMenuAction
extends AbstractCrosstabAction {
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.ShowAsViewAction";
    private MeasureViewHandle measureViewHandle;
    private AggregationCellProviderWrapper providerWrapper;
    public static final String NAME = Messages.getString("ShowAsViewAction.DisplayName");
    private static final String ACTION_MSG_MERGE = Messages.getString("ShowAsViewAction.TransName");
    private final String expectedView;
    private final String expectedViewDisplayName;

    public ShowAsViewMenuAction(DesignElementHandle handle, String expectedView, int index) {
        super(handle);
        this.setId(ID);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        this.providerWrapper = new AggregationCellProviderWrapper(this.measureViewHandle.getCrosstab());
        this.expectedViewDisplayName = this.providerWrapper.getViewDisplayName(expectedView);
        this.setText("&" + index + " " + NAME + " " + this.expectedViewDisplayName);
        this.expectedView = expectedView;
    }

    public boolean isEnabled() {
        boolean enabled = true;
        if (this.measureViewHandle instanceof ComputedMeasureViewHandle) {
            enabled = false;
        } else {
            if (DEUtil.isLinkedElement((DesignElementHandle)this.measureViewHandle.getCrosstabHandle())) {
                return false;
            }
            IAggregationCellViewProvider provider = this.providerWrapper.getProvider(this.expectedView);
            SwitchCellInfo info = new SwitchCellInfo(this.measureViewHandle.getCrosstab(), 3);
            info.setMeasureInfo(true, this.measureViewHandle.getCubeMeasureName(), this.expectedView);
            enabled = provider.canSwitch(info);
            IAggregationCellViewProvider matchProvider = this.providerWrapper.getMatchProvider(this.measureViewHandle.getCell());
            if (matchProvider != null && matchProvider.getViewName().equals(this.expectedView)) {
                enabled = false;
            }
        }
        this.setEnabled(enabled);
        return enabled;
    }

    public void run() {
        this.transStar(String.valueOf(ACTION_MSG_MERGE) + " " + this.expectedViewDisplayName);
        SwitchCellInfo info = new SwitchCellInfo(this.measureViewHandle.getCrosstab(), 3);
        info.setMeasureInfo(true, this.measureViewHandle.getCubeMeasureName(), this.expectedView);
        this.providerWrapper.switchView(info);
        this.transEnd();
    }
}

