/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.NamePropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUtil {
    public static Library checkIncludeLibrary(Module module, String namespace, URL url, Module outermostModule) throws LibraryException {
        if (StringUtil.isBlank(namespace) || !NamePropertyType.isValidName(namespace)) {
            throw new LibraryException(module, new String[]{namespace}, "Error.LibraryException.INVALID_LIBRARY_NAMESPACE");
        }
        Library foundLib = outermostModule.getLibraryWithNamespace(namespace);
        if (url != null) {
            if (foundLib != null) {
                String tmpPath = foundLib.getLocation();
                String foundPath = url.toExternalForm();
                if (!foundPath.equalsIgnoreCase(tmpPath)) {
                    throw new LibraryException(module, new String[]{namespace}, "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE");
                }
                if (module.getLibraryWithNamespace(namespace, 1) != null) {
                    throw new LibraryException(module, new String[]{namespace}, "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE");
                }
            } else {
                foundLib = outermostModule.getLibraryByLocation(url.toExternalForm());
            }
            if (module.getLibraryByLocation(url.toExternalForm(), 1) != null) {
                throw new LibraryException(module, new String[]{url.toExternalForm()}, "Error.LibraryException.LIBRARY_ALREADY_INCLUDED");
            }
        }
        if (module instanceof Library) {
            Library library = (Library)module;
            if (url != null && library.isRecursiveFile(url.toExternalForm()) || library.isRecursiveNamespace(namespace)) {
                throw new LibraryException(module, new String[]{namespace}, "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
            }
        }
        return foundLib;
    }

    public static void insertReloadLibs(Map<String, Library> reloadLibs, Library library) {
        if (reloadLibs == null || reloadLibs == Collections.EMPTY_MAP) {
            return;
        }
        Set<String> namespaces = reloadLibs.keySet();
        List<Library> tmpLibs = library.getAllLibraries();
        String namespace = library.getNamespace();
        if (!namespaces.contains(namespace)) {
            reloadLibs.put(namespace, library);
        }
        int i = 0;
        while (i < tmpLibs.size()) {
            Library tmpLib = tmpLibs.get(i);
            namespace = tmpLib.getNamespace();
            if (!namespaces.contains(namespace)) {
                reloadLibs.put(namespace, library);
            }
            reloadLibs.put(namespace, tmpLib);
            ++i;
        }
    }

    public static void insertCompatibleThemeToLibrary(Library library, Theme theme) {
        assert (library != null);
        assert (theme != null);
        String name = theme.getName();
        assert (!StringUtil.isBlank(name) && ModelMessages.getMessage("Theme.defaultThemeName").equals(name));
        NameSpace ns = library.getNameHelper().getNameSpace(6);
        assert (library.getNameHelper().canContain(6, name));
        ns.insert(theme);
        library.add(theme, 0);
    }

    public static boolean hasLibrary(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle) {
        String reportLocation = targetLibraryHandle.getModule().getLocation();
        List<Library> libList = designToExport.getModule().getAllLibraries();
        for (Library library : libList) {
            String libLocation = library.getRoot().getLocation();
            if (!reportLocation.equals(libLocation)) continue;
            return true;
        }
        return false;
    }
}

