/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.factory;

import com.ibm.icu.util.ULocale;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.birt.chart.computation.ChartComputationFactory;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.computation.withoutaxes.PlotWithoutAxes;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.IGenerator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.datafeed.DataProcessor;
import org.eclipse.birt.chart.internal.factory.SqlDataRowEvaluator;
import org.eclipse.birt.chart.internal.layout.LayoutManager;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.DeferredCacheManager;
import org.eclipse.birt.chart.script.ChartScriptContext;
import org.eclipse.birt.chart.script.IChartScriptContext;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.style.SimpleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Generator
implements IGenerator {
    private IStyleProcessor implicitProcessor = SimpleProcessor.instance();
    private static Generator g = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/factory");
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    private Generator() {
    }

    public static final synchronized Generator instance() {
        if (g == null) {
            g = new Generator();
        }
        return g;
    }

    public final void prepareStyles(Chart model, IStyleProcessor externalProcessor) {
        if (externalProcessor != null) {
            externalProcessor.processStyle(model);
        }
        Stack<StyledComponent> token = new Stack<StyledComponent>();
        token.push(StyledComponent.CHART_ALL_LITERAL);
        this.prepareComponent(model, token, model, externalProcessor);
        token.clear();
    }

    private void prepareComponent(Chart model, Stack<StyledComponent> token, EObject component, IStyleProcessor externalProcessor) {
        StyledComponent currentToken = this.getStyledComponent(component);
        boolean pushed = false;
        if (currentToken != null) {
            token.push(currentToken);
            pushed = true;
        }
        this.applyStyles(model, token.peek(), component, externalProcessor);
        Iterator itr = component.eContents().iterator();
        while (itr.hasNext()) {
            this.prepareComponent(model, token, (EObject)itr.next(), externalProcessor);
        }
        if (pushed && !token.empty()) {
            token.pop();
        }
    }

    private StyledComponent getStyledComponent(EObject obj) {
        if (obj instanceof Block && obj.eContainer() instanceof Chart) {
            return StyledComponent.CHART_BACKGROUND_LITERAL;
        }
        if (obj instanceof Plot) {
            return StyledComponent.PLOT_BACKGROUND_LITERAL;
        }
        if (obj instanceof Legend) {
            return StyledComponent.LEGEND_BACKGROUND_LITERAL;
        }
        if (obj instanceof TitleBlock) {
            return StyledComponent.CHART_TITLE_LITERAL;
        }
        if (obj instanceof Label) {
            if (obj.eContainer() instanceof Axis) {
                if (obj.eContainmentFeature().getFeatureID() == 1) {
                    return StyledComponent.AXIS_TITLE_LITERAL;
                }
                if (obj.eContainmentFeature().getFeatureID() == 10) {
                    return StyledComponent.AXIS_LABEL_LITERAL;
                }
            }
            if (obj.eContainer() instanceof Series) {
                if (obj.eContainmentFeature().getFeatureID() == 1) {
                    return StyledComponent.SERIES_LABEL_LITERAL;
                }
                if (obj.eContainmentFeature().getFeatureID() == 14) {
                    return StyledComponent.SERIES_TITLE_LITERAL;
                }
            }
        }
        if (obj instanceof Text && obj.eContainer() instanceof Legend) {
            return StyledComponent.LEGEND_LABEL_LITERAL;
        }
        if (obj instanceof LineAttributes && obj.eContainer() instanceof Axis) {
            return StyledComponent.AXIS_LINE_LITERAL;
        }
        return null;
    }

    private void applyStyles(Chart model, StyledComponent type, EObject component, IStyleProcessor externalProcessor) {
        Axis axis;
        if (component instanceof Block) {
            if (component.eContainer() instanceof Chart) {
                IStyle style = this.getMingledStyle(model, type, externalProcessor);
                ColorDefinition newBackcolor = style.getBackgroundColor();
                Image newBackimage = style.getBackgroundImage();
                Fill background = ((Block)component).getBackground();
                if (background == null) {
                    if (newBackcolor != null) {
                        ((Block)component).setBackground(newBackcolor);
                    } else if (this.implicitProcessor.getDefaultBackgroundColor() != null) {
                        ((Block)component).setBackground(this.implicitProcessor.getDefaultBackgroundColor());
                    } else {
                        ((Block)component).setBackground(goFactory.WHITE());
                    }
                    if (newBackimage != null) {
                        ((Block)component).setBackground(newBackimage);
                    }
                }
                Insets ins = ((Block)component).getInsets();
                Insets padding = style.getPadding();
                if (padding != null && ins == null) {
                    ins = goFactory.createInsets(0.0, 0.0, 0.0, 0.0);
                    ((Block)component).setInsets(ins);
                    ins.setTop(padding.getTop());
                    ins.setLeft(padding.getLeft());
                    ins.setBottom(padding.getBottom());
                    ins.setRight(padding.getRight());
                }
            }
        } else if (component instanceof Text) {
            IStyle style = this.getMingledStyle(model, type, externalProcessor);
            Text text = (Text)component;
            if (text.getFont() == null) {
                text.setFont(style.getFont());
            } else {
                FontDefinition newFont = style.getFont();
                FontDefinition font = text.getFont();
                ChartUtil.mergeFont(font, newFont);
            }
            if (text.getColor() == null) {
                text.setColor(style.getColor());
            }
        } else if (component instanceof LineAttributes) {
            LineAttributes lia;
            if ((component.eContainer() instanceof Axis || component.eContainer() instanceof Series) && (lia = (LineAttributes)component).getColor() == null) {
                IStyle style = this.getMingledStyle(model, type, externalProcessor);
                lia.setColor(style.getColor());
            }
        } else if (component instanceof Axis && (axis = (Axis)component).getFormatSpecifier() == null) {
            IStyle style = this.getMingledStyle(model, type, externalProcessor);
            switch (axis.getType()) {
                case DATE_TIME_LITERAL: {
                    axis.setFormatSpecifier(style.getDateTimeFormat());
                    break;
                }
                case LINEAR_LITERAL: 
                case LOGARITHMIC_LITERAL: {
                    axis.setFormatSpecifier(style.getNumberFormat());
                    break;
                }
                case TEXT_LITERAL: {
                    axis.setFormatSpecifier(style.getStringFormat());
                }
            }
        }
    }

    private IStyle getMingledStyle(Chart model, StyledComponent type, IStyleProcessor externalProcessor) {
        SimpleContainer rStyle = new SimpleContainer();
        if (externalProcessor != null) {
            while (type != null && !this.updateHierarchyStyle(model, type, externalProcessor, rStyle)) {
                type = this.getParentType(type);
            }
        }
        while (type != null && !this.updateHierarchyStyle(model, type, this.implicitProcessor, rStyle)) {
            type = this.getParentType(type);
        }
        return rStyle.style;
    }

    private StyledComponent getParentType(StyledComponent type) {
        switch (type.getValue()) {
            case 0: {
                return null;
            }
            case 1: {
                return StyledComponent.CHART_BACKGROUND_LITERAL;
            }
            case 2: {
                return StyledComponent.CHART_ALL_LITERAL;
            }
            case 3: {
                return StyledComponent.CHART_BACKGROUND_LITERAL;
            }
            case 4: {
                return StyledComponent.CHART_BACKGROUND_LITERAL;
            }
            case 5: {
                return StyledComponent.LEGEND_BACKGROUND_LITERAL;
            }
            case 6: {
                return StyledComponent.PLOT_BACKGROUND_LITERAL;
            }
            case 7: {
                return StyledComponent.PLOT_BACKGROUND_LITERAL;
            }
            case 8: {
                return StyledComponent.PLOT_BACKGROUND_LITERAL;
            }
            case 9: {
                return StyledComponent.PLOT_BACKGROUND_LITERAL;
            }
            case 10: {
                return StyledComponent.PLOT_BACKGROUND_LITERAL;
            }
        }
        return null;
    }

    private boolean updateHierarchyStyle(Chart model, StyledComponent type, IStyleProcessor processor, SimpleContainer currentContainer) {
        FontDefinition fd;
        SimpleStyle currentStyle = currentContainer.style;
        IStyle newStyle = null;
        if (currentStyle == null) {
            currentStyle = currentContainer.style = new SimpleStyle(processor.getStyle(model, type));
        } else {
            newStyle = processor.getStyle(model, type);
        }
        if (newStyle != null) {
            if (currentStyle.getFont() == null) {
                if (newStyle.getFont() != null) {
                    currentStyle.setFont(goFactory.copyOf(newStyle.getFont()));
                }
            } else if (newStyle.getFont() != null) {
                fd = currentStyle.getFont();
                FontDefinition newFd = goFactory.copyOf(newStyle.getFont());
                ChartUtil.mergeFont(fd, newFd);
            }
            if (currentStyle.getColor() == null && newStyle.getColor() != null) {
                currentStyle.setColor(goFactory.copyOf(newStyle.getColor()));
            }
        }
        return (fd = currentStyle.getFont()) != null && fd.getName() != null && fd.isSetSize() && fd.isSetBold() && fd.isSetItalic() && fd.isSetRotation() && fd.isSetWordWrap() && fd.isSetUnderline() && fd.isSetStrikethrough() && fd.getAlignment() != null && fd.getAlignment().isSetHorizontalAlignment() && currentStyle.getColor() != null;
    }

    public List<String> getRowExpressions(Chart cm) throws ChartException {
        return this.getRowExpressions(cm, null);
    }

    public List<String> getRowExpressions(Chart cm, IActionEvaluator iae, boolean needChangeValueExpr) throws ChartException {
        if (cm instanceof ChartWithAxes) {
            return Generator.getRowExpressions((ChartWithAxes)cm, iae, needChangeValueExpr);
        }
        if (cm instanceof ChartWithoutAxes) {
            return Generator.getRowExpressions((ChartWithoutAxes)cm, iae, needChangeValueExpr);
        }
        return null;
    }

    public List<String> getRowExpressions(Chart cm, IActionEvaluator iae) throws ChartException {
        if (cm instanceof ChartWithAxes) {
            return Generator.getRowExpressions((ChartWithAxes)cm, iae, true);
        }
        if (cm instanceof ChartWithoutAxes) {
            return Generator.getRowExpressions((ChartWithoutAxes)cm, iae, true);
        }
        return null;
    }

    @Override
    public void bindData(ResultSet resultSet, Chart chart, RunTimeContext rtc) throws ChartException {
        SqlDataRowEvaluator rowEvaluator = new SqlDataRowEvaluator(resultSet);
        this.bindData(rowEvaluator, chart, rtc);
    }

    @Override
    public void bindData(IDataRowExpressionEvaluator expressionEvaluator, Chart chart, RunTimeContext rtc) throws ChartException {
        this.bindData(expressionEvaluator, null, chart, rtc);
    }

    @Override
    public void bindData(IDataRowExpressionEvaluator expressionEvaluator, IActionEvaluator iae, Chart chart, RunTimeContext rtc) throws ChartException {
        IChartScriptContext icsc = (IChartScriptContext)rtc.getScriptContext();
        if (icsc == null) {
            ChartScriptContext csc = new ChartScriptContext();
            csc.setChartInstance(chart);
            csc.setULocale(rtc.getULocale());
            csc.setLogger(logger);
            rtc.setScriptContext(csc);
        } else if (icsc instanceof ChartScriptContext) {
            ((ChartScriptContext)icsc).setLogger(logger);
            ((ChartScriptContext)icsc).setChartInstance(chart);
        }
        DataProcessor helper = new DataProcessor(rtc, iae);
        helper.generateRuntimeSeries(expressionEvaluator, chart);
    }

    public RunTimeContext prepare(Chart model, IExternalContext externalContext, IScriptClassLoader iscl, Locale locale) throws ChartException {
        return this.prepare(model, externalContext, iscl, ULocale.forLocale((Locale)locale));
    }

    @Override
    public RunTimeContext prepare(Chart model, IExternalContext externalContext, IScriptClassLoader iscl, ULocale locale) throws ChartException {
        RunTimeContext rtc = new RunTimeContext();
        rtc.setScriptClassLoader(iscl);
        Chart cmRunTime = model.copyInstance();
        rtc.setULocale(locale != null ? locale : ULocale.getDefault());
        ChartScriptContext csc = new ChartScriptContext();
        csc.setChartInstance(cmRunTime);
        csc.setExternalContext(externalContext);
        csc.setULocale(rtc.getULocale());
        csc.setLogger(logger);
        rtc.setScriptContext(csc);
        ScriptHandler sh = new ScriptHandler();
        rtc.setScriptHandler(sh);
        sh.setScriptClassLoader(iscl);
        sh.setScriptContext(csc);
        if (externalContext != null && externalContext.getScriptable() != null) {
            sh.init(externalContext.getScriptable());
        } else {
            sh.init(null);
        }
        sh.setRunTimeModel(cmRunTime);
        return rtc;
    }

    public final GeneratedChartState build(IDisplayServer ids, Chart cmRunTime, Scriptable scParent, Bounds bo, RunTimeContext rtc) throws ChartException {
        return this.build(ids, cmRunTime, scParent, bo, rtc, null);
    }

    public final GeneratedChartState build(IDisplayServer ids, Chart cmRunTime, Scriptable scParent, Bounds bo, RunTimeContext rtc, IStyleProcessor externalProcessor) throws ChartException {
        final Scriptable scriptContext = scParent;
        return this.build(ids, cmRunTime, bo, new IExternalContext(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return null;
            }

            public Scriptable getScriptable() {
                return scriptContext;
            }
        }, rtc, externalProcessor);
    }

    public final GeneratedChartState build(IDisplayServer ids, Chart cmRunTime, Bounds bo, RunTimeContext rtc) throws ChartException {
        return this.build(ids, cmRunTime, bo, null, rtc, null);
    }

    @Override
    public final GeneratedChartState build(IDisplayServer ids, Chart cmRunTime, Bounds bo, IExternalContext externalContext, RunTimeContext rtc) throws ChartException {
        return this.build(ids, cmRunTime, bo, externalContext, rtc, null);
    }

    @Override
    public final GeneratedChartState build(IDisplayServer ids, Chart cmRunTime, Bounds bo, IExternalContext externalContext, RunTimeContext rtc, IStyleProcessor externalProcessor) throws ChartException {
        ScriptHandler sh;
        IChartScriptContext icsc;
        if (ids == null || cmRunTime == null || bo == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.null.value", Messages.getResourceBundle());
        }
        if (rtc == null) {
            rtc = new RunTimeContext();
        }
        rtc.putState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY, ChartComputationFactory.instance().createChartComputation());
        if (rtc.getULocale() == null) {
            rtc.setULocale(ULocale.getDefault());
        }
        if ((icsc = (IChartScriptContext)rtc.getScriptContext()) == null) {
            ChartScriptContext csc = new ChartScriptContext();
            csc.setChartInstance(cmRunTime);
            csc.setExternalContext(externalContext);
            csc.setULocale(rtc.getULocale());
            csc.setLogger(logger);
            rtc.setScriptContext(csc);
            icsc = csc;
        } else if (icsc instanceof ChartScriptContext) {
            ((ChartScriptContext)icsc).setLogger(logger);
            cmRunTime.getBlock().setBounds(bo);
            ((ChartScriptContext)icsc).setChartInstance(cmRunTime);
        }
        if (externalContext != null && icsc instanceof ChartScriptContext) {
            ((ChartScriptContext)icsc).setExternalContext(externalContext);
        }
        if ((sh = (ScriptHandler)rtc.getScriptHandler()) == null) {
            sh = new ScriptHandler();
            rtc.setScriptHandler(sh);
            sh.setScriptClassLoader(rtc.getScriptClassLoader());
            sh.setScriptContext(icsc);
            String sScriptContent = cmRunTime.getScript();
            if (externalContext != null && externalContext.getScriptable() != null) {
                sh.init(externalContext.getScriptable());
            } else {
                sh.init(null);
            }
            sh.setRunTimeModel(cmRunTime);
            if (sScriptContent != null && sScriptContent.length() > 0 && rtc.isScriptingEnabled()) {
                sh.register(null, sScriptContent);
            }
        }
        ScriptHandler.callFunction(sh, "startGeneration", cmRunTime);
        ScriptHandler.callFunction(sh, "beforeGeneration", cmRunTime, rtc.getScriptContext());
        ChartUtil.pruneInvisibleSeries(cmRunTime);
        Generator.checkDataEmpty(cmRunTime, rtc);
        this.prepareStyles(cmRunTime, externalProcessor);
        PlotComputation oComputations = null;
        if (cmRunTime instanceof ChartWithAxes) {
            try {
                if (cmRunTime.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
                    oComputations = new PlotWith3DAxes(ids, (ChartWithAxes)cmRunTime, rtc);
                }
                oComputations = new PlotWith2DAxes(ids, (ChartWithAxes)cmRunTime, rtc);
            }
            catch (Exception e) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)e);
            }
        } else if (cmRunTime instanceof ChartWithoutAxes) {
            oComputations = new PlotWithoutAxes(ids, (ChartWithoutAxes)cmRunTime, rtc);
        }
        if (oComputations == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unsupported.chart.model", new Object[]{cmRunTime}, Messages.getResourceBundle(rtc.getULocale()));
        }
        LinkedHashMap<Series, LegendItemRenderingHints> lhmRenderers = new LinkedHashMap<Series, LegendItemRenderingHints>();
        BaseRenderer[] brna = null;
        try {
            brna = BaseRenderer.instances(cmRunTime, rtc, oComputations);
            int i = 0;
            while (i < brna.length) {
                lhmRenderers.put(brna[i].getSeries(), new LegendItemRenderingHints(brna[i], goFactory.createBounds(0.0, 0.0, 0.0, 0.0)));
                ++i;
            }
            rtc.setSeriesRenderers(lhmRenderers);
            rtc.setLegendLayoutHints(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)ex);
        }
        if (oComputations instanceof PlotWith2DAxes) {
            PlotWith2DAxes pwa = (PlotWith2DAxes)oComputations;
            pwa.initDynamicPlotBounds(bo);
        }
        Block bl = cmRunTime.getBlock();
        LayoutManager lm = new LayoutManager(bl);
        ScriptHandler.callFunction(sh, "beforeLayout", cmRunTime);
        lm.doLayout(ids, cmRunTime, bo, rtc);
        ScriptHandler.callFunction(sh, "afterLayout", cmRunTime);
        Bounds boPlot = cmRunTime.getPlot().getBounds();
        Insets insPlot = cmRunTime.getPlot().getInsets();
        boPlot = goFactory.adjusteBounds(boPlot, insPlot);
        ScriptHandler.callFunction(sh, "beforeComputations", cmRunTime, oComputations);
        try {
            oComputations.compute(boPlot);
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)ex);
        }
        ScriptHandler.callFunction(sh, "afterComputations", cmRunTime, oComputations);
        Collection<LegendItemRenderingHints> co = lhmRenderers.values();
        LegendItemRenderingHints[] lirha = co.toArray(new LegendItemRenderingHints[co.size()]);
        int iSize = lhmRenderers.size();
        int i = 0;
        while (i < iSize) {
            BaseRenderer br = lirha[i].getRenderer();
            br.set(brna);
            br.set(ids);
            br.set(rtc);
            try {
                br.set(br.getComputations().getSeriesRenderingHints(br.getSeriesDefinition(), br.getSeries()));
                ScriptHandler.callFunction(sh, "startComputeSeries", br.getSeries());
                br.compute(bo, cmRunTime.getPlot(), br.getSeriesRenderingHints());
                ScriptHandler.callFunction(sh, "finishComputeSeries", br.getSeries());
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)ex);
            }
            ++i;
        }
        GeneratedChartState gcs = new GeneratedChartState(ids, cmRunTime, lhmRenderers, rtc, oComputations);
        sh.setGeneratedChartState(gcs);
        ScriptHandler.callFunction(sh, "finishGeneration", gcs);
        ScriptHandler.callFunction(sh, "afterGeneration", gcs, rtc.getScriptContext());
        return gcs;
    }

    @Override
    public final void refresh(GeneratedChartState gcs) throws ChartException {
        Chart cm = gcs.getChartModel();
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "beforeComputations", cm, gcs.getComputations());
        Bounds boPlot = cm.getPlot().getBounds();
        Insets insPlot = cm.getPlot().getInsets();
        boPlot = goFactory.adjusteBounds(boPlot, insPlot);
        try {
            gcs.getComputations().compute(boPlot);
        }
        catch (RuntimeException ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)ex);
        }
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "afterComputations", cm, gcs.getComputations());
    }

    @Override
    public final void render(IDeviceRenderer idr, GeneratedChartState gcs) throws ChartException {
        Chart cm = gcs.getChartModel();
        idr.getDisplayServer().setResourceFinder(gcs.getRunTimeContext().getResourceFinder());
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "startRendering", gcs);
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "beforeRendering", gcs, gcs.getRunTimeContext().getScriptContext());
        Legend lg = cm.getLegend();
        lg.updateLayout(cm);
        if (lg.getPosition() == Position.INSIDE_LITERAL) {
            Bounds bo = gcs.getComputations().getPlotBounds();
            Generator.updateLegendInside(bo, lg, idr.getDisplayServer(), cm, gcs.getRunTimeContext());
        }
        LinkedHashMap<Series, LegendItemRenderingHints> lhm = gcs.getRenderers();
        int iSize = lhm.size();
        Collection<LegendItemRenderingHints> co = lhm.values();
        LegendItemRenderingHints[] lirha = co.toArray(new LegendItemRenderingHints[co.size()]);
        DeferredCacheManager dcm = new DeferredCacheManager(idr, cm);
        DeferredCache dc = null;
        Bounds bo = gcs.getChartModel().getBlock().getBounds();
        idr.setProperty("device.bounds", goFactory.scaleBounds(bo, (double)idr.getDisplayServer().getDpiResolution() / 72.0));
        idr.setChartComputation(gcs.getComputations().getChartComputation());
        gcs.getRunTimeContext().setStructureDefinitionListener(idr.needsStructureDefinition() ? idr : null);
        idr.before();
        int i = 0;
        while (i < iSize) {
            BaseRenderer br = lirha[i].getRenderer();
            dc = dcm.createDeferredCache(br);
            br.setDeferredCacheManager(dcm);
            br.set(dc);
            br.set(idr);
            br.set(gcs.getRunTimeContext());
            try {
                br.render(lhm, bo);
            }
            catch (RuntimeException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)ex);
            }
            ++i;
        }
        idr.after();
        gcs.getRunTimeContext().clearState();
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "finishRendering", gcs);
        ScriptHandler.callFunction(gcs.getRunTimeContext().getScriptHandler(), "afterRendering", gcs, gcs.getRunTimeContext().getScriptContext());
    }

    private static final void updateLegendInside(Bounds boContainer, Legend lg, IDisplayServer ids, Chart cm, RunTimeContext rtc) throws ChartException {
        double dX;
        double dY;
        double dScale = (double)ids.getDpiResolution() / 72.0;
        Size sz = lg.getPreferredSize(ids, cm, rtc);
        boContainer = goFactory.scaleBounds(boContainer, 1.0 / dScale);
        if (lg.isSetAnchor()) {
            int iAnchor = lg.getAnchor().getValue();
            if (rtc.isRightToLeft()) {
                if (iAnchor == 2) {
                    iAnchor = 6;
                } else if (iAnchor == 1) {
                    iAnchor = 7;
                } else if (iAnchor == 3) {
                    iAnchor = 5;
                } else if (iAnchor == 6) {
                    iAnchor = 2;
                } else if (iAnchor == 7) {
                    iAnchor = 1;
                } else if (iAnchor == 5) {
                    iAnchor = 3;
                }
            }
            switch (iAnchor) {
                case 0: 
                case 1: 
                case 7: {
                    dY = boContainer.getTop();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    dY = boContainer.getTop() + boContainer.getHeight() - sz.getHeight();
                    break;
                }
                default: {
                    dY = boContainer.getTop() + (boContainer.getHeight() - sz.getHeight()) / 2.0;
                }
            }
            switch (iAnchor) {
                case 5: 
                case 6: 
                case 7: {
                    dX = boContainer.getLeft();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    dX = boContainer.getLeft() + boContainer.getWidth() - sz.getWidth();
                    break;
                }
                default: {
                    dX = boContainer.getLeft() + (boContainer.getWidth() - sz.getWidth()) / 2.0;
                    break;
                }
            }
        } else {
            dX = boContainer.getLeft() + (boContainer.getWidth() - sz.getWidth()) / 2.0;
            dY = boContainer.getTop() + (boContainer.getHeight() - sz.getHeight()) / 2.0;
        }
        lg.getBounds().set(dX, dY, sz.getWidth(), sz.getHeight());
    }

    private static List<String> getRowExpressions(ChartWithoutAxes cwoa, IActionEvaluator iae, boolean needChangeValueExpr) throws ChartException {
        Series seBase;
        EList<Query> elBaseSeries;
        ArrayList<String> alExpressions = new ArrayList<String>(4);
        EList<SeriesDefinition> elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.CannotDecipher", Messages.getResourceBundle());
        }
        SeriesDefinition categorySD = (SeriesDefinition)elSD.get(0);
        Query qBaseSeriesDefinition = categorySD.getQuery();
        String sExpression = qBaseSeriesDefinition.getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            logger.log(2, Messages.getString("dataprocessor.log.baseSeriesDefn3", sExpression, ULocale.getDefault()));
        }
        if ((elBaseSeries = (seBase = categorySD.getDesignTimeSeries()).getDataDefinition()).size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.FoundDefnAssociatedWithX", new Object[]{String.valueOf(elBaseSeries.size())}, null);
        }
        Query qBaseSeries = (Query)elBaseSeries.get(0);
        sExpression = qBaseSeries.getDefinition();
        if (sExpression == null || sExpression.trim().length() <= 0 || alExpressions.contains(sExpression)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefinitionUnspecified", Messages.getResourceBundle());
        }
        alExpressions.add(sExpression);
        Generator.addSortExperssion(alExpressions, categorySD, sExpression);
        elSD = categorySD.getSeriesDefinitions();
        int iCount = 0;
        int k = 0;
        while (k < elSD.size()) {
            SeriesDefinition sd = (SeriesDefinition)elSD.get(k);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition != null) {
                Series seOrthogonal;
                EList<Query> elOrthogonalSeries;
                sExpression = qOrthogonalSeriesDefinition.getDefinition();
                if (sExpression != null && sExpression.trim().length() > 0) {
                    if (alExpressions.contains(sExpression)) {
                        int iRemovalIndex = alExpressions.indexOf(sExpression);
                        if (iRemovalIndex > iCount) {
                            alExpressions.remove(iRemovalIndex);
                            alExpressions.add(iCount++, sExpression);
                        }
                    } else {
                        alExpressions.add(iCount++, sExpression);
                        Generator.addSortExperssion(alExpressions, sd, sExpression);
                    }
                }
                if ((elOrthogonalSeries = (seOrthogonal = sd.getDesignTimeSeries()).getDataDefinition()).isEmpty()) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                }
                boolean bAnyQueries = false;
                int i = 0;
                while (i < elOrthogonalSeries.size()) {
                    Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                    if (qOrthogonalSeries != null) {
                        sExpression = qOrthogonalSeries.getDefinition();
                        if (needChangeValueExpr) {
                            sExpression = ChartUtil.createValueSeriesRowFullExpression(qOrthogonalSeries, sd, categorySD);
                        }
                        if (sExpression != null && sExpression.trim().length() > 0) {
                            bAnyQueries = true;
                            if (!alExpressions.contains(sExpression)) {
                                alExpressions.add(sExpression);
                            }
                        }
                    }
                    ++i;
                }
                if (!bAnyQueries) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.AtLeastOneDefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                }
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonal, iae, categorySD, sd);
                if (triggerExprs != null) {
                    int t = 0;
                    while (t < triggerExprs.length) {
                        String tgexp = triggerExprs[t];
                        if (!alExpressions.contains(tgexp)) {
                            alExpressions.add(tgexp);
                        }
                        ++t;
                    }
                }
            }
            ++k;
        }
        return alExpressions;
    }

    private static List<String> getRowExpressions(ChartWithAxes cwa, IActionEvaluator iae, boolean needChangeValueExpr) throws ChartException {
        Series seBase;
        EList<Query> elBaseSeries;
        ArrayList<String> alExpressions = new ArrayList<String>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList<SeriesDefinition> elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "dataprocessor.exception.CannotDecipher2", Messages.getResourceBundle());
        }
        SeriesDefinition categorySD = (SeriesDefinition)elSD.get(0);
        Query qBaseSeriesDefinition = categorySD.getQuery();
        String sExpression = qBaseSeriesDefinition.getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            logger.log(2, Messages.getString("dataprocessor.log.XSeriesDefn", sExpression, ULocale.getDefault()));
        }
        if ((elBaseSeries = (seBase = categorySD.getDesignTimeSeries()).getDataDefinition()).size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.FoundMoreThanOneDefnAssociateX", new Object[]{String.valueOf(elBaseSeries.size())}, Messages.getResourceBundle());
        }
        Query qBaseSeries = (Query)elBaseSeries.get(0);
        sExpression = qBaseSeries.getDefinition();
        if (sExpression == null || sExpression.trim().length() <= 0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.definitionsAssociatedWithX", Messages.getResourceBundle());
        }
        alExpressions.add(sExpression);
        Generator.addSortExperssion(alExpressions, categorySD, sExpression);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int iCount = 0;
        int j = 0;
        while (j < axaOrthogonal.length) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            int k = 0;
            while (k < elSD.size()) {
                SeriesDefinition sd = (SeriesDefinition)elSD.get(k);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition != null) {
                    Series seOrthogonal;
                    EList<Query> elOrthogonalSeries;
                    sExpression = qOrthogonalSeriesDefinition.getDefinition();
                    if (sExpression != null && sExpression.trim().length() > 0) {
                        if (alExpressions.contains(sExpression)) {
                            int iRemovalIndex = alExpressions.indexOf(sExpression);
                            if (iRemovalIndex > iCount) {
                                alExpressions.remove(iRemovalIndex);
                                alExpressions.add(iCount++, sExpression);
                            }
                        } else {
                            alExpressions.add(iCount++, sExpression);
                            Generator.addSortExperssion(alExpressions, sd, sExpression);
                        }
                    }
                    if ((elOrthogonalSeries = (seOrthogonal = sd.getDesignTimeSeries()).getDataDefinition()).isEmpty()) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                    }
                    boolean bAnyQueries = false;
                    int i = 0;
                    while (i < elOrthogonalSeries.size()) {
                        Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                        if (qOrthogonalSeries != null && (sExpression = qOrthogonalSeries.getDefinition()) != null && sExpression.trim().length() > 0) {
                            if (needChangeValueExpr) {
                                sExpression = ChartUtil.createValueSeriesRowFullExpression(qOrthogonalSeries, sd, categorySD);
                            }
                            bAnyQueries = true;
                            if (!alExpressions.contains(sExpression)) {
                                alExpressions.add(sExpression);
                            }
                        }
                        ++i;
                    }
                    if (!bAnyQueries) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.AtLeastOneDefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                    }
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonal, iae, categorySD, sd);
                    if (triggerExprs != null) {
                        int t = 0;
                        while (t < triggerExprs.length) {
                            String tgexp = triggerExprs[t];
                            if (!alExpressions.contains(tgexp)) {
                                alExpressions.add(tgexp);
                            }
                            ++t;
                        }
                    }
                }
                ++k;
            }
            ++j;
        }
        return alExpressions;
    }

    private static void addSortExperssion(List<String> alExpressions, SeriesDefinition seriesDefinition, String sExpression) {
        if (seriesDefinition.isSetSorting() && seriesDefinition.getSortKey() != null && !sExpression.equals(seriesDefinition.getSortKey().getDefinition())) {
            alExpressions.add(seriesDefinition.getSortKey().getDefinition());
        }
    }

    private static void checkDataEmpty(Chart cm, RunTimeContext rtc) {
        if (!ChartUtil.isDataEmpty(rtc)) {
            return;
        }
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            Axis axBase = cwa.getBaseAxes()[0];
            axBase.getLabel().setVisible(false);
            for (Axis ax : axBase.getAssociatedAxes()) {
                ax.getLabel().setVisible(false);
            }
            for (Axis ax : axBase.getAncillaryAxes()) {
                ax.getLabel().setVisible(false);
            }
        }
    }

    public void setDefaultBackground(ColorDefinition cd) {
        this.implicitProcessor.setDefaultBackgroundColor(cd);
    }

    static class SimpleContainer {
        SimpleStyle style = null;

        SimpleContainer() {
        }
    }
}

