/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.api.ICloseListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileReader;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileWriter;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

class RowFile
implements IRowIterator,
ICloseListener {
    private File tempFile = null;
    private ResultObjectUtil resultObjectUtil;
    private int readPos = 0;
    private int rowCount = 0;
    private IResultObject[] memoryRowCache = null;
    private DataFileReader dfr = null;
    private DataFileWriter dfw = null;

    RowFile(File file, ResultObjectUtil resultObjectUtil, int cacheSize) {
        assert (file != null);
        this.tempFile = file;
        System.out.println(file.getAbsolutePath());
        this.resultObjectUtil = resultObjectUtil;
        this.setCacheSize(cacheSize);
        DataEngineThreadLocal.getInstance().getCloseListener().add(this);
    }

    private void setCacheSize(int cacheSize) {
        if (cacheSize >= 0) {
            this.memoryRowCache = new IResultObject[cacheSize];
        }
    }

    void write(IResultObject resultObject) throws IOException, DataException {
        IResultObject[] resultObjects = new IResultObject[]{resultObject};
        this.writeRows(resultObjects, 1);
    }

    void writeRows(IResultObject[] resultObjects, int count) throws IOException, DataException {
        int cacheFreeSize = this.memoryRowCache.length - this.rowCount;
        if (cacheFreeSize >= count) {
            this.writeRowsToCache(resultObjects, 0, count);
        } else if (cacheFreeSize > 0) {
            this.writeRowsToCache(resultObjects, 0, cacheFreeSize);
            this.writeRowsToFile(resultObjects, cacheFreeSize, count - cacheFreeSize);
        } else {
            this.writeRowsToFile(resultObjects, 0, count);
        }
    }

    private void writeRowsToCache(IResultObject[] resultObjects, int from, int count) throws IOException {
        System.arraycopy(resultObjects, from, this.memoryRowCache, this.rowCount, count);
        this.rowCount += count;
    }

    private void writeRowsToFile(IResultObject[] resultObjects, int from, int count) throws IOException, DataException {
        if (this.dfw == null) {
            this.createWriter();
        }
        this.dfw.write(this.getSubArray(resultObjects, from, count), count);
        this.rowCount += count;
    }

    private IResultObject[] getSubArray(IResultObject[] resultObjects, int from, int count) {
        IResultObject[] subArray = new IResultObject[count];
        System.arraycopy(resultObjects, from, subArray, 0, count);
        return subArray;
    }

    private void createWriter() {
        this.dfw = DataFileWriter.newInstance(this.tempFile, this.resultObjectUtil);
    }

    void endWrite() {
        this.closeWriter();
    }

    private void closeWriter() {
        if (this.dfw != null) {
            this.dfw.close();
            this.dfw = null;
        }
    }

    public void reset() {
        this.readPos = 0;
        this.createReader();
    }

    public IResultObject fetch() throws IOException, DataException {
        IResultObject resultObject = this.readRowFromCache();
        if (resultObject == null) {
            resultObject = this.readRowFromFile();
        }
        return resultObject;
    }

    private IResultObject readRowFromCache() throws IOException {
        if (this.readPos >= this.memoryRowCache.length) {
            return null;
        }
        return this.memoryRowCache[this.readPos++];
    }

    private IResultObject readRowFromFile() throws IOException, DataException {
        if (this.readPos >= this.rowCount) {
            return null;
        }
        if (this.dfr == null) {
            this.createReader();
        }
        ++this.readPos;
        return this.dfr.read(1)[0];
    }

    private void createReader() {
        if (this.dfr != null) {
            this.dfr.close();
        }
        this.dfr = DataFileReader.newInstance(this.tempFile, this.resultObjectUtil);
    }

    public void close() {
        this.closeWriter();
        this.closeReader();
        if (this.tempFile != null) {
            FileSecurity.fileDelete(this.tempFile);
        }
        this.memoryRowCache = null;
    }

    private void closeReader() {
        if (this.dfr != null) {
            this.dfr.close();
            this.dfr = null;
        }
    }
}

