/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.ProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.transform.IGroupCalculator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SimpleGroupCalculator
implements IGroupCalculator {
    private IResultObject previous;
    private IResultObject next;
    private IResultObject current;
    private GroupBy[] groupBys;
    private Integer[] groupInstanceIndex;
    private int[] latestAggrAvailableIndex;
    private StreamManager streamManager;
    private RAOutputStream[] groupOutput;
    private RAOutputStream[] aggrRAOutput;
    private DataOutputStream[] aggrOutput;
    private DataOutputStream[] aggrIndexOutput;
    private RAOutputStream combinedAggrIndexRAOutput;
    private DataOutputStream combinedAggrIndexOutput;
    private RAOutputStream combinedAggrRAOutput;
    private DataOutputStream combinedAggrOutput;
    private ProgressiveAggregationHelper aggrHelper;
    private List<List<String>> groupAggrs;
    private List<String> runningAggrs;
    private List<String> overallAggrs;

    public SimpleGroupCalculator(DataEngineSession session, IQuery.GroupSpec[] groups, IResultClass rsMeta) throws DataException {
        this.groupBys = new GroupBy[groups.length];
        this.latestAggrAvailableIndex = new int[groups.length];
        Arrays.fill(this.latestAggrAvailableIndex, -1);
        int i = 0;
        while (i < groups.length) {
            int keyIndex = groups[i].getKeyIndex();
            String keyColumn = groups[i].getKeyColumn();
            if (keyColumn != null) {
                keyIndex = rsMeta.getFieldIndex(keyColumn);
            }
            this.groupBys[i] = GroupBy.newInstance(groups[i], keyIndex, keyColumn, rsMeta.getFieldValueClass(keyIndex));
            ++i;
        }
        this.groupInstanceIndex = new Integer[this.groupBys.length];
        Arrays.fill((Object[])this.groupInstanceIndex, (Object)0);
        this.groupAggrs = new ArrayList<List<String>>();
        this.runningAggrs = new ArrayList<String>();
        this.overallAggrs = new ArrayList<String>();
        this.aggrOutput = new DataOutputStream[0];
        i = 0;
        while (i < groups.length) {
            this.groupAggrs.add(new ArrayList());
            ++i;
        }
    }

    public void setAggrHelper(ProgressiveAggregationHelper aggrHelper) throws DataException {
        this.aggrHelper = aggrHelper;
        for (String aggrName : this.aggrHelper.getAggrNames()) {
            IAggrInfo aggrInfo = this.aggrHelper.getAggrInfo(aggrName);
            if (aggrInfo.getAggregation().getType() == 1) {
                this.runningAggrs.add(aggrName);
                continue;
            }
            if (aggrInfo.getGroupLevel() == 0) {
                this.overallAggrs.add(aggrName);
                continue;
            }
            if (this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() > this.groupAggrs.size()) continue;
            this.groupAggrs.get(this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() - 1).add(aggrName);
        }
    }

    private int getBreakingGroup(IResultObject obj1, IResultObject obj2) throws DataException {
        if (obj1 == null) {
            return 0;
        }
        if (obj2 == null) {
            return 0;
        }
        int i = 0;
        while (i < this.groupBys.length) {
            int columnIndex = this.groupBys[i].getColumnIndex();
            if (!this.groupBys[i].isInSameGroup(obj1.getFieldValue(columnIndex), obj2.getFieldValue(columnIndex))) {
                return i + 1;
            }
            ++i;
        }
        return this.groupBys.length + 1;
    }

    public int getStartingGroup() throws DataException {
        return this.getBreakingGroup(this.previous, this.current);
    }

    public int getEndingGroup() throws DataException {
        return this.getBreakingGroup(this.current, this.next);
    }

    public void registerPreviousResultObject(IResultObject previous) {
        this.previous = previous;
    }

    public void registerCurrentResultObject(IResultObject current) {
        this.current = current;
    }

    public void registerNextResultObject(IResultObject next) {
        this.next = next;
    }

    public void next(int rowId) throws DataException {
        int breakLevel = this.previous == null ? 0 : this.getBreakLevel(this.current, this.previous);
        try {
            int level = breakLevel;
            while (level < this.groupInstanceIndex.length) {
                GroupInfo group = new GroupInfo();
                if (level != 0) {
                    group.parent = this.groupInstanceIndex[level - 1] - 1;
                }
                group.firstChild = level == this.groupInstanceIndex.length - 1 ? rowId : this.groupInstanceIndex[level + 1];
                int n = level;
                this.groupInstanceIndex[n] = this.groupInstanceIndex[n] + 1;
                if (this.streamManager != null) {
                    IOUtil.writeInt(this.groupOutput[level], group.parent);
                    IOUtil.writeInt(this.groupOutput[level], group.firstChild);
                    if (this.previous != null) {
                        this.saveToAggrValuesToDocument(level, rowId);
                    }
                }
                ++level;
            }
            this.aggrHelper.onRow(this.getStartingGroup(), this.getEndingGroup(), this.current, rowId);
            if (this.next == null) {
                int i = 0;
                while (i < this.aggrOutput.length) {
                    this.saveToAggrValuesToDocument(i, rowId);
                    ++i;
                }
            }
            if (this.runningAggrs.size() > 0) {
                for (String aggrName : this.runningAggrs) {
                    IOUtil.writeObject(this.combinedAggrOutput, this.aggrHelper.getLatestAggrValue(aggrName));
                }
                IOUtil.writeLong(this.combinedAggrIndexOutput, this.combinedAggrRAOutput.getOffset());
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private void saveToAggrValuesToDocument(int i, int rowId) throws IOException, DataException {
        if (this.aggrOutput[i] != null) {
            for (String aggrName : this.groupAggrs.get(i)) {
                IOUtil.writeObject(this.aggrOutput[i], this.aggrHelper.getLatestAggrValue(aggrName));
            }
            if (this.aggrIndexOutput[i] != null) {
                IOUtil.writeLong(this.aggrIndexOutput[i], this.aggrRAOutput[i].getOffset());
            }
        }
        this.latestAggrAvailableIndex[i] = rowId - 1;
    }

    private int getBreakLevel(IResultObject currRow, IResultObject prevRow) throws DataException {
        assert (currRow != null);
        assert (prevRow != null);
        int breakLevel = 0;
        while (breakLevel < this.groupBys.length) {
            GroupBy groupBy;
            int colIndex = this.groupBys[breakLevel].getColumnIndex();
            Object currObjectValue = null;
            Object prevObjectValue = null;
            if (colIndex >= 0) {
                currObjectValue = currRow.getFieldValue(colIndex);
                prevObjectValue = prevRow.getFieldValue(colIndex);
            }
            if (!(groupBy = this.groupBys[breakLevel]).isInSameGroup(currObjectValue, prevObjectValue)) {
                int i = breakLevel + 1;
                while (i < this.groupBys.length) {
                    this.groupBys[i].reset();
                    ++i;
                }
                break;
            }
            ++breakLevel;
        }
        return breakLevel;
    }

    public void close() throws DataException {
        try {
            int i;
            if (this.groupOutput != null) {
                i = 0;
                while (i < this.groupOutput.length) {
                    this.groupOutput[i].seek(0L);
                    IOUtil.writeInt(this.groupOutput[i], this.groupInstanceIndex[i]);
                    this.groupOutput[i].close();
                    ++i;
                }
                this.groupOutput = null;
            }
            if (this.aggrOutput != null) {
                i = 0;
                while (i < this.aggrOutput.length) {
                    if (this.aggrOutput[i] != null) {
                        this.aggrOutput[i].close();
                    }
                    ++i;
                }
                this.aggrOutput = null;
            }
            if (this.aggrIndexOutput != null) {
                i = 0;
                while (i < this.aggrIndexOutput.length) {
                    if (this.aggrIndexOutput[i] != null) {
                        this.aggrIndexOutput[i].close();
                    }
                    ++i;
                }
                this.aggrIndexOutput = null;
            }
            if (this.overallAggrs.size() > 0 && this.combinedAggrIndexOutput != null) {
                this.combinedAggrIndexRAOutput.seek(0L);
                IOUtil.writeLong(this.combinedAggrIndexOutput, this.combinedAggrRAOutput.getOffset());
                this.combinedAggrIndexRAOutput.close();
                for (String aggrName : this.overallAggrs) {
                    IOUtil.writeObject(this.combinedAggrOutput, this.aggrHelper.getLatestAggrValue(aggrName));
                }
                this.combinedAggrOutput.close();
            }
            if (this.aggrHelper != null) {
                this.aggrHelper.close();
                this.aggrHelper = null;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public void doSave(StreamManager manager) throws DataException {
        try {
            this.streamManager = manager;
            if (this.streamManager != null) {
                int i;
                this.groupOutput = new RAOutputStream[this.groupBys.length];
                this.aggrOutput = new DataOutputStream[this.groupBys.length];
                this.aggrRAOutput = new RAOutputStream[this.groupBys.length];
                this.aggrIndexOutput = new DataOutputStream[this.groupBys.length];
                if (this.overallAggrs.size() > 0 || this.runningAggrs.size() > 0) {
                    this.combinedAggrIndexRAOutput = (RAOutputStream)this.streamManager.getOutStream(105, 0, 0);
                    this.combinedAggrRAOutput = (RAOutputStream)this.streamManager.getOutStream(106, 0, 0);
                    this.combinedAggrOutput = new DataOutputStream(this.combinedAggrRAOutput);
                    this.combinedAggrIndexOutput = new DataOutputStream(this.combinedAggrIndexRAOutput);
                    IOUtil.writeLong(this.combinedAggrIndexOutput, -1L);
                    IOUtil.writeInt(this.combinedAggrOutput, this.overallAggrs.size());
                    i = 0;
                    while (i < this.overallAggrs.size()) {
                        IOUtil.writeString(this.combinedAggrOutput, this.overallAggrs.get(i));
                        ++i;
                    }
                    IOUtil.writeInt(this.combinedAggrOutput, this.runningAggrs.size());
                    i = 0;
                    while (i < this.runningAggrs.size()) {
                        IOUtil.writeString(this.combinedAggrOutput, this.runningAggrs.get(i));
                        ++i;
                    }
                    IOUtil.writeLong(this.combinedAggrIndexOutput, this.combinedAggrRAOutput.getOffset());
                }
                i = 0;
                while (i < this.groupBys.length) {
                    this.groupOutput[i] = this.streamManager.getOutStream(120, i);
                    IOUtil.writeInt(this.groupOutput[i], Integer.MAX_VALUE);
                    if (!this.groupAggrs.get(i).isEmpty()) {
                        this.aggrRAOutput[i] = this.streamManager.getOutStream(104, i);
                        this.aggrIndexOutput[i] = new DataOutputStream(this.streamManager.getOutStream(103, i));
                        this.aggrOutput[i] = new DataOutputStream(this.aggrRAOutput[i]);
                        IOUtil.writeInt(this.aggrOutput[i], i + 1);
                        IOUtil.writeInt(this.aggrOutput[i], this.groupAggrs.get(i).size());
                        for (String aggrName : this.groupAggrs.get(i)) {
                            IOUtil.writeString(new DataOutputStream(this.aggrOutput[i]), aggrName);
                        }
                        IOUtil.writeLong(this.aggrIndexOutput[i], this.aggrRAOutput[i].getOffset());
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public boolean isAggrAtIndexAvailable(String aggrName, int currentIndex) throws DataException {
        assert (this.aggrHelper != null);
        if (this.aggrHelper.getAggrInfo(aggrName).getAggregation().getType() == 1) {
            return true;
        }
        if (this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() == 0) {
            return this.current == null;
        }
        return this.latestAggrAvailableIndex[this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() - 1] >= currentIndex;
    }

    public Integer[] getGroupInstanceIndex() {
        return this.groupInstanceIndex;
    }
}

