/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.stream.DataStreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.MetaStreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.StreamID;
import org.eclipse.birt.data.engine.impl.document.stream.StreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.StreamWriter;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamManager {
    private DataEngineContext context;
    private String rootQueryResultID;
    private String parentQueryResultID;
    private String selfQueryResultID;
    private String subQueryID;
    private String subQueryName;
    public static final int BASE_SCOPE = 0;
    public static final int PARENT_SCOPE = 1;
    public static final int SELF_SCOPE = 2;
    public static final int ROOT_STREAM = 0;
    public static final int SUB_QUERY_ROOT_STREAM = 1;
    public static final int SUB_QUERY_STREAM = 2;
    private HashMap cachedStreamManagers;
    private HashMap metaManagers;
    private HashMap dataMetaManagers;
    private int version;
    private static Logger logger = Logger.getLogger(StreamManager.class.getName());

    public StreamManager(DataEngineContext context, QueryResultInfo queryResultInfo) throws DataException {
        this.context = context;
        this.rootQueryResultID = queryResultInfo.getRootQueryResultID();
        this.parentQueryResultID = queryResultInfo.getParentQueryResultID();
        this.selfQueryResultID = queryResultInfo.getSelfQueryResultID();
        this.subQueryName = queryResultInfo.getSubQueryName();
        this.subQueryID = this.subQueryName == null ? null : QueryResultIDUtil.buildSubQueryID(this.subQueryName, queryResultInfo.getIndex());
        this.cachedStreamManagers = new HashMap();
        this.metaManagers = new HashMap();
        this.dataMetaManagers = new HashMap();
        VersionManager vm = new VersionManager(context);
        if (context.getMode() == 1) {
            this.version = vm.getVersion();
            if (this.version == 0) {
                this.version = VersionManager.getLatestVersion();
            }
            vm.setVersion(this.version);
        } else {
            this.version = context.getMode() == 4 && this.rootQueryResultID == null ? (!this.context.hasInStream(null, null, 11) ? VersionManager.getLatestVersion() : vm.getVersion()) : vm.getVersion();
        }
    }

    public RAInputStream getInStream(String streamSubName) throws DataException {
        StreamID streamID;
        block3: {
            streamID = this.getStreamID(0, 0, 0);
            try {
                if (this.context.getDocWriter().exists("/" + streamID.getStartStream() + "/" + streamSubName)) break block3;
                return null;
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        RAInputStream inputStream = this.context.getDocWriter().getInputStream("/" + streamID.getStartStream() + "/" + streamSubName);
        return inputStream;
    }

    public RAOutputStream getOutStream(String streamSubName) throws DataException {
        RAOutputStream outputStream;
        StreamID streamID = this.getStreamID(0, 0, 0);
        try {
            outputStream = this.context.getDocWriter().getOutputStream("/" + streamID.getStartStream() + "/" + streamSubName);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return outputStream;
    }

    public RAOutputStream getOutStream(int streamType, int subIndex) throws DataException {
        RAOutputStream outputStream;
        StreamID streamID = this.getStreamID(0, 0, 0);
        try {
            String path = DataEngineContext.getPath(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
            outputStream = this.context.getDocWriter().getOutputStream(String.valueOf(path) + "/" + subIndex);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return outputStream;
    }

    public String getOutStreamName(String streamSubName) throws DataException {
        StreamID streamID = this.getStreamID(0, 0, 0);
        return "/" + streamID.getStartStream() + "/" + streamSubName;
    }

    public OutputStream getOutStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
        if (!this.useTempStream(streamType)) {
            RAOutputStream outputStream = this.context.getOutputStream(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
            if (this.version >= 140) {
                return outputStream;
            }
            if (streamType == 21 && this.version >= 10) {
                try {
                    outputStream.seek(outputStream.length());
                    outputStream.writeInt(0);
                    outputStream.writeInt(0);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                }
            }
            return outputStream;
        }
        int sType = 99;
        if (streamType == 21 || streamType == 22) {
            sType = 21;
        }
        return this.getTempStreamManager(this.getStreamID(sType, streamPos, streamScope)).getOutputStream(streamType);
    }

    public RAInputStream getInStream(int streamType, String startStream, String subQueryStream) throws DataException {
        StreamID streamID = new StreamID(startStream, subQueryStream);
        return this.createInputStream(streamID, streamType);
    }

    public RAInputStream getInStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
        return this.createInputStream(streamID, streamType);
    }

    public RAInputStream getInStream2(int streamType, int streamPos, int streamScope, int parentIndex) throws DataException {
        String tempID = this.subQueryID;
        this.subQueryID = QueryResultIDUtil.buildSubQueryID(this.subQueryName, parentIndex);
        StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
        this.subQueryID = tempID;
        return this.createInputStream(streamID, streamType);
    }

    private RAInputStream createInputStream(StreamID streamID, int streamType) throws DataException {
        if (!this.useTempStream(streamType)) {
            RAInputStream stream = this.context.getInputStream(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
            if (this.version >= 140) {
                return stream;
            }
            if (streamType == 21 && this.version >= 10) {
                try {
                    stream.readInt();
                    int size = stream.readInt();
                    stream.skip(size);
                    stream.readInt();
                    stream.readInt();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                }
            }
            return stream;
        }
        return this.getMetaManager(streamID, streamType).getRAInputStream(streamType);
    }

    public IDocArchiveWriter getDocWriter() {
        return this.context.getDocWriter();
    }

    private StreamReader getMetaManager(StreamID id, int sType) throws DataException {
        if (sType == 21 || sType == 22) {
            if (this.dataMetaManagers.get(id) == null) {
                this.dataMetaManagers.put(id, new DataStreamReader(this.context, id));
            }
            return (StreamReader)this.dataMetaManagers.get(id);
        }
        if (this.metaManagers.get(id) == null) {
            this.metaManagers.put(id, new MetaStreamReader(this.context, id));
        }
        return (StreamReader)this.metaManagers.get(id);
    }

    public void dropStreams(int streamType) throws DataException {
        if (this.context.getDocWriter() != null) {
            StreamID streamID = this.getStreamID(streamType, 0, 0);
            try {
                String path = DataEngineContext.getPath(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
                List streams = this.context.getDocWriter().listStreams(path);
                for (String streamName : streams) {
                    this.context.getDocWriter().dropStream(streamName);
                }
                if (this.context.getDocWriter().exists(path)) {
                    this.context.getDocWriter().dropStream(path);
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
    }

    public List<RAInputStream> getInStreams(int streamType, int streamPos, int streamScope) throws DataException {
        if (this.context.getDocReader() != null) {
            StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
            try {
                List streams = this.context.getDocReader().listStreams(DataEngineContext.getPath(streamID.getStartStream(), streamID.getSubQueryStream(), streamType));
                Collections.sort(streams);
                ArrayList<RAInputStream> results = new ArrayList<RAInputStream>();
                for (String streamName : streams) {
                    results.add(this.context.getDocReader().getInputStream(streamName));
                }
                return results;
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        return new ArrayList<RAInputStream>();
    }

    public boolean hasInStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
        if (this.useTempStream(streamType)) {
            return this.getMetaManager(streamID, streamType).hasInputStream(streamType);
        }
        return this.context.hasInStream(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
    }

    public boolean hasOutStream(int streamType, int streamPos, int streamScope) {
        StreamID streamID = this.getStreamID(streamType, streamPos, streamScope);
        if (!this.useTempStream(streamType)) {
            return this.context.hasOutStream(streamID.getStartStream(), streamID.getSubQueryStream(), streamType);
        }
        return this.getTempStreamManager(this.getStreamID(99, streamPos, streamScope)).hasOutputStream(streamID);
    }

    public void dropStream1(int streamType) throws DataException {
        StreamID streamID = this.getStreamID(streamType, 0, 0);
        this.context.dropStream(streamID.getStartStream(), null, streamType);
    }

    public void dropStream2(String subStream) throws DataException {
        StreamID streamID = this.getStreamID(-1, 0, 0);
        String realStream = String.valueOf(streamID.getStartStream()) + "/" + subStream;
        this.context.dropStream(realStream);
    }

    public int getVersion() {
        return this.version;
    }

    private StreamID getStreamID(int streamType, int streamPos, int streamScope) {
        String startStream = null;
        if (streamScope == 0) {
            startStream = this.rootQueryResultID != null ? this.rootQueryResultID : this.selfQueryResultID;
        } else if (streamScope == 1) {
            startStream = QueryResultIDUtil.getRealStreamID(this.rootQueryResultID, this.parentQueryResultID);
        } else if (streamScope == 2) {
            startStream = QueryResultIDUtil.getRealStreamID(this.rootQueryResultID, this.selfQueryResultID);
        }
        String subQueryStream = null;
        if (!this.isSubquery()) {
            if (streamPos == 0) {
                subQueryStream = null;
            } else if (streamPos == 1) {
                subQueryStream = this.subQueryName;
            } else if (streamPos == 2) {
                subQueryStream = this.subQueryID;
            }
        } else if (streamPos == 0) {
            subQueryStream = this.subQueryID;
        } else if (streamPos == 1) {
            subQueryStream = this.subQueryName;
        } else if (streamPos == 2) {
            subQueryStream = this.subQueryID;
        }
        return new StreamID(startStream, subQueryStream);
    }

    public boolean isSubquery() {
        return this.subQueryName != null;
    }

    public boolean isBasedOnSecondRD() throws DataException {
        return this.parentQueryResultID != null;
    }

    public boolean isSecondRD() throws DataException {
        return this.rootQueryResultID != null;
    }

    public String getQueryResultUID() {
        return QueryResultIDUtil.buildID(this.rootQueryResultID, this.selfQueryResultID);
    }

    private StreamWriter getTempStreamManager(StreamID id) {
        if (this.cachedStreamManagers.get(id) == null) {
            this.cachedStreamManagers.put(id, new StreamWriter(this.context, id));
        }
        return (StreamWriter)this.cachedStreamManagers.get(id);
    }

    private boolean useTempStream(int streamType) {
        if (this.version < 2 || this.version >= 140) {
            return false;
        }
        switch (streamType) {
            case 21: {
                return false;
            }
            case 22: {
                return this.version >= 10;
            }
            case 23: {
                return false;
            }
            case 31: {
                return false;
            }
            case 33: {
                return this.version < 10;
            }
            case 32: {
                return true;
            }
            case 41: {
                return true;
            }
            case 42: {
                return false;
            }
            case 43: {
                return true;
            }
            case 44: {
                return false;
            }
            case 51: {
                return true;
            }
            case 61: {
                return true;
            }
            case 71: {
                return true;
            }
            case 102: {
                return false;
            }
            case 99: {
                return false;
            }
            case 100: {
                return false;
            }
            case 103: {
                return true;
            }
            case 104: {
                return true;
            }
        }
        return false;
    }
}

