/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;

public class SampleDBJDBCConnectionFactory
implements IConnectionFactory {
    private static final Logger logger = Logger.getLogger(SampleDBJDBCConnectionFactory.class.getName());
    private Driver derbyDriver;
    private DerbyClassLoader derbyClassLoader;

    public Connection getConnection(String driverClass, String url, Properties connectionProperties) throws SQLException {
        if (!driverClass.equals("org.eclipse.birt.report.data.oda.sampledb.Driver")) {
            logger.log(Level.SEVERE, "Unexpected driverClass: " + driverClass);
            throw new SQLException("Unexpected driverClass " + driverClass);
        }
        if (!url.equals("jdbc:classicmodels:sampledb")) {
            logger.log(Level.WARNING, "Unexpected url: " + url);
            throw new SQLException("Classic Models Inc. Sample Database Driver does not recognize url: " + driverClass);
        }
        String dbUrl = SampledbPlugin.getDBUrl();
        Properties props = connectionProperties != null ? (Properties)connectionProperties.clone() : new Properties();
        props.put("user", "ClassicModels");
        props.put("password", "");
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Getting Sample DB JDBC connection. DriverClass=org.apache.derby.jdbc.EmbeddedDriver, Url=" + dbUrl);
        }
        this.initClassLoaders();
        return this.getDerbyDriver().connect(dbUrl, props);
    }

    void shutdownDerby() {
        try {
            if (this.derbyClassLoader == null || !this.derbyClassLoader.isGood()) {
                this.initClassLoaders();
            }
            this.getDerbyDriver().connect("jdbc:derby:;shutdown=true", null);
            this.derbyClassLoader.close();
            this.derbyClassLoader = null;
        }
        catch (SQLException sQLException) {}
    }

    private void initClassLoaders() {
        if (this.derbyClassLoader == null) {
            this.derbyClassLoader = new DerbyClassLoader();
        }
    }

    private Driver getDerbyDriver() throws SQLException {
        if (this.derbyDriver == null) {
            try {
                this.derbyDriver = (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver", true, this.derbyClassLoader).newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load Derby embedded driver: org.apache.derby.jdbc.EmbeddedDriver", e);
                throw new SQLException(e.getLocalizedMessage());
            }
        }
        return this.derbyDriver;
    }

    public static String getDbUser() {
        return "ClassicModels";
    }

    private static class DerbyClassLoader
    extends URLClassLoader {
        boolean isGood = false;

        public DerbyClassLoader() {
            super(new URL[0], DerbyClassLoader.class.getClassLoader());
            URL fileURL = PluginResourceLocator.getPluginEntry((String)"org.apache.derby.core", (String)"derby.jar");
            try {
                fileURL = PluginResourceLocator.toFileURL((URL)fileURL);
                if (fileURL == null) {
                    logger.warning("Unable to find derby.jar in org.apache.derby.core plugin.");
                } else {
                    this.addURL(fileURL);
                    this.isGood = true;
                }
            }
            catch (IOException iOException) {
                logger.warning("Unable to find derby.jar in org.apache.derby.core plugin.");
            }
        }

        public static boolean isDerbyClass(String className) {
            return className.startsWith("org.apache.derby");
        }

        public static boolean isDerbyResource(String name) {
            return name.startsWith("org/apache/derby") || name.startsWith("/org/apache/derby");
        }

        public boolean isGood() {
            return this.isGood;
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return this.getClass().getProtectionDomain().getPermissions();
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isGood && DerbyClassLoader.isDerbyClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Load derby class: " + name);
                    }
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }

        public URL getResource(String name) {
            if (this.isGood && DerbyClassLoader.isDerbyResource(name)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Load derby resource: " + name);
                }
                return this.findResource(name);
            }
            return super.getResource(name);
        }
    }
}

