/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.QueryUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.AbstractElement;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.BaseResultSetDecorator;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContent
extends AbstractElement
implements IContent {
    private static final DimensionType EMPTY_DIMENSION = new DimensionType("NONE");
    private static final String STYLE_EMPTY_CLASS = "__birt__empty_style_class";
    protected transient IReportContent report;
    protected transient CSSEngine cssEngine;
    protected String name;
    protected DimensionType x;
    protected DimensionType y;
    protected DimensionType width;
    protected DimensionType height;
    protected IHyperlinkAction hyperlink;
    protected String bookmark;
    protected String helpText;
    protected transient String styleClass;
    protected IStyle inlineStyle;
    protected transient IStyle style;
    protected transient IStyle computedStyle;
    protected transient Object generateBy;
    protected InstanceID instanceId;
    protected Object toc;
    protected String acl;
    protected Map<String, Object> userProperties;
    protected Map<String, Object> extProperties;
    protected transient long offset = -1L;
    protected transient boolean isLastChild = false;
    protected transient boolean hasChildren = false;
    protected transient int version = -1;
    protected static final int LAST_EXTENSION = 2;
    protected Object[] extensions;
    protected static final int VERSION_0 = 0;
    protected static final int VERSION_1 = 1;
    static final short FIELD_NONE = -1;
    static final short FIELD_NAME = 0;
    static final short FIELD_X = 1;
    static final short FIELD_Y = 2;
    static final short FIELD_WIDTH = 3;
    static final short FIELD_HEIGHT = 4;
    static final short FIELD_HYPERLINK = 5;
    static final short FIELD_BOOKMARK = 6;
    static final short FIELD_HELPTEXT = 7;
    static final short FIELD_INLINESTYLE_VERSION_0 = 8;
    static final short FIELD_INSTANCE_ID = 9;
    static final short FIELD_TOC = 10;
    static final short FIELD_INLINESTYLE_VERSION_1 = 11;
    static final short FIELD_ACL = 12;
    static final short FIELD_CLASS_STYLE = 13;
    static final short FIELD_USER_PROPERTIES = 14;
    static final short FIELD_EXTENSIONS = 15;

    public AbstractContent(IReportContent report) {
        assert (report != null && report instanceof ReportContent);
        this.report = report;
        this.parent = report.getRoot();
        this.cssEngine = ((ReportContent)report).getCSSEngine();
    }

    @Override
    public void setReportContent(IReportContent report) {
        assert (report != null && report instanceof ReportContent);
        this.report = report;
        this.cssEngine = ((ReportContent)report).getCSSEngine();
    }

    AbstractContent(IContent content) {
        this.report = content.getReportContent();
        this.parent = content.getReportContent().getRoot();
        this.cssEngine = ((ReportContent)content.getReportContent()).getCSSEngine();
        this.name = content.getName();
        this.x = content.getX();
        this.y = content.getY();
        this.width = content.getWidth();
        this.height = content.getHeight();
        this.hyperlink = content.getHyperlinkAction();
        this.bookmark = content.getBookmark();
        this.helpText = content.getHelpText();
        this.inlineStyle = this.copyInlineStyle(content);
        this.generateBy = content.getGenerateBy();
        this.styleClass = content.getStyleClass() != null ? content.getStyleClass() : STYLE_EMPTY_CLASS;
        this.instanceId = content.getInstanceID();
        this.toc = content.getTOC();
        Object ext = content.getExtension(0);
        if (ext != null) {
            this.setExtension(0, ext);
        }
        if ((ext = content.getExtension(1)) != null) {
            this.setExtension(1, ext);
        }
    }

    protected IStyle copyInlineStyle(IContent content) {
        IStyle inline = content.getInlineStyle();
        if (inline != null) {
            if (inline instanceof StyleDeclaration) {
                return new StyleDeclaration((StyleDeclaration)inline);
            }
            StyleDeclaration newStyle = new StyleDeclaration(this.cssEngine);
            newStyle.setProperties(inline);
            return newStyle;
        }
        return null;
    }

    @Override
    public IReportContent getReportContent() {
        return this.report;
    }

    @Override
    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.generateBy instanceof ReportElementDesign) {
            return ((ReportElementDesign)this.generateBy).getName();
        }
        return null;
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitContent(this, value);
    }

    @Override
    public String getBookmark() {
        return this.bookmark;
    }

    @Override
    public IHyperlinkAction getHyperlinkAction() {
        return this.hyperlink;
    }

    @Override
    public DimensionType getHeight() {
        if (this.height == EMPTY_DIMENSION) {
            return null;
        }
        if (this.height != null) {
            return this.height;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getHeight();
        }
        return null;
    }

    @Override
    public DimensionType getWidth() {
        if (this.width == EMPTY_DIMENSION) {
            return null;
        }
        if (this.width != null) {
            return this.width;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getWidth();
        }
        return null;
    }

    @Override
    public DimensionType getX() {
        if (this.x != null) {
            return this.x;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getX();
        }
        return null;
    }

    @Override
    public DimensionType getY() {
        if (this.y != null) {
            return this.y;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getY();
        }
        return null;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public IStyle getComputedStyle() {
        if (this.computedStyle == null) {
            if (this.parent == null) {
                this.computedStyle = new ComputedStyle(this);
            } else if (this.inlineStyle == null || this.inlineStyle.isEmpty()) {
                String styleClass = this.getStyleClass();
                ComputedStyle pcs = (ComputedStyle)((IContent)this.parent).getComputedStyle();
                ComputedStyle cs = pcs.getCachedStyle(styleClass);
                if (cs == null) {
                    cs = new ComputedStyle(this);
                    pcs.addCachedStyle(styleClass, cs);
                }
                this.computedStyle = cs;
            } else {
                this.computedStyle = new ComputedStyle(this);
            }
        }
        return this.computedStyle;
    }

    @Override
    public IStyle getStyle() {
        if (this.style == null) {
            String styleClass;
            if (this.inlineStyle == null) {
                this.inlineStyle = this.report.createStyle();
            }
            if ((styleClass = this.getStyleClass()) != null) {
                IStyle classStyle = this.report.findStyle(styleClass);
                this.style = new CompositeStyle(classStyle, this.inlineStyle);
            } else {
                this.style = this.inlineStyle;
            }
            this.style = new ContentStyle((AbstractStyle)this.style);
        }
        return this.style;
    }

    @Override
    public Object getGenerateBy() {
        return this.generateBy;
    }

    @Override
    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public void setGenerateBy(Object generateBy) {
        this.generateBy = generateBy;
    }

    @Override
    public void setHeight(DimensionType height) {
        this.height = height == null ? EMPTY_DIMENSION : height;
    }

    @Override
    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    @Override
    public void setHyperlinkAction(IHyperlinkAction hyperlink) {
        this.hyperlink = hyperlink;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStyleClass(String name) {
        this.styleClass = name != null ? name : STYLE_EMPTY_CLASS;
        this.style = null;
        this.computedStyle = null;
    }

    @Override
    public String getStyleClass() {
        if (this.styleClass != null) {
            return STYLE_EMPTY_CLASS.equals(this.styleClass) ? null : this.styleClass;
        }
        if (this.generateBy instanceof StyledElementDesign) {
            return ((StyledElementDesign)this.generateBy).getStyleName();
        }
        return null;
    }

    @Override
    public void setInlineStyle(IStyle style) {
        this.inlineStyle = style;
        this.style = null;
        this.computedStyle = null;
    }

    @Override
    public IStyle getInlineStyle() {
        return this.inlineStyle;
    }

    @Override
    public void setWidth(DimensionType width) {
        this.width = width == null ? EMPTY_DIMENSION : width;
    }

    @Override
    public void setX(DimensionType x) {
        this.x = x;
    }

    @Override
    public void setY(DimensionType y) {
        this.y = y;
    }

    @Override
    public InstanceID getInstanceID() {
        return this.instanceId;
    }

    @Override
    public void setInstanceID(InstanceID id) {
        this.instanceId = id;
    }

    @Override
    public void setTOC(Object toc) {
        this.toc = toc;
    }

    @Override
    public Object getTOC() {
        return this.toc;
    }

    @Override
    public Object getExtension(int extension) {
        if (this.extensions != null) {
            assert (extension < 2);
            return this.extensions[extension];
        }
        return null;
    }

    @Override
    public void setExtension(int extension, Object value) {
        if (this.extensions == null) {
            this.extensions = new Object[2];
        }
        this.extensions[extension] = value;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        if (this.name != null) {
            IOUtil.writeShort(out, (short)0);
            IOUtil.writeString(out, this.name);
        }
        if (this.x != null) {
            IOUtil.writeShort(out, (short)1);
            this.x.writeObject(out);
        }
        if (this.y != null) {
            IOUtil.writeShort(out, (short)2);
            this.y.writeObject(out);
        }
        if (this.width != null) {
            IOUtil.writeShort(out, (short)3);
            this.width.writeObject(out);
        }
        if (this.height != null) {
            IOUtil.writeShort(out, (short)4);
            this.height.writeObject(out);
        }
        if (this.hyperlink != null) {
            IOUtil.writeShort(out, (short)5);
            ((ActionContent)this.hyperlink).writeObject(out);
        }
        if (this.bookmark != null) {
            IOUtil.writeShort(out, (short)6);
            IOUtil.writeString(out, this.bookmark);
        }
        if (this.helpText != null) {
            IOUtil.writeShort(out, (short)7);
            IOUtil.writeString(out, this.helpText);
        }
        if (this.inlineStyle != null && !this.inlineStyle.isEmpty()) {
            IOUtil.writeShort(out, (short)11);
            this.inlineStyle.write(out);
        }
        if (this.instanceId != null) {
            IOUtil.writeShort(out, (short)9);
            IOUtil.writeString(out, this.instanceId.toString());
        }
        if (this.toc != null) {
            IOUtil.writeShort(out, (short)10);
            IOUtil.writeObject(out, this.toc);
        }
        if (this.acl != null) {
            IOUtil.writeShort(out, (short)12);
            IOUtil.writeObject(out, this.acl);
        }
        if (this.userProperties != null && this.userProperties.size() > 0) {
            IOUtil.writeShort(out, (short)14);
            IOUtil.writeMap(out, this.userProperties);
        }
        if (this.extProperties != null && !this.extProperties.isEmpty()) {
            IOUtil.writeShort(out, (short)15);
            IOUtil.writeMap(out, this.extProperties);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 0: {
                this.name = IOUtil.readString(in);
                break;
            }
            case 1: {
                this.x = new DimensionType();
                this.x.readObject(in);
                break;
            }
            case 2: {
                this.y = new DimensionType();
                this.y.readObject(in);
                break;
            }
            case 3: {
                this.width = this.readDimension(in);
                break;
            }
            case 4: {
                this.height = this.readDimension(in);
                break;
            }
            case 5: {
                ActionContent action = new ActionContent();
                action.readObject(in, loader);
                this.hyperlink = action;
                break;
            }
            case 6: {
                this.bookmark = IOUtil.readString(in);
                break;
            }
            case 7: {
                this.helpText = IOUtil.readString(in);
                break;
            }
            case 8: {
                String styleCssText = IOUtil.readString(in);
                if (styleCssText == null || styleCssText.length() == 0) break;
                this.inlineStyle = new StyleDeclaration(this.cssEngine);
                this.inlineStyle.setCssText(styleCssText);
                break;
            }
            case 11: {
                StyleDeclaration style = new StyleDeclaration(this.cssEngine);
                style.read(in);
                if (style.isEmpty()) break;
                this.inlineStyle = style;
                break;
            }
            case 9: {
                String value = IOUtil.readString(in);
                this.instanceId = InstanceID.parse(value);
                break;
            }
            case 10: {
                this.toc = IOUtil.readObject(in, loader);
                break;
            }
            case 12: {
                this.acl = IOUtil.readString(in);
                break;
            }
            case 14: {
                this.userProperties = IOUtil.readMap(in);
                break;
            }
            case 15: {
                this.extProperties = IOUtil.readMap(in);
            }
        }
    }

    private DimensionType readDimension(DataInputStream in) throws IOException {
        DimensionType tmp = new DimensionType();
        tmp.readObject(in);
        if ("NONE".equals(tmp.getChoice())) {
            return EMPTY_DIMENSION;
        }
        return tmp;
    }

    private IStyle readStyle(DataInputStream in) throws IOException {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        style.read(in);
        if (style.isEmpty()) {
            return null;
        }
        return style;
    }

    @Override
    public void readContent(DataInputStream in, ClassLoader loader) throws IOException {
        if (this.version == 1) {
            this.readContentV1(in, loader);
        } else if (this.version == 0) {
            this.readContentV0(in, loader);
        } else {
            throw new IOException("Error.UnknownContentVersion" + this.version);
        }
    }

    protected void readContentV0(DataInputStream in, ClassLoader loader) throws IOException {
        IOUtil.readInt(in);
        int filedId = IOUtil.readInt(in);
        while (filedId != -1) {
            this.readField(0, filedId, in, loader);
            filedId = IOUtil.readInt(in);
        }
    }

    protected void readContentV1(DataInputStream in, ClassLoader loader) throws IOException {
        while (in.available() > 0) {
            short filedId = IOUtil.readShort(in);
            this.readField(1, filedId, in, loader);
        }
    }

    @Override
    public void writeContent(DataOutputStream out) throws IOException {
        this.writeFields(out);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean needSave() {
        if (this.name != null) {
            return true;
        }
        if (this.x != null || this.y != null || this.width != null || this.height != null) {
            return true;
        }
        if (this.hyperlink != null || this.bookmark != null || this.toc != null) {
            return true;
        }
        if (this.helpText != null) {
            return true;
        }
        if (this.inlineStyle != null && !this.inlineStyle.isEmpty()) {
            return true;
        }
        if (this.acl != null) {
            return true;
        }
        if (this.userProperties != null && !this.userProperties.isEmpty()) {
            return true;
        }
        return this.extProperties != null && !this.extProperties.isEmpty();
    }

    @Override
    public IContent cloneContent(boolean isDeep) {
        if (isDeep) {
            throw new UnsupportedOperationException();
        }
        return this.cloneContent();
    }

    protected abstract IContent cloneContent();

    @Override
    public boolean isRTL() {
        IContent rootContent;
        IReportContent reportContent = this.getReportContent();
        if (reportContent != null && (rootContent = reportContent.getRoot()) != null) {
            return "rtl".equals(rootContent.getStyle().getDirection());
        }
        return false;
    }

    @Override
    public boolean isDirectionRTL() {
        return "rtl".equals(this.getComputedStyle().getDirection());
    }

    @Override
    public String getACL() {
        return this.acl;
    }

    @Override
    public void setACL(String acl) {
        this.acl = acl;
    }

    @Override
    public IBaseResultSet getResultSet() {
        ReportContent reportContent = (ReportContent)this.report;
        List<IBaseResultSet> resultSets = QueryUtil.getResultSet(reportContent, this.instanceId);
        if (resultSets == null || resultSets.size() == 0) {
            return null;
        }
        return new BaseResultSetDecorator(resultSets);
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public void setUserProperties(Map<String, Object> properties) {
        this.userProperties = properties;
    }

    @Override
    public boolean hasChildren() {
        return this.hasChildren;
    }

    @Override
    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    @Override
    public boolean isLastChild() {
        return this.isLastChild;
    }

    @Override
    public void setLastChild(boolean isLastChild) {
        this.isLastChild = isLastChild;
    }

    @Override
    public void setParent(IElement parent) {
        super.setParent(parent);
        if (parent != null) {
            ((IContent)parent).setHasChildren(true);
        }
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extProperties;
    }

    @Override
    public void setExtensions(Map<String, Object> properties) {
        this.extProperties = properties;
    }

    class ContentStyle
    extends AbstractStyle
    implements IStyle {
        IStyle style;

        ContentStyle(AbstractStyle style) {
            super(style.getCSSEngine());
            this.style = style;
        }

        public CSSValue getProperty(int index) {
            return this.style.getProperty(index);
        }

        public boolean isEmpty() {
            return this.style.isEmpty();
        }

        public void setProperty(int index, CSSValue value) {
            this.style.setProperty(index, value);
            if (AbstractContent.this.computedStyle != null) {
                AbstractContent.this.computedStyle = null;
            }
        }
    }
}

