/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.excel.BlankData;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class ExcelUtil {
    public static final int SHEETNAME_LENGTH = 31;
    private static final char EXCEL_DECIMAL_SEPARATOR = '.';
    public static final int maxCellTextLength = Short.MAX_VALUE;
    private static final String scienticPattern = "0*.*0*E0*";
    private static final double SECONDS_PER_DAY = 86400.0;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    protected static final BigDecimal MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    protected static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate().subtract(BigDecimal.ONE);
    protected static final BigDecimal MIN_POSITIVE_DECIMAL_NUMBER = new BigDecimal("0.000000000000001");
    protected static final BigDecimal MAX_POSITIVE_DECIMAL_NUMBER = new BigDecimal(1.0E16).subtract(MIN_POSITIVE_DECIMAL_NUMBER);
    protected static final BigDecimal MIN_NEGATIVE_DECIMAL_NUMBER = new BigDecimal(-1.0E15).add(new BigDecimal("0.000000000000001"));
    protected static final BigDecimal MAX_NEGATIVE_DECIMAL_NUMBER = MIN_POSITIVE_DECIMAL_NUMBER.negate();
    protected static final long MILLISECS_PER_DAY = 86400000L;
    private static final long BASE_DATE_TIME;
    private static final String validStr = "#.0<>()%_";
    private static final String specialStr = "mMdDyYhHsSeEbBgGnN/*\"@";
    private static final String currencySymbol = "\u00a3\u00a2\u20ac\uffe5\u00a5";
    protected static Logger logger;
    private static final HashSet<Character> splitChar;
    private static Pattern pattern;
    private static Map<String, String> formatCache;
    private static Map<String, String> namedPatterns;
    public static final float INCH_PT = 72.0f;
    public static final float PT_TWIPS = 20.0f;
    public static final float INCH_TWIPS = 1440.0f;
    public static final int PAPER_LETTER = 1;
    public static final int PAPER_TABLOID = 3;
    public static final int PAPER_LEGAL = 5;
    public static final int PAPER_STATEMENT = 6;
    public static final int PAPER_EXECUTIVE = 7;
    public static final int PAPER_A3 = 8;
    public static final int PAPER_A4 = 9;
    public static final int PAPER_A5 = 11;
    public static final int PAPER_B4 = 12;
    public static final int PAPER_B5 = 13;
    public static final int PAPER_FOLIO = 14;
    public static final int PAPER_10_ENVELOP = 20;
    public static final int PAPER_DL_ENVELOPE = 27;
    public static final int PAPER_C5_ENVELOPE = 28;
    public static final int PAPER_B5_ENVELOPE = 34;
    public static final int PAPER_MONARCH_ENVELOPE = 37;
    public static final int PAPER_ISOB4 = 42;
    private static String invalidBookmarkChars;
    private static final String reg1 = "Total.(count|ave|sum|max|min)\\(";
    private static final String reg2 = "\\)";
    private static final String reg3 = "\\[";
    private static final String reg4 = "\\]";
    public static String ZIP;
    public static String PHONE;
    public static String SOCIAL;
    public static String ZIP_CODE;
    public static String PHONE_CODE;
    public static String SOCIALNUMBER_CODE;
    private static final double POINTS_PER_INCH = 72.0;
    private static final double CM_PER_INCH = 2.54;
    private static final double POINTS_PER_CM = 28.346456692913385;

    static {
        logger = Logger.getLogger(ExcelUtil.class.getName());
        splitChar = new HashSet();
        pattern = Pattern.compile(scienticPattern, 42);
        formatCache = new HashMap<String, String>();
        namedPatterns = new HashMap<String, String>();
        Calendar date = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT-0:00"));
        date.setTime(new java.util.Date("1900/01/01"));
        BASE_DATE_TIME = date.getTimeInMillis();
        splitChar.add(Character.valueOf(' '));
        splitChar.add(Character.valueOf('\r'));
        splitChar.add(Character.valueOf('\n'));
        namedPatterns.put("Fixed", "Fixed");
        namedPatterns.put("Percent", "Percent");
        namedPatterns.put("Scientific", "Scientific");
        namedPatterns.put("Standard", "Standard");
        namedPatterns.put("General Number", "General");
        invalidBookmarkChars = "`~!@#$%^&*()-=+\\|[]{};:'\",./?>< \t\n\r\uff01\uffe5\uff08\uff09\uff1a\uff1b\uff0c";
        ZIP = "@@@@@-@@@@";
        PHONE = "(@@@)@@@-@@@@";
        SOCIAL = "@@@-@@-@@@@";
        ZIP_CODE = "00000\\-0000";
        PHONE_CODE = "[<=9999999]###\\-####;\\(###\\)\\ ###\\-####";
        SOCIALNUMBER_CODE = "000\\-00\\-0000";
    }

    public static String ridQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static boolean isValidBookmarkName(String name) {
        if (name.equalsIgnoreCase("r")) {
            return false;
        }
        if (name.equalsIgnoreCase("c")) {
            return false;
        }
        if (name.startsWith("auto_generated_bookmark_")) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (invalidBookmarkChars.indexOf(name.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        if (name.matches("[0-9].*")) {
            return false;
        }
        if (name.matches("([A-Za-z]|[A-Ha-h][A-Za-z]|[Ii][A-Va-v])[0-9]{1,5}.*")) {
            String[] strs = name.split("[A-Za-z]");
            if (strs.length > 0) {
                int rowId = 0;
                try {
                    rowId = Integer.parseInt(strs[strs.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
                return rowId > 65536;
            }
            return true;
        }
        return true;
    }

    public static String formatDate(Object data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.ENGLISH);
        java.util.Date date = ExcelUtil.getDate(data);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static java.util.Date getDate(Object data) {
        java.util.Date date = null;
        date = data instanceof Calendar ? ((Calendar)data).getTime() : (data instanceof java.util.Date ? (java.util.Date)data : null);
        return date;
    }

    public static String formatNumberAsDecimal(Object data) {
        Number number = (Number)data;
        DecimalFormat numberFormat = new DecimalFormat("0.##############");
        numberFormat.setMaximumFractionDigits(15);
        ExcelUtil.updateExcelDecimalSeparator(numberFormat);
        return numberFormat.format(number);
    }

    private static void updateExcelDecimalSeparator(DecimalFormat numberFormat) {
        DecimalFormatSymbols symbol = numberFormat.getDecimalFormatSymbols();
        if (symbol.getDecimalSeparator() != '.') {
            symbol.setDecimalSeparator('.');
            numberFormat.setDecimalFormatSymbols(symbol);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String formatNumberAsScienceNotation(Number data) {
        block5: {
            if (!ExcelUtil.$assertionsDisabled && !(data instanceof BigDecimal)) {
                throw new AssertionError();
            }
            bigDecimal = (BigDecimal)data;
            scale = 0;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                return "0";
            }
            prefix = "";
            if (bigDecimal.compareTo(BigDecimal.ZERO) == -1) {
                prefix = "-";
                bigDecimal = bigDecimal.negate();
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) != -1) ** GOTO lbl19
            while (bigDecimal.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal = bigDecimal.movePointRight(1);
                --scale;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                bigDecimal = bigDecimal.movePointLeft(1);
                ++scale;
lbl19:
                // 2 sources

                ** while (bigDecimal.compareTo((BigDecimal)BigDecimal.TEN) == 1)
            }
        }
        decimalFormat = new DecimalFormat("0.##############");
        ExcelUtil.updateExcelDecimalSeparator(decimalFormat);
        number = decimalFormat.format(bigDecimal);
        sign = scale >= 0 ? "+" : "";
        return String.valueOf(prefix) + number + "E" + sign + scale;
    }

    public static int getType(Object val) {
        if (val instanceof Number) {
            return 1;
        }
        if (val instanceof java.util.Date) {
            return 0;
        }
        if (val instanceof Calendar) {
            return 3;
        }
        if (val instanceof Boolean) {
            return 6;
        }
        return 2;
    }

    private static String replaceDateFormat(String pattern) {
        if (pattern == null) {
            String rg = "";
            return rg;
        }
        StringBuffer toAppendTo = new StringBuffer();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
                count = 0;
            }
            if (ch == '/') {
                toAppendTo.append('\\');
                toAppendTo.append(ch);
            } else if (ch == '\'') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append("\"");
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote) {
                prevCh = ch;
                ++count;
            } else {
                toAppendTo.append(ch);
            }
            ++i;
        }
        if (count > 0) {
            toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
        }
        return toAppendTo.toString();
    }

    private static String subReplaceDateFormat(char ch, int count) {
        StringBuffer current = new StringBuffer();
        int patternCharIndex = -1;
        String datePatternChars = "GyMdkHmsSEDFwWahKz";
        patternCharIndex = datePatternChars.indexOf(ch);
        if (patternCharIndex == -1) {
            int i = 0;
            while (i < count) {
                current.append(ch);
                ++i;
            }
            return current.toString();
        }
        switch (patternCharIndex) {
            case 0: {
                return "";
            }
            case 1: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 4: {
                return "h";
            }
            case 5: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < count) {
                    current.append("a");
                    ++i;
                }
                break;
            }
            case 14: {
                return "AM/PM";
            }
            case 15: {
                int i = 0;
                while (i < count) {
                    current.append(ch);
                    ++i;
                }
                break;
            }
            case 17: {
                return "";
            }
            default: {
                return "";
            }
        }
        return current.toString();
    }

    public static String getPattern(Object data, String val) {
        if (val != null && data instanceof java.util.Date) {
            return ExcelUtil.replaceDateFormat(val);
        }
        if (val == null && data instanceof Time) {
            return "Long Time";
        }
        if (val == null && data instanceof Date) {
            return "mmm d, yyyy";
        }
        if (val == null && data instanceof java.util.Date) {
            return "mmm d, yyyy h:mm AM/PM";
        }
        if (val != null && data instanceof Number) {
            return new NumberFormatter(val).getPattern();
        }
        if (val != null && data instanceof String) {
            return new StringFormatter(val).getPattern();
        }
        return null;
    }

    public static String replaceAll(String str, String old, String news) {
        if (str == null) {
            return str;
        }
        int begin = 0;
        int idx = 0;
        int len = old.length();
        StringBuffer buf = new StringBuffer();
        while ((idx = str.indexOf(old, begin)) >= 0) {
            buf.append(str.substring(begin, idx));
            buf.append(news);
            begin = idx + len;
        }
        return new String(buf.append(str.substring(begin)));
    }

    public static String getValue(String val) {
        if (val == null) {
            return "NULL";
        }
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int convertToPt(String size) {
        try {
            int s = Integer.valueOf(size.substring(0, size.length() - 2));
            if (size.endsWith("in")) {
                return s * 72;
            }
            if (size.endsWith("cm")) {
                return (int)((double)s / 2.54 * 72.0);
            }
            if (size.endsWith("mm")) {
                return (int)((double)(s * 10) / 2.54 * 72.0);
            }
            if (size.endsWith("pc")) {
                return s;
            }
            return s;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unknown unit: " + size);
            return 0;
        }
    }

    public static double convertColWidth(double width) {
        return ExcelUtil.convertColWidth(width, 96);
    }

    public static double convertColWidth(double width, int dpi) {
        float PX_PT = 72.0f / (float)dpi;
        if (width < 0.0) {
            return 0.0;
        }
        double result = 0.0;
        double widthInPixel = width / (double)PX_PT;
        double digitalWidth = 7.0;
        result = (int)((widthInPixel - 5.0) / digitalWidth * 100.0 + 0.5);
        double characterNumber = result / 100.0;
        result = (int)((characterNumber * digitalWidth + 5.0) / digitalWidth * 256.0);
        return result / 256.0;
    }

    public static boolean isBigNumber(Object number) {
        if (number == null) {
            return false;
        }
        try {
            BigDecimal num = ExcelUtil.getBigDecimal(number);
            return num.compareTo(MAX_DOUBLE) == 1 || num.compareTo(MIN_DOUBLE) == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static BigDecimal getBigDecimal(Object number) {
        BigDecimal num = null;
        num = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        return num;
    }

    public static boolean displayedAsScientific(Object number) {
        BigDecimal num = ExcelUtil.getBigDecimal(number);
        if (num.compareTo(MAX_POSITIVE_DECIMAL_NUMBER) <= 0 && num.compareTo(MIN_POSITIVE_DECIMAL_NUMBER) >= 0) {
            return false;
        }
        return num.compareTo(MAX_NEGATIVE_DECIMAL_NUMBER) > 0 || num.compareTo(MIN_NEGATIVE_DECIMAL_NUMBER) < 0;
    }

    public static boolean isInfinity(Object number) {
        if (number == null) {
            return false;
        }
        try {
            return Double.isInfinite((Double)number);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getColumnOfExp(String exp) {
        return exp.substring(exp.indexOf("dataSetRow["), exp.lastIndexOf("]") + 1);
    }

    public static boolean isValidExp(String exp, String[] columnNames) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columnNames.length) {
            sb.append(String.valueOf(columnNames[i]) + "|");
            ++i;
        }
        String columnRegExp = "(" + sb.substring(0, sb.length() - 1) + ")";
        columnRegExp = columnRegExp.replaceAll(reg3, "Z");
        columnRegExp = columnRegExp.replaceAll(reg4, "Z");
        String aggregateRegExp = reg1 + columnRegExp + reg2;
        exp = exp.replaceAll(reg3, "Z");
        exp = exp.replaceAll(reg4, "Z");
        Pattern p = Pattern.compile(aggregateRegExp);
        Matcher m = p.matcher(exp);
        boolean agg = m.matches();
        p = Pattern.compile(columnRegExp);
        m = p.matcher(exp);
        return agg || m.matches();
    }

    public static int convertDimensionType(DimensionType value, float parent, float dpi) {
        float INCH_PX = dpi;
        float PX_PT = 72.0f / INCH_PX;
        if (value == null) {
            return (int)parent;
        }
        if ("%".equals(value.getUnits())) {
            return (int)(value.getMeasure() / 100.0 * (double)parent);
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return (int)(value.getMeasure() * (double)PX_PT * 1000.0);
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return (int)(value.getMeasure() * 12.0 * 1000.0);
        }
        return (int)(value.convertTo("pt") * 1000.0);
    }

    public static float convertTextIndentToEM(FloatValue indent, float fontSize) {
        if (indent == null || indent.getFloatValue() == 0.0f) {
            return 0.0f;
        }
        DimensionType size = DimensionType.parserUnit(indent.getCssText());
        try {
            float indentInPt = (float)ExcelUtil.convertDimensionType(size, 0.0f, 96.0f) / 1000.0f;
            if (indentInPt != 0.0f) {
                return indentInPt / fontSize;
            }
        }
        catch (Exception exception) {}
        return 0.0f;
    }

    public static String parse(Object txt, String dateTime, ULocale locale) {
        if (dateTime == null) {
            DateFormatter format = new DateFormatter(locale);
            if (txt instanceof Date) {
                format.applyPattern("DateUnformatted");
            } else if (txt instanceof Time) {
                format.applyPattern("TimeUnformatted");
            } else {
                format.applyPattern("DateTimeUnformatted");
            }
            dateTime = ExcelUtil.updateFormat(format.getLocalizedFormatCode());
        }
        if (dateTime.indexOf("Date") != -1 || dateTime.indexOf("Time") != -1) {
            DateFormatter dateFormatter = new DateFormatter(dateTime, locale);
            dateTime = ExcelUtil.updateFormat(dateFormatter.getLocalizedFormatCode());
        }
        StringBuffer buffer = new StringBuffer();
        boolean inQuto = false;
        int eCount = 0;
        int count = 0;
        while (count < dateTime.length()) {
            char tempChar = dateTime.charAt(count);
            if (inQuto) {
                if (tempChar == '\'' && ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else if (tempChar == '\'') {
                    inQuto = false;
                } else if (specialStr.indexOf(tempChar) != -1) {
                    buffer.append("\\" + tempChar);
                } else {
                    buffer.append(tempChar);
                }
            } else if (tempChar == '\'') {
                eCount = 0;
                if (ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else {
                    inQuto = true;
                }
            } else if ("Ee".indexOf(tempChar) != -1) {
                if (++eCount == 3) {
                    buffer.append("ddd");
                }
                if (eCount >= 4) {
                    buffer.append("d");
                }
            } else {
                eCount = 0;
                if (tempChar == 'a') {
                    buffer.append("AM/PM");
                } else if ("zZFWwG".indexOf(tempChar) == -1) {
                    if ("kK".indexOf(tempChar) != -1) {
                        buffer.append("h");
                    } else {
                        buffer.append(tempChar);
                    }
                }
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String updateFormat(String dateTime) {
        if (dateTime.indexOf(121) == dateTime.lastIndexOf(121)) {
            dateTime = dateTime.replace("y", "yyyy");
        }
        return dateTime;
    }

    public static String formatNumberPattern(String givenValue) {
        return ExcelUtil.formatNumberPattern(givenValue, ULocale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatNumberPattern(String givenValue, ULocale locale) {
        if (givenValue == null) {
            return "";
        }
        String key = String.valueOf(givenValue) + "-" + locale;
        String format = formatCache.get(key);
        if (format == null) {
            format = ExcelUtil.localizePattern(givenValue, locale);
            Map<String, String> map = formatCache;
            synchronized (map) {
                formatCache.put(key, format);
            }
        }
        return format;
    }

    private static String localizePattern(String givenValue, ULocale locale) {
        if (givenValue.length() == 1) {
            char ch = givenValue.charAt(0);
            switch (ch) {
                case 'D': 
                case 'G': 
                case 'd': 
                case 'g': {
                    return "###,##0.###";
                }
                case 'C': 
                case 'c': {
                    return String.valueOf(ExcelUtil.getCurrencySymbol(locale)) + "###,##0.00";
                }
                case 'F': 
                case 'f': {
                    return "#0.00";
                }
                case 'N': 
                case 'n': {
                    return "###,##0.00";
                }
                case 'P': 
                case 'p': {
                    return "###,##0.00 %";
                }
                case 'E': 
                case 'e': {
                    return "0.000000E00";
                }
                case 'X': 
                case 'x': {
                    return "####";
                }
            }
        }
        if (namedPatterns.containsKey(givenValue)) {
            return namedPatterns.get(givenValue);
        }
        if (ExcelUtil.validType(givenValue)) {
            return givenValue;
        }
        if (ExcelUtil.isScientific(givenValue)) {
            givenValue = givenValue.replace("E", "E+");
            return givenValue;
        }
        int count = givenValue.length();
        StringBuffer returnStr = new StringBuffer();
        boolean flag = false;
        int num = 0;
        while (num < count) {
            char temp = givenValue.charAt(num);
            if (temp == '\'') {
                if (flag) {
                    flag = false;
                } else {
                    char nextChar = givenValue.charAt(num + 1);
                    if (nextChar == '\'') {
                        returnStr.append('\'');
                        ++num;
                        flag = false;
                    } else {
                        flag = true;
                    }
                }
            } else if (flag) {
                returnStr.append("\\").append(temp);
            } else if (specialStr.indexOf(temp) != -1) {
                returnStr.append("\\").append(temp);
            } else if (temp == '\u00a4') {
                String symbol = ExcelUtil.getCurrencySymbol(locale);
                returnStr.append(symbol);
            } else if (temp == '\u2030') {
                returnStr.append('%');
            } else if (currencySymbol.indexOf(temp) != -1) {
                returnStr.append(temp);
            } else {
                returnStr.append(temp);
            }
            ++num;
        }
        if (returnStr.indexOf("#") == -1 && returnStr.indexOf("0") == -1) {
            returnStr.append("#");
        }
        return returnStr.toString();
    }

    private static boolean isScientific(String givenValue) {
        Matcher matcher = pattern.matcher(givenValue);
        return matcher.matches();
    }

    private static String getCurrencySymbol(ULocale locale) {
        NumberFormat format = NumberFormat.getCurrencyInstance((ULocale)locale);
        Currency currency = format.getCurrency();
        if (currency != null) {
            String symbol = currency.getSymbol(locale);
            if (symbol.equals("EUR")) {
                symbol = "\u20ac";
            } else if (symbol.equals("GBP")) {
                symbol = "\u00a3";
            } else if (symbol.equals("XXX")) {
                symbol = "\u00a4";
            }
            return symbol;
        }
        return "$";
    }

    protected static boolean validType(String str) {
        int count = 0;
        while (count < str.length()) {
            char ch = str.charAt(count);
            if (validStr.indexOf(ch) == -1) {
                return false;
            }
            ++count;
        }
        return true;
    }

    private static boolean nextIsQuto(String forPar, int index) {
        if (forPar.length() - 1 == index) {
            return false;
        }
        return forPar.charAt(index + 1) == '\'';
    }

    public static boolean equalsIgnoreCase(String obj1, String obj2) {
        return obj1 == null ? obj2 == null : obj1.equalsIgnoreCase(obj2);
    }

    public static String getDay(java.util.Date d, TimeZone zone) {
        long currentTimeInMillis;
        int dayComponent;
        Calendar currentDay = Calendar.getInstance((TimeZone)zone);
        currentDay.setTime(d);
        int hours = currentDay.get(11);
        int minutes = currentDay.get(12);
        int seconds = currentDay.get(13);
        double timeComponent = ((double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds) / 86400.0;
        if (timeComponent < 0.0 || timeComponent > 1.0) {
            logger.log(Level.WARNING, "Invalid time!");
            timeComponent = 0.0;
        }
        if ((dayComponent = (int)(((currentTimeInMillis = currentDay.getTimeInMillis()) - BASE_DATE_TIME) / 86400000L)) < 0 || dayComponent > 2958463) {
            logger.log(Level.WARNING, "Invaild day");
            dayComponent = 0;
        }
        dayComponent = dayComponent <= 59 ? ++dayComponent : (dayComponent += 2);
        double dateTime = (double)dayComponent + timeComponent;
        return Double.toString(dateTime);
    }

    public static String convertColor(String value) {
        if (value == null || "transparent".equalsIgnoreCase(value) || "null".equalsIgnoreCase(value)) {
            return null;
        }
        return value.replace("#", "FF");
    }

    public static String covertBorderStyle(String style) {
        if (style == null) {
            return null;
        }
        if (style.equalsIgnoreCase("Dot")) {
            return "dotted";
        }
        if (style.equalsIgnoreCase("DashDot")) {
            return "dashDot";
        }
        if (style.equalsIgnoreCase("Double")) {
            return "double";
        }
        if (style.equalsIgnoreCase("Continuous")) {
            return "thin";
        }
        return null;
    }

    public static String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = Character.valueOf(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public static String getRef(int row, int column) {
        return ExcelUtil.getCellId(row, ExcelUtil.getColumnId(column));
    }

    public static String getCellId(int row, String columnId) {
        String cellId = columnId;
        if (row >= 0) {
            cellId = String.valueOf(columnId) + row;
        }
        return cellId;
    }

    public static String getColumnId(int column) {
        Stack<Character> digits = new Stack<Character>();
        int dividant = column;
        while (dividant > 26) {
            int remain = dividant % 26;
            dividant /= 26;
            if (remain == 0) {
                remain = 26;
                --dividant;
            }
            digits.push(Character.valueOf((char)(65 + remain - 1)));
        }
        digits.push(Character.valueOf((char)(65 + dividant - 1)));
        StringBuffer buffer = new StringBuffer();
        while (!digits.empty()) {
            buffer.append(digits.pop());
        }
        String columnId = buffer.toString();
        return columnId;
    }

    public static String convertStringFormat(String property) {
        if (property == null) {
            return null;
        }
        if (ZIP.equals(property)) {
            return ZIP_CODE;
        }
        if (PHONE.equals(property)) {
            return PHONE_CODE;
        }
        if (SOCIAL.equals(property)) {
            return SOCIALNUMBER_CODE;
        }
        return property;
    }

    public static String convertSciFormat(String code) {
        if (code == null) {
            return null;
        }
        int index = code.indexOf(69);
        if (index != -1) {
            return String.valueOf(code.substring(0, index - 1)) + "E" + "+" + code.substring(index + 1);
        }
        return code;
    }

    public static boolean isNaN(Object number) {
        if (number == null) {
            return false;
        }
        try {
            return Double.isNaN((Double)number);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String format(Object value, int dataType) {
        if (value == null) {
            return "";
        }
        if (dataType == 0) {
            return ExcelUtil.formatDate(value);
        }
        if (dataType == 1) {
            Number number = (Number)value;
            if (ExcelUtil.isBigNumber(number)) {
                return ExcelUtil.formatNumberAsScienceNotation(number);
            }
            if (number.toString().length() > 31) {
                if (ExcelUtil.displayedAsScientific(number)) {
                    return ExcelUtil.formatNumberAsScienceNotation(number);
                }
                return ExcelUtil.formatNumberAsDecimal(number);
            }
        }
        return value.toString();
    }

    public static String getValidSheetName(String name) {
        if ((name = name.replaceAll("[\\\\/?*:\\[\\] ]", "_")).length() > 31) {
            logger.log(Level.WARNING, "The sheetName " + name + " is too long for output.");
            name = name.substring(0, 31);
        }
        return name;
    }

    public static int getPageSizeIndex(int pageWidth, int pageHeight) {
        if ((double)pageHeight == 612.0 && (float)pageWidth == 792.0f) {
            return 1;
        }
        if ((float)pageHeight == 792.0f && (float)pageWidth == 1224.0f) {
            return 3;
        }
        if ((double)pageHeight == 612.0 && (float)pageWidth == 1008.0f) {
            return 5;
        }
        if ((double)pageHeight == 396.0 && (double)pageWidth == 612.0) {
            return 6;
        }
        if ((double)pageHeight == 522.0 && (double)pageWidth == 756.0) {
            return 7;
        }
        if ((double)pageHeight == 822.0472440944882 && (double)pageWidth == 1190.551181102362) {
            return 8;
        }
        if ((double)pageHeight == 595.275590551181 && (double)pageWidth == 822.0472440944882) {
            return 9;
        }
        if ((double)pageHeight == 396.8503937007874 && (double)pageWidth == 595.275590551181) {
            return 11;
        }
        if ((double)pageHeight == 708.6614173228346 && (double)pageWidth == 992.1259842519685) {
            return 12;
        }
        if ((double)pageHeight == 481.8897637795275 && (double)pageWidth == 708.6614173228346) {
            return 13;
        }
        if ((double)pageHeight == 612.0 && (float)pageWidth == 936.0f) {
            return 14;
        }
        if ((double)pageHeight == 297.0 && (double)pageWidth == 684.0) {
            return 20;
        }
        if ((double)pageHeight == 311.81102362204723 && (double)pageWidth == 623.6220472440945) {
            return 27;
        }
        if ((double)pageHeight == 453.54330708661416 && (double)pageWidth == 623.6220472440945) {
            return 28;
        }
        if ((double)pageHeight == 481.8897637795275 && (double)pageWidth == 708.6614173228346) {
            return 34;
        }
        if ((double)pageHeight == 279.0 && (double)pageWidth == 540.0) {
            return 37;
        }
        if ((double)pageHeight == 708.6614173228346 && (double)pageWidth == 992.1259842519685) {
            return 42;
        }
        return 9;
    }

    public static String truncateCellText(String txt) {
        if (txt.length() > Short.MAX_VALUE) {
            txt = txt.substring(0, Short.MAX_VALUE);
            logger.log(Level.WARNING, "The text length should not exceed 32767 characters!");
        }
        return txt;
    }

    public static SheetData getRealData(SheetData data) {
        while (data != null && data.isBlank()) {
            data = ((BlankData)data).getData();
        }
        return data;
    }
}

