/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.TOCHandler;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.internal.util.BundleVersionUtil;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFPageDevice
implements IPageDevice {
    private Document doc = null;
    private PdfWriter writer = null;
    private IReportContext context;
    private IReportContent report;
    private static Logger logger = Logger.getLogger(PDFPageDevice.class.getName());
    private PDFPage currentPage = null;
    private HashMap<Float, PdfTemplate> templateMap = new HashMap();
    private HashMap<String, PdfTemplate> imageCache = new HashMap();
    private static String[] versionInfo = new String[]{BundleVersionUtil.getBundleVersion("org.eclipse.birt.report.engine"), BundleVersionUtil.getBundleVersion("com.lowagie.itext")};
    static final int MAX_PAGE_WIDTH = 14400000;
    static final int MAX_PAGE_HEIGHT = 14400000;

    public PDFPageDevice(OutputStream output, String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        this.context = context;
        this.report = report;
        this.doc = new Document();
        try {
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
            this.writer.setFullCompression();
            this.writer.setRgbTransparencyBlending(true);
            EngineResourceHandle handle = new EngineResourceHandle(ULocale.forLocale((Locale)context.getLocale()));
            String creator = handle.getMessage("PDFCreator", versionInfo);
            this.doc.addCreator(creator);
            if (author != null) {
                this.doc.addAuthor(author);
            }
            if (title != null) {
                this.doc.addTitle(title);
            }
            if (subject != null) {
                this.doc.addSubject(subject);
                this.doc.addKeywords(subject);
            }
            if (description != null) {
                this.doc.addHeader("Description", description);
            }
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    public PDFPageDevice(OutputStream output) {
        this.doc = new Document();
        try {
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    public void setPDFTemplate(Float scale, PdfTemplate totalPageTemplate) {
        this.templateMap.put(scale, totalPageTemplate);
    }

    public HashMap<Float, PdfTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public PdfTemplate getPDFTemplate(Float scale) {
        return this.templateMap.get(scale);
    }

    public boolean hasTemplate(Float scale) {
        return this.templateMap.containsKey(scale);
    }

    public HashMap<String, PdfTemplate> getImageCache() {
        return this.imageCache;
    }

    @Override
    public void close() throws Exception {
        this.writer.setPageEmpty(false);
        if (this.doc.isOpen()) {
            this.doc.close();
        }
    }

    @Override
    public IPage newPage(int width, int height, Color backgroundColor) {
        int w = Math.min(width, 14400000);
        int h = Math.min(height, 14400000);
        this.currentPage = new PDFPage(w, h, this.doc, this.writer, this);
        this.currentPage.drawBackgroundColor(backgroundColor, 0, 0, w, h);
        return this.currentPage;
    }

    public void createTOC(Set bookmarks) {
        if (bookmarks.isEmpty()) {
            this.writer.setViewerPreferences(64);
            return;
        }
        ULocale ulocale = null;
        Locale locale = this.context.getLocale();
        ulocale = locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)locale);
        ITOCTree tocTree = this.report.getTOCTree("pdf", ulocale);
        if (tocTree == null) {
            this.writer.setViewerPreferences(64);
        } else {
            TOCNode rootNode = tocTree.getRoot();
            if (rootNode == null || rootNode.getChildren().isEmpty()) {
                this.writer.setViewerPreferences(64);
            } else {
                this.writer.setViewerPreferences(128);
                TOCHandler tocHandler = new TOCHandler(rootNode, this.writer.getDirectContent().getRootOutline(), bookmarks);
                tocHandler.createTOC();
            }
        }
    }
}

