/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EncryptedPropertyState
extends PropertyState {
    protected String encryptionID = null;

    EncryptedPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    EncryptedPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        this.encryptionID = attrs.getValue("encryptionID");
    }

    public void end() throws SAXException {
        DesignParserException e;
        String value = this.text.toString();
        PropertyDefn propDefn = null;
        if (this.struct != null) {
            StructureDefn structDefn = (StructureDefn)this.struct.getDefn();
            assert (structDefn != null);
            propDefn = (StructPropertyDefn)structDefn.getMember(this.name);
        } else {
            propDefn = this.element.getPropertyDefn(this.name);
        }
        if (propDefn == null) {
            e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        if (!EncryptionUtil.canEncrypt(propDefn)) {
            e = new DesignParserException(new String[]{propDefn.getName()}, "Error.DesignParserException.PROPERTY_IS_NOT_ENCRYPTABLE");
            this.handler.getErrorHandler().semanticError(e);
            this.valid = false;
            return;
        }
        String valueToSet = StringUtil.trimString(value);
        if (valueToSet == null) {
            return;
        }
        if (this.handler.versionNumber < 3021500) {
            IEncryptionHelper helper = null;
            String encryption = null;
            if (this.struct != null) {
                helper = SimpleEncryptionHelper.getInstance();
            } else {
                encryption = this.encryptionID == null ? "base64" : this.encryptionID;
                helper = MetaDataDictionary.getInstance().getEncryptionHelper(encryption);
            }
            if (helper != SimpleEncryptionHelper.getInstance()) {
                valueToSet = SimpleEncryptionHelper.getInstance().decrypt(valueToSet);
                String string = valueToSet = helper == null ? valueToSet : helper.encrypt(valueToSet);
                if (this.struct == null) {
                    this.element.setEncryptionHelper((ElementPropertyDefn)propDefn, encryption);
                }
            } else if (this.struct == null) {
                this.element.setEncryptionHelper((ElementPropertyDefn)propDefn, encryption);
            }
        }
        if (this.struct != null) {
            if (this.struct instanceof PropertyBinding) {
                PropertyBinding propBinding = (PropertyBinding)this.struct;
                propBinding.setEncryption(this.encryptionID);
            }
            this.doSetMember(this.struct, propDefn.getName(), (StructPropertyDefn)propDefn, this.convertToExpression(propDefn, valueToSet));
            return;
        }
        if (this.encryptionID != null) {
            this.element.setEncryptionHelper(this.name, this.encryptionID);
        }
        this.doSetProperty(propDefn, this.convertToExpression(propDefn, valueToSet));
    }

    private Object convertToExpression(PropertyDefn defn, String valueToSet) {
        if (defn.allowExpression()) {
            return new Expression(valueToSet, "constant");
        }
        return valueToSet;
    }
}

