/**
 * <copyright>
 * </copyright>
 *
 * $Id: BigNumberDataElementImpl.java,v 1.1 2010/08/02 02:03:29 ywang1 Exp $
 */

package org.eclipse.birt.chart.model.data.impl;

import java.math.BigDecimal;

import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Big Number Data Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.birt.chart.model.data.impl.BigNumberDataElementImpl#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BigNumberDataElementImpl extends DataElementImpl implements
		BigNumberDataElement
{

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final BigDecimal VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected BigDecimal value = VALUE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BigNumberDataElementImpl( )
	{
		super( );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass( )
	{
		return DataPackage.Literals.BIG_NUMBER_DATA_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BigDecimal getValue( )
	{
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue( BigDecimal newValue )
	{
		BigDecimal oldValue = value;
		value = newValue;
		if ( eNotificationRequired( ) )
			eNotify( new ENotificationImpl( this,
					Notification.SET,
					DataPackage.BIG_NUMBER_DATA_ELEMENT__VALUE,
					oldValue,
					value ) );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet( int featureID, boolean resolve, boolean coreType )
	{
		switch ( featureID )
		{
			case DataPackage.BIG_NUMBER_DATA_ELEMENT__VALUE :
				return getValue( );
		}
		return super.eGet( featureID, resolve, coreType );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet( int featureID, Object newValue )
	{
		switch ( featureID )
		{
			case DataPackage.BIG_NUMBER_DATA_ELEMENT__VALUE :
				setValue( (BigDecimal) newValue );
				return;
		}
		super.eSet( featureID, newValue );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset( int featureID )
	{
		switch ( featureID )
		{
			case DataPackage.BIG_NUMBER_DATA_ELEMENT__VALUE :
				setValue( VALUE_EDEFAULT );
				return;
		}
		super.eUnset( featureID );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet( int featureID )
	{
		switch ( featureID )
		{
			case DataPackage.BIG_NUMBER_DATA_ELEMENT__VALUE :
				return VALUE_EDEFAULT == null ? value != null
						: !VALUE_EDEFAULT.equals( value );
		}
		return super.eIsSet( featureID );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString( )
	{
		if ( eIsProxy( ) )
			return super.toString( );

		StringBuffer result = new StringBuffer( super.toString( ) );
		result.append( " (value: " ); //$NON-NLS-1$
		result.append( value );
		result.append( ')' );
		return result.toString( );
	}

	/**
	 * @generated
	 */
	protected void set( BigNumberDataElement src )
	{

		super.set( src );

		// attributes

		value = src.getValue( );

	}

	/**
	 * @generated
	 */
	public BigNumberDataElement copyInstance( )
	{
		BigNumberDataElementImpl dest = new BigNumberDataElementImpl( );
		dest.set( this );
		return dest;
	}
	
	public static BigNumberDataElement create(BigDecimal value)
	{
		BigNumberDataElementImpl dest = new BigNumberDataElementImpl( );
		dest.value = value;
		return dest;
	}

} //BigNumberDataElementImpl
