/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.internal.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.dialogs.BirtConfigurationDialog;
import org.eclipse.birt.integration.wtp.ui.internal.resource.BirtWTPMessages;
import org.eclipse.birt.integration.wtp.ui.internal.util.Logger;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.birt.integration.wtp.ui.project.facet.BirtFacetUtilFactory;
import org.eclipse.birt.integration.wtp.ui.project.facet.IBirtFacetUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ImportBirtRuntimeAction
extends Action
implements IWorkbenchWindowActionDelegate,
IBirtWizardConstants {
    private IStructuredSelection fSelection = null;
    private IProject project = null;
    private Map properties = new HashMap();

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean bEnable = false;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            bEnable = this.validateSelected((ISelection)this.fSelection);
        }
        ((Action)action).setEnabled(bEnable);
    }

    protected boolean isValidProject(IProject fProject) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)fProject);
    }

    protected boolean validateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        this.fSelection = (IStructuredSelection)selection;
        Object selectedProject = this.fSelection.getFirstElement();
        if (selectedProject instanceof IJavaProject) {
            selectedProject = ((IJavaProject)selectedProject).getProject();
        }
        if (!(selectedProject instanceof IProject)) {
            return false;
        }
        this.project = (IProject)selectedProject;
        return this.isValidProject(this.project);
    }

    public void dispose() {
    }

    public void run(IAction action) {
        try {
            BirtWizardUtil.initWebapp(this.properties);
            IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this.project);
            IBirtFacetUtil util = BirtFacetUtilFactory.getInstance(modelProvider.getModelObject());
            util.initializeWebapp(this.properties, this.project);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            BirtConfigurationDialog dialog = new BirtConfigurationDialog(window.getShell(), (Map)this.properties.get("context-param"));
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                return;
            }
            this.doImport(window, dialog.isClear());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected void doClearAction(IPath webContentPath, IProgressMonitor monitor) throws Exception {
        IPath webPath = webContentPath;
        if (webPath.segmentCount() > 0) {
            webPath = webPath.removeFirstSegments(1);
        }
        Map map = BirtWizardUtil.initConflictResources(null);
        for (Map.Entry entry : map.entrySet()) {
            IPath path;
            IFolder tempFolder;
            String folder = (String)entry.getKey();
            if (folder == null || (tempFolder = this.project.getFolder(path = webPath.append(folder))) == null || !tempFolder.exists()) continue;
            List files = (List)entry.getValue();
            if (files == null || files.size() <= 0) {
                tempFolder.delete(true, monitor);
                continue;
            }
            tempFolder.accept((IResourceVisitor)new LibResourceVisitor(monitor, files), 2, false);
        }
    }

    protected void doImport(IWorkbenchWindow window, boolean isClear) throws Exception {
        ProgressMonitorDialog monitor = null;
        try {
            IPath webContentPath = BirtWizardUtil.getWebContentPath(this.project);
            monitor = new ProgressMonitorDialog(window.getShell());
            monitor.open();
            if (isClear) {
                this.doClearAction(webContentPath, monitor.getProgressMonitor());
            }
            BirtWizardUtil.doImports(this.project, null, webContentPath, monitor.getProgressMonitor(), new ImportOverwriteQuery(monitor.getShell()));
            BirtWizardUtil.processCheckFolder(this.properties, this.project, webContentPath.toFile().getName(), monitor.getProgressMonitor());
            this.processConfiguration(monitor.getProgressMonitor(), monitor.getShell());
        }
        finally {
            if (monitor != null) {
                monitor.close();
            }
        }
    }

    protected void processConfiguration(final IProgressMonitor monitor, Shell shell) throws CoreException {
        final SimpleImportOverwriteQuery query = new SimpleImportOverwriteQuery();
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this.project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = this.project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (BirtFacetUtilFactory.isWebApp25(modelProvider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        final IBirtFacetUtil util = BirtFacetUtilFactory.getInstance(modelProvider.getModelObject());
        modelProvider.modify(new Runnable(){

            public void run() {
                util.configureWebApp((WebAppBean)ImportBirtRuntimeAction.this.properties.get("webapp"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureContextParam((Map)ImportBirtRuntimeAction.this.properties.get("context-param"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureListener((Map)ImportBirtRuntimeAction.this.properties.get("listener"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureServlet((Map)ImportBirtRuntimeAction.this.properties.get("servlet"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureServletMapping((Map)ImportBirtRuntimeAction.this.properties.get("servlet-mapping"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureFilter((Map)ImportBirtRuntimeAction.this.properties.get("filter"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureFilterMapping((Map)ImportBirtRuntimeAction.this.properties.get("filter-mapping"), ImportBirtRuntimeAction.this.project, query, monitor);
                util.configureTaglib((Map)ImportBirtRuntimeAction.this.properties.get("taglib"), ImportBirtRuntimeAction.this.project, query, monitor);
            }
        }, modelPath);
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        private boolean isALL = false;
        private Shell shell;

        public ImportOverwriteQuery(Shell shell) {
            this.shell = shell;
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            this.shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String title = BirtWTPMessages.BIRTOverwriteQuery_title;
                    String msg = NLS.bind((String)BirtWTPMessages.BIRTOverwriteQuery_message, (Object)file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ImportOverwriteQuery.this.shell, title, null, msg, 3, options, 0);
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }

        public String queryOverwrite(String file) {
            if (this.isALL) {
                return "ALL";
            }
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            String result = returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
            this.isALL = result.equalsIgnoreCase("ALL");
            return result;
        }
    }

    private static class LibResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private List files;

        public LibResourceVisitor(IProgressMonitor monitor, List files) {
            this.monitor = monitor;
            this.files = files;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (this.files == null) {
                    return true;
                }
                for (String name : this.files) {
                    if (name == null || !file.getName().startsWith(name)) continue;
                    file.delete(true, this.monitor);
                    break;
                }
            }
            return true;
        }
    }
}

