/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;

public abstract class DesignElementDragAdapter
extends DragSourceAdapter {
    private StructuredViewer viewer;
    protected List selectionList = new ArrayList();

    public DesignElementDragAdapter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit) {
            TemplateTransfer.getInstance().setTemplate(null);
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Drag finished.");
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        Object[] objects = this.selectionList.toArray();
        if (TemplateTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = objects;
        }
    }

    public void dragStart(DragSourceEvent event) {
        boolean doit;
        boolean bl = doit = !this.getViewer().getSelection().isEmpty();
        if (doit) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            this.selectionList = selection.toList();
            Object[] objects = selection.toList().toArray();
            if (this.validateType(objects)) {
                int i = 0;
                while (i < objects.length) {
                    if (!this.validateTransfer(objects[i])) {
                        doit = false;
                        break;
                    }
                    ++i;
                }
            } else {
                doit = false;
            }
            if (doit) {
                TemplateTransfer.getInstance().setTemplate((Object)objects);
            }
        }
        event.doit = doit;
        if (Policy.TRACING_DND_DRAG && doit) {
            System.out.println("DND >> Drag starts.");
        }
    }

    protected abstract boolean validateTransfer(Object var1);

    protected boolean validateType(Object transfer) {
        Object[] objects = (Object[])transfer;
        if (objects.length <= 0) {
            return false;
        }
        if (objects[0] instanceof ThemeHandle) {
            return objects.length == 1;
        }
        Class<?> type = null;
        int i = 0;
        while (i < objects.length) {
            if (type == null) {
                type = objects[i].getClass();
            } else if (!type.equals(objects[i].getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }
}

