/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers.embedded;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class EmbeddedBrowser {
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    private Preferences store;
    private static String initialTitle = EmbeddedBrowser.getWindowTitle();
    private Shell shell;
    private Browser browser;
    private int x;
    private int y;
    private int w;
    private int h;
    private long modalRequestTime = 0L;

    public EmbeddedBrowser() {
        this.store = ViewerPlugin.getDefault().getPluginPreferences();
        this.shell = new Shell(0x4F0 | Window.getDefaultOrientation());
        EmbeddedBrowser.initializeShell(this.shell);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedBrowser.this.browser.close();
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_X, Integer.toString(EmbeddedBrowser.this.x));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_Y, Integer.toString(EmbeddedBrowser.this.y));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_WIDTH, Integer.toString(EmbeddedBrowser.this.w));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_HEIGTH, Integer.toString(EmbeddedBrowser.this.h));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_MAXIMIZED, Boolean.valueOf(EmbeddedBrowser.this.shell.getMaximized()).toString());
            }
        });
        this.browser = "linux".equalsIgnoreCase(Platform.getOS()) ? new Browser((Composite)this.shell, 32768) : new Browser((Composite)this.shell, 0);
        this.initialize(this.shell.getDisplay(), this.browser);
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 1024;
            this.h = 768;
            this.x = this.shell.getLocation().x;
            this.y = this.shell.getLocation().y;
        }
        EmbeddedBrowser.setSafeBounds(this.shell, this.x, this.y, this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.open();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    public EmbeddedBrowser(WindowEvent event, Shell parent) {
        this.shell = parent == null ? new Shell(0x4F0 | Window.getDefaultOrientation()) : new Shell(parent, 34912);
        EmbeddedBrowser.initializeShell(this.shell);
        Browser browser = null;
        browser = "linux".equalsIgnoreCase(Platform.getOS()) ? new Browser((Composite)this.shell, 32768) : new Browser((Composite)this.shell, 0);
        this.initialize(this.shell.getDisplay(), browser);
        event.browser = browser;
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    private static void initializeShell(Shell s) {
        Image[] shellImages = EmbeddedBrowser.createImages();
        if (shellImages != null) {
            s.setImages(shellImages);
        }
        s.setLayout((Layout)new FillLayout());
    }

    private void initialize(Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (System.currentTimeMillis() - EmbeddedBrowser.this.modalRequestTime <= 1000L) {
                    new EmbeddedBrowser(event, EmbeddedBrowser.this.shell);
                } else {
                    new EmbeddedBrowser(event, null);
                }
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (event.title != null && event.title.length() > 0) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.setText(event.title);
                }
            }
        });
    }

    public void displayUrl(String url) {
        this.browser.setUrl(url);
        this.shell.setMinimized(false);
        this.shell.forceActive();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private static String getWindowTitle() {
        return ViewerPlugin.getResourceString("viewer.browserTitle");
    }

    private static Image[] createImages() {
        String[] productImageURLs = EmbeddedBrowser.getProductImageURLs();
        if (productImageURLs != null) {
            ArrayList<Image> shellImgs = new ArrayList<Image>();
            int i = 0;
            while (i < productImageURLs.length) {
                if (!"".equals(productImageURLs[i])) {
                    URL imageURL;
                    block9: {
                        imageURL = null;
                        try {
                            imageURL = new URL(productImageURLs[i]);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Bundle productBundle;
                            IProduct product = Platform.getProduct();
                            if (product == null || (productBundle = product.getDefiningBundle()) == null) break block9;
                            imageURL = Platform.find((Bundle)productBundle, (IPath)new Path(productImageURLs[i]));
                        }
                    }
                    Image image = null;
                    if (imageURL != null) {
                        String key = imageURL.toString();
                        if (CorePlugin.getDefault().getImageRegistry().get(key) != null) {
                            image = CorePlugin.getDefault().getImageRegistry().get(key);
                        } else {
                            image = ImageDescriptor.createFromURL((URL)imageURL).createImage();
                            CorePlugin.getDefault().getImageRegistry().put(key, image);
                        }
                    }
                    if (image != null) {
                        shellImgs.add(image);
                    }
                }
                ++i;
            }
            return shellImgs.toArray(new Image[shellImgs.size()]);
        }
        return new Image[0];
    }

    private static String[] getProductImageURLs() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String url = product.getProperty("windowImages");
            if (url != null && url.length() > 0) {
                return url.split(",\\s*");
            }
            url = product.getProperty("windowImage");
            if (url != null && url.length() > 0) {
                return new String[]{url};
            }
        }
        return null;
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private static void setSafeBounds(Shell s, int x, int y, int width, int height) {
        Rectangle clientArea = s.getDisplay().getClientArea();
        width = Math.min(clientArea.width, width);
        height = Math.min(clientArea.height, height);
        x = Math.min(x + width, clientArea.x + clientArea.width) - width;
        y = Math.min(y + height, clientArea.y + clientArea.height) - height;
        x = Math.max(x, clientArea.x);
        y = Math.max(y, clientArea.y);
        s.setBounds(x, y, width, height);
    }

    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(this.w, this.h);
    }
}

