/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalAve
extends AggrFunction {
    public String getName() {
        return "AVE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    public String getDescription() {
        return Messages.getString("TotalAve.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalAve.displayName");
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Number sum = null;
        private int count = 0;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.sum = null;
            this.count = 0;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                this.sum = this.calculator.add(this.sum, this.calculator.getTypedObject(args[0]));
                ++this.count;
            }
        }

        @Override
        public Object getSummaryValue() throws DataException {
            if (this.count > 0) {
                return this.calculator.divide(this.sum, this.calculator.getTypedObject(this.count));
            }
            return null;
        }
    }
}

