/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb;

import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb.SQLQueryUtility;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderStorageEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLBuilderEditorInputUtil;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SQLBuilderDesignState {
    private static final String SQB_STATE_CURRENT_VERSION = "1.0";
    private static final String EMPTY_STRING = "";
    private SQLBuilderStorageEditorInput m_sqbInput;
    private String m_preparableSQLText;
    private String m_version;

    SQLBuilderDesignState(String sqbInputName, SQLBuilder sqlBuilder) {
        this.m_sqbInput = SQLBuilderDesignState.createSQBInput(sqbInputName, sqlBuilder);
        this.m_preparableSQLText = SQLQueryUtility.getPreparableSQL(sqlBuilder.getDomainModel().getSQLStatement());
    }

    SQLBuilderDesignState(DesignerState odaDesignerState) throws OdaException {
        if (odaDesignerState == null || odaDesignerState.getStateContent() == null) {
            throw new NullPointerException("SQLBuilderDesignState( DesignerState )");
        }
        this.m_version = odaDesignerState.getVersion();
        if (this.m_version == null || !this.m_version.equals(SQB_STATE_CURRENT_VERSION)) {
            throw new OdaException(Messages.sqbDesignState_invalidSqbStateVersion);
        }
        String designStateValue = odaDesignerState.getStateContent().getStateContentAsString();
        if (designStateValue == null) {
            return;
        }
        IMemento memento = SQLBuilderEditorInputUtil.readMementoFromString((String)designStateValue);
        DesignStateMemento.restoreState(memento, this);
    }

    private static SQLBuilderStorageEditorInput createSQBInput(String sqbInputName, SQLBuilder sqlBuilder) {
        SQLBuilderStorageEditorInput storageEditorInput = new SQLBuilderStorageEditorInput(sqbInputName, sqlBuilder.getSQL());
        storageEditorInput.setConnectionInfo(sqlBuilder.getConnectionInfo());
        storageEditorInput.setOmitSchemaInfo(sqlBuilder.getOmitSchemaInfo());
        storageEditorInput.setInputUsageOptions(sqlBuilder.getEditorInputUsageOptions());
        storageEditorInput.setWindowStateInfo(sqlBuilder.getWindowStateInfo());
        return storageEditorInput;
    }

    boolean hasSQBInput() {
        return this.m_sqbInput != null;
    }

    SQLBuilderStorageEditorInput getSQBStorageInput() {
        return this.m_sqbInput;
    }

    private void setSQBStorageInput(SQLBuilderStorageEditorInput sqbInput) {
        this.m_sqbInput = sqbInput;
    }

    String getPreparableSQL() {
        return this.m_preparableSQLText;
    }

    private void setPreparableSQL(String preparableSQLText) {
        this.m_preparableSQLText = preparableSQLText;
    }

    String getVersion() {
        if (this.m_version == null) {
            return SQB_STATE_CURRENT_VERSION;
        }
        return this.m_version;
    }

    public String toString() {
        if (this.m_sqbInput == null) {
            return EMPTY_STRING;
        }
        XMLMemento memento = DesignStateMemento.saveState(this);
        String sqbState = SQLBuilderEditorInputUtil.writeXMLMementoToString((XMLMemento)memento);
        return sqbState;
    }

    static class DesignStateMemento {
        static final String KEY_PREPARABLE_SQL_TEXT = "preparableSQLText";

        DesignStateMemento() {
        }

        static XMLMemento saveState(SQLBuilderDesignState sqbState) {
            SQLBuilderStorageEditorInput sqbInput = sqbState.getSQBStorageInput();
            XMLMemento memento = SQLBuilderEditorInputUtil.saveSQLBuilderStorageEditorInput((SQLBuilderStorageEditorInput)sqbInput);
            String queryText = sqbState.getPreparableSQL();
            if (queryText != null && !SQLQueryUtility.isEquivalentSQL(queryText, sqbInput.getSQL())) {
                memento.putString(KEY_PREPARABLE_SQL_TEXT, queryText);
            }
            return memento;
        }

        static void restoreState(IMemento memento, SQLBuilderDesignState sqbState) {
            sqbState.setSQBStorageInput(SQLBuilderEditorInputUtil.createSQLBuilderStorageEditorInput((IMemento)memento));
            String queryText = memento.getString(KEY_PREPARABLE_SQL_TEXT);
            sqbState.setPreparableSQL(queryText);
        }
    }
}

