/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.BorderPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BorderSection
extends Section {
    boolean isTabbed = false;
    private boolean showLabel = false;
    protected BorderPropertyDescriptor border;
    protected TabbedPropertyTitle title;
    int displayLabelStyle = 512;
    IDescriptorProvider styleProvider;
    IDescriptorProvider colorProvider;
    IDescriptorProvider widthProvider;
    BorderToggleDescriptorProvider[] toggleProviders;
    private int height = -1;
    private int width = -1;
    boolean fillBorder = false;
    private int style = -1;
    boolean withDialog = false;

    public BorderSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public BorderSection(String labelText, Composite parent, boolean isFormStyle, boolean isTabbed) {
        super(labelText, parent, isFormStyle);
        this.isTabbed = isTabbed;
    }

    public void showDisplayLabel(boolean show) {
        this.showLabel = show;
    }

    public void createSection() {
        if (this.isTabbed) {
            this.getTitleControl(this.parent);
        } else if (this.showLabel) {
            this.getLabelControl(this.parent);
        }
        this.getBorderControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public TabbedPropertyTitle getTitleControl() {
        return this.title;
    }

    protected TabbedPropertyTitle getTitleControl(Composite parent) {
        if (this.title == null) {
            this.title = new TabbedPropertyTitle(parent, FormWidgetFactory.getInstance());
            this.title.setLayoutData((Object)new GridData(768));
            this.title.setFont(parent.getFont());
            this.title.setLayoutData((Object)new GridData());
            String text = this.getLabelText();
            if (text != null) {
                this.title.setTitle(text, null);
            }
            this.title.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BorderSection.this.title = null;
                }
            });
        } else {
            this.checkParent((Control)this.title, parent);
        }
        return this.title;
    }

    public BorderPropertyDescriptor getBorderControl() {
        return this.border;
    }

    protected BorderPropertyDescriptor getBorderControl(Composite parent) {
        if (this.border == null) {
            this.border = DescriptorToolkit.createBorderPropertyDescriptor(true);
            if (this.style != -1) {
                this.border.setStyle(this.style);
            }
            if (this.getStyleProvider() != null) {
                this.border.setStyleProvider(this.getStyleProvider());
            }
            if (this.getColorProvider() != null) {
                this.border.setColorProvider(this.getColorProvider());
            }
            if (this.getWidthProvider() != null) {
                this.border.setWidthProvider(this.getWidthProvider());
            }
            if (this.getToggleProviders() != null) {
                this.border.setToggleProviders(this.getToggleProviders());
            }
            this.border.createControl(parent);
            this.border.getControl().setLayoutData((Object)new GridData());
            this.border.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BorderSection.this.border = null;
                }
            });
        } else {
            this.checkParent(this.border.getControl(), parent);
        }
        return this.border;
    }

    public void setDisplayLabelStyle(int style) {
        this.displayLabelStyle = style;
    }

    public void layout() {
        GridData gd = (GridData)this.border.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.displayLabel != null && (this.displayLabelStyle & 0x100) != 0) {
            --gd.horizontalSpan;
        }
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillBorder;
        }
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
        } else {
            gd.grabExcessVerticalSpace = this.fillBorder;
        }
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        if (this.displayLabel != null) {
            if ((this.displayLabelStyle & 0x200) != 0) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
            } else {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 1;
            }
        }
        if (this.title != null) {
            gd = (GridData)this.title.getLayoutData();
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
    }

    public void load() {
        if (this.border != null && !this.border.getControl().isDisposed()) {
            this.border.load();
        }
    }

    public void reset() {
        if (this.border != null && !this.border.getControl().isDisposed()) {
            this.border.reset();
        }
    }

    public IDescriptorProvider getStyleProvider() {
        return this.styleProvider;
    }

    public void setStyleProvider(IDescriptorProvider provider) {
        this.styleProvider = provider;
        if (this.border != null) {
            this.border.setStyleProvider(provider);
        }
    }

    public IDescriptorProvider getColorProvider() {
        return this.colorProvider;
    }

    public void setColorProvider(IDescriptorProvider provider) {
        this.colorProvider = provider;
        if (this.border != null) {
            this.border.setColorProvider(provider);
        }
    }

    public IDescriptorProvider getWidthProvider() {
        return this.widthProvider;
    }

    public void setWidthProvider(IDescriptorProvider provider) {
        this.widthProvider = provider;
        if (this.border != null) {
            this.border.setWidthProvider(provider);
        }
    }

    public BorderToggleDescriptorProvider[] getToggleProviders() {
        return this.toggleProviders;
    }

    public void setToggleProviders(BorderToggleDescriptorProvider[] toggleProviders) {
        this.toggleProviders = toggleProviders;
        if (this.border != null) {
            this.border.setToggleProviders(toggleProviders);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.border.setInput(input);
    }

    public boolean isFillBorder() {
        return this.fillBorder;
    }

    public void setFillBorder(boolean fillBorder) {
        this.fillBorder = fillBorder;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.title != null) {
            WidgetUtil.setExcludeGridData((Control)this.title, (boolean)isHidden);
        }
        if (this.border != null) {
            this.border.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.title != null) {
            this.title.setVisible(isVisible);
        }
        if (this.border != null) {
            this.border.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        if (this.border != null) {
            this.border.setStyle(style);
        }
    }

    public void setButtonWithDialog(boolean withDialog) {
        this.withDialog = withDialog;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

