/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.report.data.oda.i18n.JdbcResourceHandle;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.JndiDataSource;
import org.eclipse.birt.report.data.oda.jdbc.LogUtil;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;

public class JDBCDriverManager {
    private static final int MAX_WORD_LENGTH = 20;
    private static final int MAX_MSG_LENGTH = 300;
    public static final String JDBC_USER_PROP_NAME = "user";
    public static final String JDBC_PASSWORD_PROP_NAME = "password";
    private HashMap<String, Driver> registeredDrivers = new HashMap();
    private Hashtable<String, Driver> testedDrivers = new Hashtable();
    private Hashtable<String, Driver> cachedJdbcDrivers = new Hashtable();
    private HashMap driverExtensions = null;
    private boolean loadedDriver = false;
    private DriverClassLoader extraDriverLoader = null;
    private JdbcResourceHandle resourceHandle = new JdbcResourceHandle(ULocale.getDefault());
    private static JDBCDriverManager instance;
    private static Logger logger;

    static {
        logger = Logger.getLogger(JDBCDriverManager.class.getName());
    }

    private JDBCDriverManager() {
        logger.logp(Level.FINE, JDBCDriverManager.class.getName(), "JDBCDriverManager", "JDBCDriverManager starts up");
    }

    public static synchronized JDBCDriverManager getInstance() {
        if (instance == null) {
            instance = new JDBCDriverManager();
        }
        return instance;
    }

    public Driver getDriverInstance(Class driver, boolean refreshDriver) throws OdaException {
        String driverName = driver.getName();
        Driver drv = this.getDriverInstance(driverName);
        if (refreshDriver || drv == null) {
            WrappedDriver instance = null;
            try {
                instance = new WrappedDriver((Driver)driver.newInstance(), driverName);
            }
            catch (Exception e) {
                throw new OdaException((Throwable)e);
            }
            this.cachedJdbcDrivers.put(driverName, instance);
            return instance;
        }
        return drv;
    }

    private Driver getDriverInstance(String driverName) {
        return this.cachedJdbcDrivers.get(driverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.extraDriverLoader != null) {
            this.extraDriverLoader.close();
            this.extraDriverLoader = null;
        }
        HashMap<String, Driver> hashMap = this.registeredDrivers;
        synchronized (hashMap) {
            this.registeredDrivers.clear();
        }
        this.cachedJdbcDrivers.clear();
        this.testedDrivers.clear();
    }

    public Connection getConnection(String driverClass, String url, Properties connectionProperties, Collection<String> driverClassPath) throws SQLException, OdaException {
        this.validateConnectionProperties(driverClass, url, null);
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + LogUtil.encryptURL(url));
        }
        return this.doConnect(driverClass, url, null, connectionProperties, driverClassPath);
    }

    public Connection getConnection(String driverClass, String url, String user, String password, Collection<String> driverClassPath) throws SQLException, OdaException {
        return this.getConnection(driverClass, url, user, password, driverClassPath, null);
    }

    public Connection getConnection(String driverClass, String url, String user, String password, Collection<String> driverClassPath, Properties props) throws SQLException, OdaException {
        this.validateConnectionProperties(driverClass, url, null);
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + LogUtil.encryptURL(url) + "; user=" + (user == null ? "" : user));
        }
        props = JDBCDriverManager.addUserAuthenticationProperties(props, user, password);
        return this.doConnect(driverClass, url, null, props, driverClassPath);
    }

    public Connection getConnection(String driverClass, String url, String jndiNameUrl, Properties connectionProperties, Collection<String> driverClassPath) throws SQLException, OdaException {
        this.validateConnectionProperties(driverClass, url, jndiNameUrl);
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("Request JDBC Connection: driverClass=" + driverClass + "; url=" + LogUtil.encryptURL(url) + "; jndi name url=" + jndiNameUrl);
        }
        return this.doConnect(driverClass, url, jndiNameUrl, connectionProperties, driverClassPath);
    }

    private Connection doConnect(String driverClass, String url, String jndiNameUrl, Properties connectionProperties, Collection<String> driverClassPath) throws SQLException, OdaException {
        block12: {
            Connection jndiDSConnection = this.getJndiDSConnection(driverClass, jndiNameUrl, connectionProperties);
            if (jndiDSConnection != null) {
                return jndiDSConnection;
            }
            IConnectionFactory factory = this.getDriverConnectionFactory(driverClass);
            if (factory != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Calling IConnectionFactory.getConnection. driverClass=" + driverClass + ", url=" + LogUtil.encryptURL(url));
                }
                return factory.getConnection(driverClass, url, connectionProperties);
            }
            this.loadAndRegisterDriver(driverClass, driverClassPath);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Calling DriverManager.getConnection. url=" + LogUtil.encryptURL(url));
            }
            try {
                Driver driver = DriverManager.getDriver(url);
                if (driver != null) {
                    return driver.connect(url, connectionProperties);
                }
            }
            catch (SQLException e1) {
                if (!"28000".equals(e1.getSQLState())) break block12;
                throw e1;
            }
        }
        try {
            return DriverManager.getConnection(url, connectionProperties);
        }
        catch (SQLException e) {
            try {
                DriverClassLoader dl = new DriverClassLoader(driverClassPath, Thread.currentThread().getContextClassLoader());
                Class dc = dl.loadClass(driverClass);
                if (dc != null) {
                    return ((Driver)dc.newInstance()).connect(url, connectionProperties);
                }
                throw new JDBCException("odajdbc.GetConnectionError", null, this.truncate(e.getLocalizedMessage()));
            }
            catch (Exception exception) {
                throw new JDBCException("odajdbc.GetConnectionError", null, this.truncate(e.getLocalizedMessage()));
            }
        }
    }

    private String truncate(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > 300) {
            int maxLength = 320;
            if (maxLength > message.length()) {
                maxLength = message.length();
            }
            boolean findBoundary = false;
            int i = 300;
            while (!findBoundary && i < maxLength) {
                char c = message.charAt(i);
                switch (c) {
                    case ' ': {
                        findBoundary = true;
                        break;
                    }
                    case '\t': {
                        findBoundary = true;
                        break;
                    }
                    case '.': {
                        findBoundary = true;
                        break;
                    }
                    case ',': {
                        findBoundary = true;
                        break;
                    }
                    case ':': {
                        findBoundary = true;
                        break;
                    }
                    case ';': {
                        findBoundary = true;
                    }
                }
                ++i;
            }
            message = String.valueOf(message.substring(0, i)) + " ...";
        }
        return message;
    }

    private Connection getJndiDSConnection(String driverClass, String jndiNameUrl, Properties connectionProperties) {
        Connection jndiDSConnection;
        block4: {
            if (jndiNameUrl == null || jndiNameUrl.length() == 0) {
                return null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Calling getJndiDSConnection: JNDI name url=" + jndiNameUrl);
            }
            JndiDataSource factory = new JndiDataSource();
            jndiDSConnection = null;
            try {
                jndiDSConnection = factory.getConnection(driverClass, jndiNameUrl, connectionProperties);
            }
            catch (SQLException e) {
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.info("getJndiDSConnection: Unable to get JNDI data source connection; " + e.toString());
            }
        }
        return jndiDSConnection;
    }

    static Properties addUserAuthenticationProperties(Properties connProps, String user, String password) {
        if (connProps == null) {
            connProps = new Properties();
        }
        if (user != null) {
            connProps.setProperty(JDBC_USER_PROP_NAME, user);
        }
        if (password != null) {
            connProps.setProperty(JDBC_PASSWORD_PROP_NAME, password);
        }
        return connProps;
    }

    private void validateConnectionProperties(String driverClass, String url, String jndiNameUrl) {
        if (this.isBlank(jndiNameUrl) && this.isBlank(driverClass)) {
            throw new NullPointerException(this.resourceHandle.getMessage("odajdbc.error.emptyDriverClass"));
        }
        if (this.isBlank(url) && this.isBlank(jndiNameUrl)) {
            throw new NullPointerException(this.resourceHandle.getMessage("odajdbc.missedUrlAndJndi"));
        }
    }

    private boolean isBlank(String url) {
        return url == null || url.trim().toString().length() == 0;
    }

    public IDriver getDriver(String extensionId) throws OdaException {
        OdaJdbcDriver driver;
        block4: {
            driver = null;
            try {
                ExtensionManifest ex = ManifestExplorer.getInstance().getExtensionManifest(extensionId);
                if (ex != null && ex.getDataSourceElement().getAttribute("driverClass") != null) {
                    driver = (IDriver)ex.getDataSourceElement().createExecutableExtension("driverClass");
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINER)) break block4;
                logger.finer("Failed to load driver from extension:" + extensionId);
            }
        }
        if (driver == null) {
            driver = new OdaJdbcDriver();
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionFactory getDriverConnectionFactory(String driverClass) throws OdaException {
        this.loadDriverExtensions();
        IConnectionFactory factory = null;
        Object driverInfo = null;
        HashMap hashMap = this.driverExtensions;
        synchronized (hashMap) {
            if (driverClass != null) {
                driverInfo = this.driverExtensions.get(driverClass);
            }
            if (driverInfo != null) {
                if (driverInfo instanceof IConfigurationElement) {
                    String factoryClass = ((IConfigurationElement)driverInfo).getAttribute("connectionFactory");
                    try {
                        factory = (IConnectionFactory)((IConfigurationElement)driverInfo).createExecutableExtension("connectionFactory");
                        logger.fine("Created connection factory class " + factoryClass + " for driverClass " + driverClass);
                    }
                    catch (CoreException coreException) {
                        JDBCException ex = new JDBCException("odajdbc.CannotInstantiateFactory", null, new Object[]{factoryClass, driverClass});
                        logger.log(Level.WARNING, "Failed to instantiate connection factory for driverClass " + driverClass, (Throwable)((Object)ex));
                        throw ex;
                    }
                    assert (factory != null);
                    this.driverExtensions.put(driverClass, factory);
                } else {
                    assert (driverInfo instanceof IConnectionFactory);
                    factory = driverInfo;
                }
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDriverExtensions() {
        if (this.loadedDriver) {
            return;
        }
        JDBCDriverManager jDBCDriverManager = this;
        synchronized (jDBCDriverManager) {
            if (this.loadedDriver) {
                return;
            }
            this.driverExtensions = new HashMap();
            IExtensionRegistry extReg = Platform.getExtensionRegistry();
            IExtensionPoint extPoint = extReg.getExtensionPoint("org.eclipse.birt.report.data.oda.jdbc.driverinfo");
            if (extPoint == null) {
                return;
            }
            IExtension[] exts = extPoint.getExtensions();
            if (exts == null) {
                return;
            }
            int e = 0;
            while (e < exts.length) {
                IConfigurationElement[] configElems = exts[e].getConfigurationElements();
                if (configElems != null) {
                    int i = 0;
                    while (i < configElems.length) {
                        if (configElems[i].getName().equals("jdbcDriver")) {
                            String driverClass = configElems[i].getAttribute("driverClass");
                            String connectionFactory = configElems[i].getAttribute("connectionFactory");
                            logger.info("Found JDBC driverinfo extension: driverClass=" + driverClass + ", connectionFactory=" + connectionFactory);
                            if (driverClass != null && driverClass.length() > 0 && connectionFactory != null && connectionFactory.length() > 0) {
                                this.driverExtensions.put(driverClass, configElems[i]);
                            }
                        }
                        ++i;
                    }
                }
                ++e;
            }
            this.loadedDriver = true;
        }
    }

    public boolean testConnection(String driverClassName, String connectionString, String userId, String password) throws OdaException {
        return this.testConnection(driverClassName, connectionString, null, userId, password);
    }

    public boolean testConnection(String driverClassName, String connectionString, String userId, String password, Properties props) throws OdaException {
        return this.testConnection(driverClassName, connectionString, null, userId, password, props);
    }

    public boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password) throws OdaException {
        return this.testConnection(driverClassName, connectionString, jndiNameUrl, userId, password, new Properties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password, Properties props) throws OdaException {
        boolean canConnect = false;
        try {
            if (this.getDriverConnectionFactory(driverClassName) != null) {
                this.tryCreateConnection(driverClassName, connectionString, userId, password, props);
                return true;
            }
            if (jndiNameUrl != null) {
                Connection jndiDSConnection = this.getJndiDSConnection(driverClassName, jndiNameUrl, JDBCDriverManager.addUserAuthenticationProperties(null, userId, password));
                if (jndiDSConnection != null) {
                    this.closeConnection(jndiDSConnection);
                    return true;
                }
                if (connectionString == null) throw new JDBCException("odajdbc.CannotParseJNDI", null);
                if (connectionString.trim().length() <= 0) throw new JDBCException("odajdbc.CannotParseJNDI", null);
                return this.testConnection(driverClassName, connectionString, userId, password);
            }
            this.loadAndRegisterDriver(driverClassName, null);
            if (this.testedDrivers.get(driverClassName) == null) {
                Driver driver = this.getRegisteredDriver(driverClassName);
                if (this.isExpectedDriver(driver, driverClassName) && driver.acceptsURL(connectionString)) {
                    this.testedDrivers.put(driverClassName, driver);
                    this.tryCreateConnection(driverClassName, connectionString, userId, password, props);
                    return true;
                }
                if (!canConnect) {
                    throw new JDBCException("odajdbc.CannotParseURL", null);
                }
            } else if (this.testedDrivers.get(driverClassName).acceptsURL(connectionString)) {
                this.tryCreateConnection(driverClassName, connectionString, userId, password, props);
                return true;
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.testfail", e);
        }
        catch (RuntimeException e) {
            OdaException ex = new OdaException(e.getLocalizedMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (canConnect) return true;
        throw new JDBCException("odajdbc.NoSuitableDriver", null);
    }

    private void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {}
    }

    private boolean isExpectedDriver(Driver driver, String className) {
        String actual = driver instanceof WrappedDriver ? driver.toString() : driver.getClass().getName();
        return this.isExpectedDriverClass(actual, className);
    }

    private boolean isExpectedDriverClass(String actual, String expected) {
        String actualPkg = actual.substring(0, actual.lastIndexOf(46));
        String expectedPkg = expected.substring(0, expected.lastIndexOf(46));
        return actualPkg.equals(expectedPkg);
    }

    private void tryCreateConnection(String driverClassName, String connectionString, String userId, String password, Properties props) throws SQLException, OdaException {
        Connection testConn = this.getConnection(driverClassName, connectionString, userId, password, null, props);
        assert (testConn != null);
        this.closeConnection(testConn);
    }

    private Driver findDriver(String className, Collection<String> driverClassPath, boolean refresh) throws OdaException {
        Class<?> driverClass;
        block8: {
            driverClass = null;
            try {
                driverClass = Class.forName(className);
                logger.info("Loaded JDBC driver class in class path: " + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader loader;
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("Driver class not in class path: " + className + ". Trying to locate driver in drivers directory");
                }
                if ((driverClass = this.loadExtraDriver(className, true, refresh, driverClassPath)) != null || (loader = Thread.currentThread().getContextClassLoader()) == null) break block8;
                try {
                    driverClass = Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    driverClass = null;
                }
            }
        }
        if (driverClass == null) {
            logger.warning("Failed to load JDBC driver class: " + className);
            throw new JDBCException("odajdbc.CannotLoadDriverClass", null, className);
        }
        Driver driver = null;
        try {
            driver = this.getDriverInstance(driverClass, refresh);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create new instance of JDBC driver:" + className, e);
            throw new JDBCException("odajdbc.CannotInstantiateDriverClass", null, className);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregisterDriver(String className) throws OdaException {
        if (className == null || className.length() == 0) {
            return false;
        }
        Driver driver = this.getRegisteredDriver(className);
        if (driver == null) {
            return false;
        }
        if (driver != null) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Registering with DriverManager: wrapped driver for " + className);
                }
                HashMap<String, Driver> hashMap = this.registeredDrivers;
                synchronized (hashMap) {
                    this.registeredDrivers.remove(className);
                    DriverManager.deregisterDriver(driver);
                }
                this.cachedJdbcDrivers.remove(className);
                this.testedDrivers.remove(className);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Failed to deRegister wrapped driver instance.", e);
            }
        }
        return true;
    }

    public void loadAndRegisterDriver(String className, Collection<String> driverClassPath) throws OdaException {
        if (className == null || className.length() == 0) {
            return;
        }
        if (this.isDriverRegistered(className)) {
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.info("Loading JDBC driver class: " + className);
        }
        try {
            this.loadAndRegisterDriver(className, driverClassPath, false);
        }
        catch (JDBCException jDBCException) {
            this.loadAndRegisterDriver(className, driverClassPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDriverRegistered(String className) {
        HashMap<String, Driver> hashMap = this.registeredDrivers;
        synchronized (hashMap) {
            return this.registeredDrivers.containsKey(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getRegisteredDriver(String className) {
        HashMap<String, Driver> hashMap = this.registeredDrivers;
        synchronized (hashMap) {
            return this.registeredDrivers.get(className);
        }
    }

    private void loadAndRegisterDriver(String className, Collection<String> driverClassPath, boolean refreshClassLoader) throws OdaException {
        Driver driver = this.findDriver(className, driverClassPath, refreshClassLoader);
        this.registerDriver(driver, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDriver(Driver driver, String className) {
        assert (driver != null);
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Registering with DriverManager: wrapped driver for " + className);
            }
            HashMap<String, Driver> hashMap = this.registeredDrivers;
            synchronized (hashMap) {
                DriverManager.registerDriver(driver);
                this.registeredDrivers.put(className, driver);
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Failed to register wrapped driver instance from DriverManager.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Class loadExtraDriver(String className, boolean refreshUrlsWhenFail, boolean refreshClassLoader, Collection<String> driverClassPath) throws OdaException {
        if (!JDBCDriverManager.$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (this.extraDriverLoader == null || refreshClassLoader) {
            if (this.extraDriverLoader != null) {
                var5_5 = this.registeredDrivers;
                synchronized (var5_5) {
                    for (Map.Entry<String, Driver> e : this.registeredDrivers.entrySet()) {
                        try {
                            DriverManager.deregisterDriver(e.getValue());
                        }
                        catch (SQLException ignore) {
                            JDBCDriverManager.logger.log(Level.WARNING, "Failed to deregister wrapped driver instance from DriverManager.", ignore);
                        }
                    }
                    this.registeredDrivers.clear();
                    this.testedDrivers.clear();
                    this.cachedJdbcDrivers.clear();
                    this.extraDriverLoader.close();
                }
            }
            this.extraDriverLoader = new DriverClassLoader(driverClassPath, null);
        }
        try {
            return Class.forName(className, true, (ClassLoader)this.extraDriverLoader);
        }
        catch (ClassNotFoundException e) {
            JDBCDriverManager.logger.log(Level.SEVERE, "DriverClassLoader failed to load class: " + className, e);
            JDBCDriverManager.logger.log(Level.SEVERE, "refreshUrlsWhenFail: " + refreshUrlsWhenFail);
            JDBCDriverManager.logger.log(Level.SEVERE, "driverClassPath: " + driverClassPath);
            sb = new StringBuffer();
            var10_11 = this.extraDriverLoader.getURLs();
            var9_12 = var10_11.length;
            var8_10 = 0;
            ** while (var8_10 < var9_12)
        }
lbl-1000:
        // 1 sources

        {
            url = var10_11[var8_10];
            sb.append("[").append(url).append("]");
            ++var8_10;
            continue;
        }
lbl39:
        // 1 sources

        JDBCDriverManager.logger.log(Level.SEVERE, "Registered URLs: " + sb.toString());
        if (refreshUrlsWhenFail && this.extraDriverLoader.refreshURLs()) {
            return this.loadExtraDriver(className, false, false, driverClassPath);
        }
        JDBCDriverManager.logger.log(Level.FINER, "Driver class not found in drivers directory: " + className);
        return null;
    }

    private static class DriverClassLoader
    extends URLClassLoader {
        private HashSet fileSet = new HashSet();
        private Collection<String> driverClassPath;

        public DriverClassLoader(Collection<String> driverClassPath, ClassLoader parent) throws OdaException {
            super(new URL[]{}, parent != null ? parent : DriverClassLoader.class.getClassLoader());
            logger.entering(DriverClassLoader.class.getName(), "constructor()");
            this.driverClassPath = driverClassPath;
            this.refreshURLs();
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return ((Object)((Object)this)).getClass().getProtectionDomain().getPermissions();
        }

        public boolean refreshURLs() throws OdaException {
            boolean foundNewUnderSpecifiedDIR = this.refreshFileURLsUnderSpecifiedDIR();
            boolean foundNewUnderDefaultDIR = this.refreshFileURLsUnderDefaultDIR();
            return foundNewUnderSpecifiedDIR || foundNewUnderDefaultDIR;
        }

        private boolean refreshFileURLsUnderSpecifiedDIR() throws OdaException {
            boolean hasNewDriver = false;
            if (this.driverClassPath != null && this.driverClassPath.size() > 0) {
                for (String classPath : this.driverClassPath) {
                    if (!this.refreshFileURL(classPath)) continue;
                    hasNewDriver = true;
                }
            }
            return hasNewDriver;
        }

        private boolean refreshFileURL(String classPath) {
            File driverClassFile = new File(classPath);
            if (!driverClassFile.exists()) {
                return false;
            }
            boolean hasNewDriver = false;
            try {
                this.addURL(driverClassFile.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            if (driverClassFile.isDirectory()) {
                File[] driverFiles;
                File[] fileArray = driverFiles = driverClassFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && OdaJdbcDriver.isDriverFile(pathname.getName());
                    }
                });
                int n = driverFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File driverFile = fileArray[n2];
                    String fileName = driverFile.getName();
                    if (!this.fileSet.contains(fileName)) {
                        this.fileSet.add(fileName);
                        try {
                            hasNewDriver = true;
                            URL driverUrl = driverFile.toURI().toURL();
                            this.addURL(driverUrl);
                            logger.info("JDBCDriverManager: found JAR file " + fileName + ". URL=" + driverUrl);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    ++n2;
                }
            }
            return hasNewDriver;
        }

        private boolean refreshFileURLsUnderDefaultDIR() throws OdaException {
            try {
                URL url = PluginResourceLocator.getPluginEntry((String)"org.eclipse.birt.report.data.oda.jdbc", (String)"drivers");
                if (url != null && (url = PluginResourceLocator.resolve((URL)url)) != null && "file".equals(url.getProtocol())) {
                    String driverFolder = url.getFile();
                    return this.refreshFileURL(driverFolder);
                }
                return false;
            }
            catch (IOException ex) {
                throw new OdaException((Throwable)ex);
            }
        }
    }

    private static class WrappedDriver
    implements Driver {
        private Driver driver;
        private String driverClass;

        WrappedDriver(Driver d, String driverClass) {
            logger.entering(WrappedDriver.class.getName(), "WrappedDriver", driverClass);
            this.driver = d;
            this.driverClass = driverClass;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            boolean res = this.driver.acceptsURL(u);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "WrappedDriver(" + this.driverClass + ").acceptsURL(" + LogUtil.encryptURL(u) + ")returns: " + res);
            }
            return res;
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            logger.entering(String.valueOf(WrappedDriver.class.getName()) + ":" + this.driverClass, "connect", LogUtil.encryptURL(u));
            try {
                return this.driver.connect(u, p);
            }
            catch (RuntimeException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        public String toString() {
            return this.driverClass;
        }
    }
}

