/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.excel.impl.Driver;
import org.eclipse.birt.report.data.oda.excel.impl.util.ExcelFileReader;
import org.eclipse.birt.report.data.oda.excel.impl.util.ResourceLocatorUtil;
import org.eclipse.birt.report.data.oda.excel.impl.util.querytextutil.ColumnsInfoUtil;
import org.eclipse.birt.report.data.oda.excel.impl.util.querytextutil.QueryTextUtil;
import org.eclipse.birt.report.data.oda.excel.ui.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.ui.util.Utility;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ExcelFileSelectionWizardPage
extends DataSetWizardPage
implements ISelectionChangedListener {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectDataSet");
    private static final String queryTextDelimiter = ":";
    private static final String columnsInfoStartSymbol = "{";
    private static final String columnsInfoEndSymbol = "}";
    private static String name = Messages.getString("editor.title.name");
    private static String originalName = Messages.getString("editor.title.originalName");
    private static String dataType = Messages.getString("editor.title.type");
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};
    private Map<Object, Object> dataTypeDisplayNameMap = new HashMap<Object, Object>();
    private Map<Object, Object> dataTypeValueMape = new HashMap<Object, Object>();
    private final int DEFAULT_WIDTH = 200;
    private final int DEFAULT_HEIGHT = 200;
    private transient ComboViewer worksheetsCombo = null;
    private transient org.eclipse.swt.widgets.List availableList = null;
    private transient TableViewer selectedColumnsViewer = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient Button btnMoveUp = null;
    private transient Button btnMoveDown = null;
    private String uriPath;
    private String inclColumnNameLine;
    private String inclTypeLine;
    private String savedSelectedColumnsInfoString;
    private Object selectedFile;
    private String currentSheetName;
    private List<String[]> originalFileColumnsInfoList = new ArrayList<String[]>();
    private List<String[]> savedSelectedColumnsInfoList = new ArrayList<String[]>();

    public ExcelFileSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.createColumnTypeMap();
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public ExcelFileSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Dialog_SelectTableColumn_ID");
    }

    private void createColumnTypeMap() {
        this.dataTypeDisplayNameMap.put(new Integer(4), Messages.getString("datatypes.integer"));
        this.dataTypeDisplayNameMap.put(new Integer(8), Messages.getString("datatypes.float"));
        this.dataTypeDisplayNameMap.put(new Integer(12), Messages.getString("datatypes.string"));
        this.dataTypeDisplayNameMap.put(new Integer(91), Messages.getString("datatypes.date"));
        this.dataTypeDisplayNameMap.put(new Integer(92), Messages.getString("datatypes.time"));
        this.dataTypeDisplayNameMap.put(new Integer(93), Messages.getString("datatypes.dateTime"));
        this.dataTypeDisplayNameMap.put(new Integer(2), Messages.getString("datatypes.decimal"));
        this.dataTypeDisplayNameMap.put(new Integer(16), Messages.getString("datatypes.boolean"));
        this.dataTypeValueMape.put(Messages.getString("datatypes.integer"), "INT");
        this.dataTypeValueMape.put(Messages.getString("datatypes.float"), "DOUBLE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.string"), "STRING");
        this.dataTypeValueMape.put(Messages.getString("datatypes.date"), "DATE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.time"), "TIME");
        this.dataTypeValueMape.put(Messages.getString("datatypes.dateTime"), "TIMESTAMP");
        this.dataTypeValueMape.put(Messages.getString("datatypes.decimal"), "BIGDECIMAL");
        this.dataTypeValueMape.put(Messages.getString("datatypes.boolean"), "BOOLEAN");
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null || this.selectedFile == null) {
            return;
        }
        this.updateValuesFromQuery(queryText);
        if (dataSetDesign.getPublicProperties() != null) {
            this.currentSheetName = dataSetDesign.getPublicProperties().getProperty("WORKSHEETS");
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.worksheetsCombo == null) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectworksheet"));
        label.setLayoutData((Object)data);
        this.createTopComposite(composite, label);
        this.createLeftComposite(composite);
        Composite btnComposite = this.createAddBtnComposite(composite);
        this.createRightComposite(composite, btnComposite);
        this.setupEditors();
        this.loadProperties();
        this.updateFileList();
        return composite;
    }

    private void createTopComposite(Composite composite, Label label) {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(40, -5);
        this.worksheetsCombo = new ComboViewer(composite, 2056);
        this.worksheetsCombo.getControl().setLayoutData((Object)data);
        this.worksheetsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.worksheetsCombo.addSelectionChangedListener((ISelectionChangedListener)this);
        this.worksheetsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ExcelFileSelectionWizardPage.this.getFileName(element);
            }
        });
        data = new FormData();
        data.left = new FormAttachment(this.worksheetsCombo.getControl(), 5);
        data.top = new FormAttachment(0, 5);
    }

    private void createLeftComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.worksheetsCombo.getControl(), 10, 1024);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(40, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 200;
        data.height = 200;
        this.availableList = new org.eclipse.swt.widgets.List(composite, 2818);
        this.availableList.setLayoutData((Object)data);
        this.availableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.selectedColumnsViewer.getTable().deselectAll();
                ExcelFileSelectionWizardPage.this.btnAdd.setEnabled(true);
                ExcelFileSelectionWizardPage.this.btnRemove.setEnabled(false);
                ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
            }
        });
        this.availableList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ExcelFileSelectionWizardPage.this.addColumns();
            }
        });
    }

    private Composite createAddBtnComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, 5);
        data.left = new FormAttachment((Control)this.availableList, 3);
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        btnComposite.setLayout((Layout)layout);
        this.btnAdd = new Button(btnComposite, 0);
        GridData gridData = new GridData(772);
        gridData.heightHint = 25;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.setToolTipText(Messages.getString("tooltip.button.add"));
        if (this.btnAdd.getStyle() == (this.btnAdd.getStyle() | 0x2000000)) {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        } else {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.addColumns();
            }
        });
        this.btnAdd.setEnabled(false);
        return btnComposite;
    }

    private void createRightComposite(Composite composite, Composite btnComposite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.worksheetsCombo.getControl(), 10, 1024);
        data.left = new FormAttachment((Control)btnComposite, 3);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -5);
        Composite rightComposite = new Composite(composite, 2048);
        rightComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rightComposite.setLayout((Layout)layout);
        this.selectedColumnsViewer = new TableViewer(rightComposite, 68354);
        this.selectedColumnsViewer.getTable().setHeaderVisible(true);
        this.selectedColumnsViewer.getTable().setLinesVisible(true);
        this.selectedColumnsViewer.getTable().setLayoutData((Object)new GridData(1808));
        TableColumn column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.originalName"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.type"));
        column.setWidth(100);
        this.selectedColumnsViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.btnAdd.setEnabled(false);
                ExcelFileSelectionWizardPage.this.availableList.deselectAll();
                int count = ExcelFileSelectionWizardPage.this.selectedColumnsViewer.getTable().getSelectionCount();
                int index = ExcelFileSelectionWizardPage.this.selectedColumnsViewer.getTable().getSelectionIndex();
                if (count == 1) {
                    ExcelFileSelectionWizardPage.this.btnRemove.setEnabled(true);
                    if (ExcelFileSelectionWizardPage.this.selectedColumnsViewer.getTable().getItemCount() == 1) {
                        ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                        ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                    } else if (index == 0) {
                        ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                        ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(true);
                    } else if (index == ExcelFileSelectionWizardPage.this.selectedColumnsViewer.getTable().getItemCount() - 1) {
                        ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(true);
                        ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                    } else {
                        ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(true);
                        ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(true);
                    }
                } else if (count > 1) {
                    ExcelFileSelectionWizardPage.this.btnRemove.setEnabled(true);
                    ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                    ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                } else {
                    ExcelFileSelectionWizardPage.this.btnRemove.setEnabled(false);
                    ExcelFileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                    ExcelFileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                }
            }
        });
        this.setColumnsViewerContent();
        this.setColumnsViewerLabels();
        this.selectedColumnsViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ExcelFileSelectionWizardPage.this.removeColumns();
            }
        });
        this.createEditBtnGroup(rightComposite);
    }

    private void createEditBtnGroup(Composite rightComposite) {
        Composite btnComposite = new Composite(rightComposite, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        btnComposite.setLayout((Layout)layout);
        this.btnMoveUp = new Button(btnComposite, 0);
        this.btnMoveUp.setText(Messages.getString("button.moveUp"));
        this.btnMoveUp.setToolTipText(Messages.getString("tooltip.button.up"));
        this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.moveUpItem();
            }
        });
        this.btnRemove = new Button(btnComposite, 0);
        this.btnRemove.setText(Messages.getString("button.delete"));
        this.btnRemove.setToolTipText(Messages.getString("tooltip.button.delete"));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.removeColumns();
            }
        });
        this.btnMoveDown = new Button(btnComposite, 0);
        this.btnMoveDown.setText(Messages.getString("button.moveDown"));
        this.btnMoveDown.setToolTipText(Messages.getString("tooltip.button.down"));
        this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelFileSelectionWizardPage.this.moveDownItem();
            }
        });
        this.resetButtonWidth();
    }

    private void resetButtonWidth() {
        int widthHint = Math.max(this.btnMoveUp.computeSize((int)-1, (int)-1).x, this.btnRemove.computeSize((int)-1, (int)-1).x);
        widthHint = Math.max(widthHint, this.btnMoveDown.computeSize((int)-1, (int)-1).x);
        widthHint = Math.max(widthHint, 52);
        GridData btnGd = new GridData();
        btnGd.widthHint = widthHint;
        this.btnMoveUp.setLayoutData((Object)btnGd);
        this.btnRemove.setLayoutData((Object)btnGd);
        this.btnMoveDown.setLayoutData((Object)btnGd);
    }

    private void setColumnsViewerLabels() {
        this.selectedColumnsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void setColumnsViewerContent() {
        this.selectedColumnsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new TextCellEditor((Composite)this.selectedColumnsViewer.getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.selectedColumnsViewer.getTable(), dataTypeDisplayNames, 8);
        this.selectedColumnsViewer.setColumnProperties(new String[]{name, originalName, dataType});
        this.selectedColumnsViewer.setCellEditors(editors);
        this.selectedColumnsViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                if (name.equals(property)) {
                    value = ((String[])element)[0];
                } else if (originalName.equals(property)) {
                    value = ((String[])element)[1];
                } else if (dataType.equals(property)) {
                    String temp = ((String[])element)[2];
                    if (temp == null) {
                        value = new Integer(0);
                    } else {
                        int i = 0;
                        while (i < dataTypeDisplayNames.length) {
                            if (temp.equals(dataTypeDisplayNames[i])) {
                                value = new Integer(i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                String[] actualElement = (String[])((TableItem)element).getData();
                if (value != null) {
                    if (name.equals(property)) {
                        if (ExcelFileSelectionWizardPage.this.isUnique(actualElement, (String)value) && !ExcelFileSelectionWizardPage.this.isEmpty((String)value)) {
                            ExcelFileSelectionWizardPage.this.replace(actualElement, property, (String)value);
                            ExcelFileSelectionWizardPage.this.selectedColumnsViewer.refresh();
                            ExcelFileSelectionWizardPage.this.setMessage(DEFAULT_MESSAGE);
                        } else {
                            ExcelFileSelectionWizardPage.this.setMessage(Messages.getString("error.duplicatedNameValueOrEmpty"), 2);
                        }
                    } else if (dataType.equals(property)) {
                        int index = (Integer)value;
                        if (!dataTypeDisplayNames[index].equals(actualElement[2])) {
                            ExcelFileSelectionWizardPage.this.replace(actualElement, property, dataTypeDisplayNames[index]);
                            ExcelFileSelectionWizardPage.this.selectedColumnsViewer.refresh();
                        }
                    }
                    return;
                }
            }
        });
    }

    private boolean isUnique(String[] element, String value) {
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            if (i != this.savedSelectedColumnsInfoList.indexOf(element) && value.equalsIgnoreCase(this.savedSelectedColumnsInfoList.get(i)[0])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEmpty(String value) {
        return value.trim().equals("");
    }

    private int getExistenceCount(String columnName) {
        int count = 0;
        ArrayList<String[]> existedColumns = new ArrayList<String[]>();
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            if (columnName.equals(this.savedSelectedColumnsInfoList.get(i)[1])) {
                ++count;
                existedColumns.add(this.savedSelectedColumnsInfoList.get(i));
            }
            ++i;
        }
        int j = 0;
        while (j < existedColumns.size()) {
            if ((String.valueOf(columnName) + "_" + count).equals(this.savedSelectedColumnsInfoList.get(j)[0])) {
                ++count;
                j = -1;
            }
            ++j;
        }
        return count;
    }

    private void replace(String[] element, String property, String value) {
        int index = this.savedSelectedColumnsInfoList.indexOf(element);
        if (name.equals(property)) {
            element[0] = value;
            this.savedSelectedColumnsInfoList.set(index, element);
        } else if (dataType.equals(property)) {
            element[2] = value;
            this.savedSelectedColumnsInfoList.set(index, element);
        }
    }

    private String getFileName(Object obj) {
        if (obj instanceof File) {
            return ((File)obj).getName();
        }
        if (obj instanceof URI) {
            return ((URI)obj).getPath();
        }
        return obj.toString();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String sheetName = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
        String queryText = this.getInitializationDesign().getQueryText();
        if (sheetName.equalsIgnoreCase(this.currentSheetName) && (queryText.trim().length() == 0 || this.isOldFile(queryText, this.getFileName(this.selectedFile)))) {
            return;
        }
        if (this.currentSheetName != null && !MessageDialog.openConfirm((Shell)this.worksheetsCombo.getControl().getShell(), (String)Messages.getString("confirm.reselectWorksheetTitle"), (String)Messages.getString("confirm.reselectWorksheetMessage"))) {
            this.worksheetsCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentSheetName));
            return;
        }
        this.currentSheetName = sheetName;
        this.setPageComplete(false);
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.availableList.removeAll();
        if (this.getShell() != null) {
            Cursor waitCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
            this.getControl().setCursor(waitCursor);
        }
        String fileName = this.getFileName(this.selectedFile);
        String[] columnNames = this.getFileColumnNames(this.selectedFile);
        if (columnNames != null && columnNames.length != 0) {
            this.enableListAndViewer();
            this.availableList.setItems(columnNames);
            this.availableList.select(0);
            this.btnAdd.setEnabled(true);
            this.btnRemove.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            if (!fileName.endsWith("xls") && !fileName.endsWith("xlsx")) {
                this.setMessage(Messages.getString("warning.fileExtensionInvalid"), 2);
            } else if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
                this.setMessage(this.getEmptyColumnErrMsg(), 3);
            } else {
                this.setMessage(DEFAULT_MESSAGE);
            }
        }
        if (this.getShell() != null) {
            Cursor normalCursor = new Cursor((Device)this.getShell().getDisplay(), 0);
            this.getControl().setCursor(normalCursor);
        }
    }

    private String getEmptyColumnErrMsg() {
        return this.currentSheetName == null ? Messages.getString("error.selectWorksheet") : Messages.getString("error.selectColumns");
    }

    private void loadProperties() {
        Properties dataSourceProps = null;
        try {
            dataSourceProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            return;
        }
        this.uriPath = dataSourceProps.getProperty("URI");
        this.inclColumnNameLine = dataSourceProps.getProperty("INCLCOLUMNNAME");
        this.inclTypeLine = dataSourceProps.getProperty("INCLTYPELINE");
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        if (dataSetDesign.getPublicProperties() != null) {
            this.currentSheetName = dataSetDesign.getPublicProperties().getProperty("WORKSHEETS");
        }
    }

    private boolean isOldFile(String queryText, String selectedFile) {
        return queryText.contains(selectedFile);
    }

    private void updateFileList() {
        if (this.uriPath == null) {
            this.disableAll();
            return;
        }
        ArrayList<URI> allFiles = new ArrayList<URI>();
        URI uri = null;
        try {
            org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers ri = DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)this.getHostResourceIdentifiers());
            uri = ResourceLocatorUtil.resolvePath((Object)ri, (String)this.uriPath);
        }
        catch (OdaException e) {
            this.setMessage(String.valueOf(Messages.getString("ui.ExcelFileNotFound")) + uri + "; " + e.getLocalizedMessage());
            this.disableAll();
            return;
        }
        if (uri == null) {
            this.setMessage(String.valueOf(Messages.getString("ui.ExcelFileNotFound")) + uri);
            this.disableAll();
            return;
        }
        try {
            ResourceLocatorUtil.validateFileURI((Object)uri);
            allFiles.add(uri);
        }
        catch (Exception exception) {}
        if (allFiles.size() > 0) {
            this.enableListAndViewer();
            this.selectedFile = allFiles.get(0);
            String extension = ExcelFileReader.getExtensionName((Object)this.selectedFile);
            if (extension.equals("xls") || extension.equals("xlsx")) {
                this.setMessage(DEFAULT_MESSAGE);
            } else {
                this.setMessage(Messages.getString("warning.fileExtensionInvalid"), 3);
            }
            try {
                this.populateWorkSheetCombo();
                String queryText = this.getInitializationDesign().getQueryText();
                if (this.currentSheetName != null && this.isOldFile(queryText, this.getFileName(this.selectedFile))) {
                    String[] columnNames = this.getFileColumnNames(this.selectedFile);
                    this.availableList.setItems(columnNames);
                }
            }
            catch (Exception exception) {
                this.setMessage(Messages.getString("ui.ExcelFileNotFound"), 3);
            }
        } else {
            String decodedURIPath = uri.getPath();
            if (decodedURIPath == null) {
                decodedURIPath = this.uriPath;
            }
            this.setErrorMessage(Messages.getFormattedString("error.noFile", new Object[]{decodedURIPath}));
            this.disableAll();
        }
    }

    private String[] getFileColumnNames(Object file) {
        String[] result;
        List<String[]> propList = this.getQueryColumnsInfo("select * from " + QueryTextUtil.getQuotedName((String)this.getFileName(file)), file, this.currentSheetName);
        if (propList != null) {
            this.originalFileColumnsInfoList = new ArrayList<String[]>(propList);
            result = new String[propList.size()];
            int i = 0;
            while (i < propList.size()) {
                result[i] = propList.get(i)[1];
                ++i;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    private List<String[]> getQueryColumnsInfo(String queryText, Object file, String sheetName) {
        Driver excelDriver = new Driver();
        IConnection conn = null;
        ArrayList<String[]> columnList = new ArrayList<String[]>();
        try {
            conn = excelDriver.getConnection(null);
            IResultSetMetaData metadata = this.getResultSetMetaData(queryText, file, conn, sheetName);
            int columnCount = metadata.getColumnCount();
            if (columnCount == 0) {
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                return arrayList;
            }
            int i = 0;
            while (i < columnCount) {
                String[] result;
                result = new String[]{metadata.getColumnName(i + 1), this.getOriginalColumnName(result[0], this.savedSelectedColumnsInfoString, metadata), this.getDataTypeDisplayName(new Integer(metadata.getColumnType(i + 1)))};
                columnList.add(result);
                ++i;
            }
            ArrayList<String[]> arrayList = columnList;
            return arrayList;
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.updateExceptionInfo();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            return arrayList;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void updateExceptionInfo() {
        if (this.availableList.getItemCount() == 0) {
            this.disableAvailableListAndButtons();
        }
    }

    private void disableAvailableListAndButtons() {
        this.availableList.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
    }

    private String getDataTypeDisplayName(Integer type) {
        if (this.dataTypeDisplayNameMap.get(type) != null) {
            return (String)this.dataTypeDisplayNameMap.get(type);
        }
        return Messages.getString("datatypes.string");
    }

    private String getDataTypeValue(String displayName) {
        if (this.dataTypeValueMape.get(displayName) != null) {
            return (String)this.dataTypeValueMape.get(displayName);
        }
        return "STRING";
    }

    private String getOriginalColumnName(String name, String columnsInfo, IResultSetMetaData metadata) {
        String originalName = null;
        if (columnsInfo.length() != 0) {
            ColumnsInfoUtil ciu = new ColumnsInfoUtil(columnsInfo);
            String[] names = ciu.getColumnNames();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    originalName = ciu.getOriginalColumnNames()[i];
                    break;
                }
                ++i;
            }
        }
        if (originalName == null) {
            try {
                int j = 0;
                while (j < metadata.getColumnCount()) {
                    if (name.equals(metadata.getColumnName(j + 1))) {
                        originalName = name;
                    }
                    ++j;
                }
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        return originalName;
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException odaException) {}
    }

    private IResultSetMetaData getResultSetMetaData(String queryText, Object file, IConnection conn, String sheetName) throws OdaException {
        Properties prop = new Properties();
        if (file != null) {
            if (file instanceof File) {
                if (((File)file).getParent() == null) {
                    throw new OdaException(Messages.getString("error.unexpectedError"));
                }
                prop.put("URI", ((File)file).getAbsolutePath());
            } else if (file instanceof URI) {
                prop.put("URI", file.toString());
            }
        }
        if (this.inclColumnNameLine != null) {
            prop.put("INCLCOLUMNNAME", this.inclColumnNameLine);
        }
        if (this.inclTypeLine != null) {
            prop.put("INCLTYPELINE", this.inclTypeLine);
        }
        this.savedSelectedColumnsInfoString = new QueryTextUtil(queryText).getColumnsInfo();
        Map appContext = DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)this.getHostResourceIdentifiers());
        conn.setAppContext((Object)appContext);
        conn.open(prop);
        IQuery query = conn.newQuery(null);
        query.setProperty("WORKSHEETS", sheetName);
        query.setMaxRows(1);
        query.prepare(queryText);
        query.executeQuery();
        return query.getMetaData();
    }

    private void enableListAndViewer() {
        this.availableList.setEnabled(true);
        this.selectedColumnsViewer.getTable().setEnabled(true);
    }

    private void disableAll() {
        this.availableList.setEnabled(false);
        this.selectedColumnsViewer.getTable().setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.setPageComplete(false);
    }

    private void setDisplayContent(List<String[]> list, TableViewer tViewer) {
        tViewer.getTable().removeAll();
        tViewer.setInput(list);
        tViewer.getTable().select(tViewer.getTable().getTopIndex());
    }

    private String getQuery() {
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            return "";
        }
        String tableName = null;
        StringBuffer buf = new StringBuffer();
        if (this.selectedFile != null) {
            tableName = this.getFileName(this.selectedFile);
        }
        if (tableName != null) {
            tableName = QueryTextUtil.getQuotedName(tableName);
            if (this.availableList.getItemCount() == 0) {
                buf.append("select * from ").append(tableName);
            } else {
                buf.append("select ");
                String[] columns = new String[this.selectedColumnsViewer.getTable().getItemCount()];
                int m = 0;
                while (m < columns.length) {
                    columns[m] = this.selectedColumnsViewer.getTable().getItem(m).getText(1);
                    ++m;
                }
                int n = 0;
                while (n < columns.length) {
                    StringBuffer sb = new StringBuffer();
                    char[] columnChars = columns[n].toCharArray();
                    int i = 0;
                    while (i < columnChars.length) {
                        if (columnChars[i] == '\"') {
                            sb.append("\\\"");
                        } else if (columnChars[i] == '\\') {
                            sb.append("\\\\");
                        } else {
                            sb.append(columnChars[i]);
                        }
                        ++i;
                    }
                    buf.append(String.valueOf('\"') + sb.toString() + '\"');
                    if (n < columns.length - 1) {
                        buf.append(", ");
                    }
                    ++n;
                }
                buf.append(" from ").append(tableName);
            }
        }
        return buf.toString();
    }

    private void updateValuesFromQuery(String queryText) {
        if (queryText.length() == 0) {
            this.validateHasSelectedColumns();
            return;
        }
        if (this.selectedFile != null && this.isOldFile(queryText, this.getFileName(this.selectedFile))) {
            this.updateColumnsFromQuery(queryText, this.selectedFile);
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
            this.setMessage(this.getEmptyColumnErrMsg(), 3);
        }
    }

    private boolean validateHasSelectedColumns() {
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0 && this.getControl().getShell().getText().startsWith("Edit")) {
            this.setPageComplete(false);
            this.setMessage(this.getEmptyColumnErrMsg(), 3);
            return false;
        }
        return true;
    }

    private void updateColumnsFromQuery(String queryText, Object file) {
        this.availableList.setItems(this.getFileColumnNames(file));
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.savedSelectedColumnsInfoList = this.getQueryColumnsInfo(queryText, file, this.currentSheetName);
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.setPageComplete(true);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void moveUpItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > 0 && index < count) {
            if (!this.btnMoveDown.isEnabled()) {
                this.btnMoveDown.setEnabled(true);
            }
            String[] obj = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index - 1));
            this.savedSelectedColumnsInfoList.set(index - 1, obj);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        }
        if (index == 1) {
            this.btnMoveUp.setEnabled(false);
        }
    }

    private void moveDownItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > -1 && index < count - 1) {
            if (!this.btnMoveUp.isEnabled()) {
                this.btnMoveUp.setEnabled(true);
            }
            String[] obj = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index + 1));
            this.savedSelectedColumnsInfoList.set(index + 1, obj);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index + 1);
        }
        if (index == count - 2) {
            this.btnMoveDown.setEnabled(false);
        }
    }

    private void addColumns() {
        List<String[]> addedItems = this.createAddedColumnsInfo(this.availableList.getSelection());
        int i = 0;
        while (i < addedItems.size()) {
            this.savedSelectedColumnsInfoList.add(addedItems.get(i));
            ++i;
        }
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.selectedColumnsViewer.getTable().setSelection(this.selectedColumnsViewer.getTable().getItemCount() - 1);
        int nextSelectionIndex = this.availableList.getSelectionIndex() + 1;
        if (nextSelectionIndex < this.availableList.getItemCount()) {
            this.availableList.setSelection(nextSelectionIndex);
            this.btnAdd.setEnabled(true);
        } else if (this.availableList.getSelectionCount() == 0) {
            this.btnAdd.setEnabled(false);
        }
        this.selectedColumnsViewer.getTable().setSelection(-1);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(true);
    }

    private List<String[]> createAddedColumnsInfo(String[] addedColumnNames) {
        ArrayList<String[]> addedColumnsInfo = new ArrayList<String[]>();
        int count = 0;
        int i = 0;
        while (i < addedColumnNames.length) {
            count = this.getExistenceCount(addedColumnNames[i]);
            String[] addedColumns = new String[]{count == 0 ? addedColumnNames[i] : String.valueOf(addedColumnNames[i]) + "_" + count, addedColumnNames[i], this.getColumnTypeName(addedColumnNames[i])};
            addedColumnsInfo.add(addedColumns);
            ++i;
        }
        return addedColumnsInfo;
    }

    private String getColumnTypeName(String columnName) {
        int i = 0;
        while (i < this.originalFileColumnsInfoList.size()) {
            if (columnName.equals(this.originalFileColumnsInfoList.get(i)[1])) {
                return this.originalFileColumnsInfoList.get(i)[2];
            }
            ++i;
        }
        return null;
    }

    private void removeColumns() {
        TableItem[] tis = this.selectedColumnsViewer.getTable().getSelection();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        String[] removedColumnInfo = null;
        ArrayList<String[]> removedItems = new ArrayList<String[]>();
        int i = 0;
        while (i < tis.length) {
            removedColumnInfo = new String[]{tis[i].getText(0), tis[i].getText(1), tis[i].getText(2)};
            removedItems.add(removedColumnInfo);
            ++i;
        }
        this.removeItemsFromSelectedOnes(removedItems);
        this.selectedColumnsViewer.refresh();
        if (index > 0) {
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        } else {
            this.selectedColumnsViewer.getTable().setSelection(index);
        }
        if (this.selectedColumnsViewer.getTable().getSelectionCount() == 0) {
            this.btnRemove.setEnabled(false);
        }
        if (this.savedSelectedColumnsInfoList.size() <= 1) {
            this.btnMoveDown.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
            this.setMessage(this.getEmptyColumnErrMsg(), 3);
        }
    }

    private void removeItemsFromSelectedOnes(List<String[]> removedItemsList) {
        int i = 0;
        while (i < removedItemsList.size()) {
            int j = 0;
            while (j < this.savedSelectedColumnsInfoList.size()) {
                if (removedItemsList.get(i)[0].equals(this.savedSelectedColumnsInfoList.get(j)[0]) && removedItemsList.get(i)[1].equals(this.savedSelectedColumnsInfoList.get(j)[1]) && removedItemsList.get(i)[2].equals(this.savedSelectedColumnsInfoList.get(j)[2])) {
                    this.savedSelectedColumnsInfoList.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block8: {
            String sheetName;
            String queryText = this.getQueryText();
            if (queryText.equals(dataSetDesign.getQueryText()) && (sheetName = dataSetDesign.getPublicProperties().getProperty("WORKSHEETS")) != null && sheetName.equals(this.currentSheetName)) {
                return;
            }
            dataSetDesign.setQueryText(queryText);
            this.savePublicProperties(dataSetDesign);
            if (this.selectedFile == null) {
                dataSetDesign.setResultSets(null);
                return;
            }
            if (!this.validateHasSelectedColumns()) {
                dataSetDesign.setResultSets(null);
                return;
            }
            IConnection conn = null;
            try {
                try {
                    Driver excelDriver = new Driver();
                    conn = excelDriver.getConnection(null);
                    IResultSetMetaData metadata = this.getResultSetMetaData(queryText, this.selectedFile, conn, this.currentSheetName);
                    this.setResultSetMetaData(dataSetDesign, metadata);
                }
                catch (OdaException odaException) {
                    dataSetDesign.setResultSets(null);
                    this.closeConnection(conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
    }

    private void savePublicProperties(DataSetDesign dataSetDesign) {
        if (dataSetDesign.getPublicProperties() == null) {
            try {
                String dsID = dataSetDesign.getOdaExtensionDataSourceId();
                String dstID = dataSetDesign.getOdaExtensionDataSetId();
                org.eclipse.datatools.connectivity.oda.design.Properties dsProp = DesignSessionUtil.createDataSetPublicProperties((String)dsID, (String)dstID, (Properties)this.getPageProperties());
                dataSetDesign.setPublicProperties(dsProp);
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        } else if (dataSetDesign.getPublicProperties() != null && dataSetDesign.getPublicProperties().findProperty("WORKSHEETS") != null) {
            dataSetDesign.getPublicProperties().findProperty("WORKSHEETS").setNameValue("WORKSHEETS", this.currentSheetName);
        }
    }

    private Properties getPageProperties() {
        Properties prop = new Properties();
        if (this.inclColumnNameLine != null) {
            prop.put("INCLCOLUMNNAME", this.inclColumnNameLine);
        }
        if (this.inclTypeLine != null) {
            prop.put("INCLTYPELINE", this.inclTypeLine);
        }
        if (this.currentSheetName != null) {
            prop.put("WORKSHEETS", this.currentSheetName);
        }
        return prop;
    }

    private String getQueryText() {
        String query = this.getQuery();
        String queryText = query.length() > 0 ? String.valueOf(query) + " " + queryTextDelimiter + " " + columnsInfoStartSymbol + this.createSelectedColumnsInfoString() + columnsInfoEndSymbol : "";
        return queryText;
    }

    private String createSelectedColumnsInfoString() {
        String prop = "";
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            char[] columnNameChars = this.savedSelectedColumnsInfoList.get(i)[0].toCharArray();
            StringBuffer columnNameBuf = new StringBuffer();
            char[] originalColumnNameChars = this.savedSelectedColumnsInfoList.get(i)[1].toCharArray();
            StringBuffer originalColumnNameBuf = new StringBuffer();
            int m = 0;
            while (m < columnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)columnNameChars[m])) {
                    columnNameBuf.append("\\" + columnNameChars[m]);
                } else {
                    columnNameBuf.append(columnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + columnNameBuf.toString() + '\"' + ",";
            m = 0;
            while (m < originalColumnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)originalColumnNameChars[m])) {
                    originalColumnNameBuf.append("\\" + originalColumnNameChars[m]);
                } else {
                    originalColumnNameBuf.append(originalColumnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + originalColumnNameBuf.toString() + '\"' + ",";
            prop = i != this.savedSelectedColumnsInfoList.size() - 1 ? String.valueOf(prop) + this.getDataTypeValue(this.savedSelectedColumnsInfoList.get(i)[2]) + ";" : String.valueOf(prop) + this.getDataTypeValue(this.savedSelectedColumnsInfoList.get(i)[2]);
            ++i;
        }
        this.savedSelectedColumnsInfoString = prop;
        return this.savedSelectedColumnsInfoString;
    }

    private void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    private void populateWorkSheetCombo() throws IOException {
        List sheetNameList = ExcelFileReader.getSheetNamesInExcelFile((Object)this.selectedFile);
        this.worksheetsCombo.setInput((Object)sheetNameList.toArray());
        for (String sheet : sheetNameList) {
            String queryText = this.getInitializationDesign().getQueryText();
            if (!sheet.equals(this.currentSheetName) || !this.isOldFile(queryText, this.getFileName(this.selectedFile))) continue;
            this.worksheetsCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentSheetName));
        }
        if (this.worksheetsCombo.getSelection().isEmpty()) {
            this.currentSheetName = null;
        }
    }

    static class ExcelFileFilter
    implements FilenameFilter {
        ExcelFileFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            File file = new File(dir + File.separator + fileName);
            if (file.isFile() && !file.isHidden()) {
                return fileName.endsWith("xls") || fileName.endsWith("xlsx");
            }
            return false;
        }
    }
}

