/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.util.List;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.ExportedColumn;
import org.eclipse.birt.report.service.api.ExportedResultSet;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.soapengine.api.ResultSets;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractQueryExportActionHandler
extends AbstractBaseActionHandler {
    protected String __docName;

    protected abstract void handleUpdate(ResultSets var1);

    protected abstract void __checkDocumentExists() throws Exception;

    public AbstractQueryExportActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void __execute() throws Exception {
        BaseAttributeBean attrBean = this.context.getBean();
        this.__docName = attrBean.getReportDocumentName();
        this.__checkDocumentExists();
        String instanceID = this.operation.getTarget().getId();
        InputOptions options = new InputOptions();
        options.setOption("request", this.context.getRequest());
        List exportedResultSets = instanceID.equals("Document") ? this.getReportService().getResultSetsMetadata(this.__docName, options) : this.getReportService().getResultSetsMetadata(this.__docName, instanceID, options);
        if (exportedResultSets == null) {
            AxisFault fault = new AxisFault();
            fault.setFaultReason(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_RESULT_SET"));
            throw fault;
        }
        ResultSet[] resultSetArray = this.getResultSetArray(exportedResultSets);
        ResultSets resultSets = new ResultSets();
        resultSets.setResultSet(resultSetArray);
        this.handleUpdate(resultSets);
    }

    private ResultSet[] getResultSetArray(List exportedResultSets) {
        assert (exportedResultSets != null);
        ResultSet[] rsArray = new ResultSet[exportedResultSets.size()];
        for (int i = 0; i < exportedResultSets.size(); ++i) {
            ExportedResultSet rs = (ExportedResultSet)exportedResultSets.get(i);
            List columns = rs.getColumns();
            Column[] colArray = new Column[columns.size()];
            for (int j = 0; j < columns.size(); ++j) {
                ExportedColumn col = (ExportedColumn)columns.get(j);
                colArray[j] = new Column(ParameterAccessor.htmlEncode(col.getName()), col.getLabel(), col.getVisibility());
            }
            rsArray[i] = new ResultSet(rs.getQueryName(), colArray);
        }
        return rsArray;
    }
}

