/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDINullValue
extends JDIObjectValue {
    public JDINullValue(JDIDebugTarget target) {
        super(target, null);
    }

    @Override
    protected List<IJavaVariable> getVariablesList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getReferenceTypeName() {
        return "null";
    }

    @Override
    public String getValueString() {
        return "null";
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public int getArrayLength() {
        return -1;
    }

    @Override
    public IJavaType getJavaType() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JDINullValue;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return "null";
    }

    @Override
    public IJavaFieldVariable getField(String name, boolean superField) {
        return null;
    }

    @Override
    public IJavaFieldVariable getField(String name, String typeSignature) {
        return null;
    }

    @Override
    public IJavaThread[] getWaitingThreads() {
        return null;
    }

    @Override
    public IJavaThread getOwningThread() {
        return null;
    }

    @Override
    public IJavaObject[] getReferringObjects(long max) {
        return new IJavaObject[0];
    }

    @Override
    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread, boolean superSend) throws DebugException {
        return this.npe(selector, signature);
    }

    @Override
    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread, String typeSignature) throws DebugException {
        return this.npe(selector, signature);
    }

    private IJavaValue npe(String selector, String signature) throws DebugException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(selector);
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        buffer.append('(');
        int i = 0;
        while (i < parameterTypes.length) {
            buffer.append(Signature.getSignatureSimpleName((String)parameterTypes[i].replace('/', '.')));
            if (i + 1 < parameterTypes.length) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(')');
        this.requestFailed(MessageFormat.format((String)JDIDebugModelMessages.JDINullValue_0, (Object[])new Object[]{buffer.toString()}), null);
        return null;
    }

    @Override
    public void disableCollection() throws DebugException {
    }

    @Override
    public void enableCollection() throws DebugException {
    }

    @Override
    public boolean isNull() {
        return true;
    }
}

