/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ExpressionPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExpressionPropertyDescriptor
extends PropertyDescriptor {
    protected Text text;
    private Composite containerPane;
    private Expression deValue;
    private String newValue;
    private ExpressionButton exprButton;
    private boolean multi = true;

    public ExpressionPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Text getTextControl() {
        return this.text;
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public void load() {
        Object value;
        ExpressionButtonUtil.ExpressionHelper helper = (ExpressionButtonUtil.ExpressionHelper)this.exprButton.getExpressionHelper();
        helper.setContextObject(DEUtil.getInputFirstElement((Object)this.getInput()));
        if (this.getDescriptorProvider() instanceof ExpressionPropertyDescriptorProvider) {
            helper.setProvider((IExpressionProvider)((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).getExpressionProvider());
        }
        if ((value = this.getDescriptorProvider().load()) == null || value instanceof Expression) {
            this.deValue = (Expression)value;
            String stringValue = this.deValue == null || this.deValue.getExpression() == null ? "" : (String)this.deValue.getExpression();
            this.text.setText(stringValue);
            this.text.setData("exprType", (Object)(this.deValue == null || this.deValue.getType() == null ? UIUtil.getDefaultScriptType() : this.deValue.getType()));
            Object button = this.text.getData("exprButton");
            if (button instanceof ExpressionButton) {
                ((ExpressionButton)button).refresh();
            }
            if (this.getDescriptorProvider() instanceof ExpressionPropertyDescriptorProvider) {
                boolean readOnly = ((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly();
                boolean enable = ((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).isEnable();
                this.text.setEnabled(enable && !readOnly);
                if (button instanceof ExpressionButton) {
                    ((ExpressionButton)button).refresh();
                    ((ExpressionButton)button).setEnabled(enable && !readOnly);
                }
            }
        }
    }

    public Control getControl() {
        return this.containerPane;
    }

    public Control createControl(Composite parent) {
        this.containerPane = FormWidgetFactory.getInstance().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        if (!this.multi) {
            layout.marginHeight = 2;
            layout.marginWidth = 2;
        }
        this.containerPane.setLayout((Layout)layout);
        if (this.multi) {
            this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(this.containerPane, "", 834) : new Text(this.containerPane, 2882);
            this.text.setLayoutData((Object)new GridData(1808));
        } else {
            this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(this.containerPane, "", 2) : new Text(this.containerPane, 2050);
            GridData gd = new GridData(768);
            gd.heightHint = this.text.computeSize((int)-1, (int)-1).y - (this.isFormStyle() ? 0 : this.text.getBorderWidth() * 2);
            this.text.setLayoutData((Object)gd);
        }
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ExpressionPropertyDescriptor.this.handleFocusLostEvent();
            }
        });
        if (this.getDescriptorProvider() instanceof ExpressionPropertyDescriptorProvider) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.data instanceof String[]) {
                        ExpressionPropertyDescriptor.this.newValue = ((String[])event.data)[0];
                    }
                    ExpressionPropertyDescriptor.this.processAction();
                }
            };
            this.exprButton = ExpressionButtonUtil.createExpressionButton((Composite)this.containerPane, (Control)this.text, null, null, (Listener)listener, (boolean)false, (int)(this.isFormStyle() ? 0x800000 : 8), (ExpressionButtonUtil.ExpressionHelper)new ExpressionButtonUtil.ExpressionHelper());
        }
        return this.containerPane;
    }

    protected void handleSelectEvent() {
        this.newValue = this.text.getText();
        this.processAction();
    }

    protected void handleFocusLostEvent() {
        this.newValue = this.text.getText();
        this.processAction();
    }

    private void processAction() {
        String value = this.newValue;
        if (value != null && value.length() == 0) {
            value = null;
        }
        try {
            if (value == null && this.deValue != null) {
                this.save(value);
            } else if (this.text.getText().trim().length() == 0) {
                this.save(null);
            } else {
                Expression expression = new Expression((Object)this.text.getText().trim(), (String)this.text.getData("exprType"));
                this.save(expression);
            }
        }
        catch (SemanticException e1) {
            this.text.setText(UIUtil.convertToGUIString(this.deValue == null ? null : this.deValue.getStringExpression()));
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.containerPane, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.containerPane.setVisible(isVisible);
    }
}

