/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PropertyNode {
    private transient ArrayList subNodes = null;
    private transient String id = null;
    private transient String nodeLabel = null;
    private transient Image nodeImage = null;
    private transient IPropertyPage page = null;
    private transient Control pageControl = null;

    public PropertyNode(String nodeId) {
        this.id = nodeId;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setNodeImage(Image labelImage) {
        this.nodeImage = labelImage;
    }

    public final void setNodeLabel(String labelText) {
        this.nodeLabel = labelText;
    }

    public final void setPage(IPropertyPage page) {
        assert (page != null) : " page is null";
        this.page = page;
    }

    public PropertyNode(String nodeId, String label) {
        this(nodeId);
        this.nodeLabel = label;
    }

    public PropertyNode(String nodeId, String label, Image image) {
        this(nodeId, label);
        this.nodeImage = image;
    }

    public PropertyNode(String nodeId, String label, Image image, IPropertyPage page) {
        this(nodeId, label, image);
        assert (page != null) : " page is null";
        this.page = page;
    }

    public final String getId() {
        return this.id;
    }

    public final String getNodeLabel() {
        if (this.nodeLabel == null) {
            return this.page.getName();
        }
        return this.nodeLabel;
    }

    public final Image getNodeImage() {
        return this.nodeImage;
    }

    public final IPropertyPage getPage() {
        return this.page;
    }

    public final void add(PropertyNode node) {
        assert (node != null) : "Null node cannot be added";
        if (this.subNodes == null) {
            this.subNodes = new ArrayList(5);
        }
        this.subNodes.add(node);
    }

    public final PropertyNode remove(String id) {
        assert (id != null) : "Null id passed";
        if (this.subNodes == null) {
            return null;
        }
        int n = 0;
        while (n < this.subNodes.size()) {
            PropertyNode subNode = (PropertyNode)this.subNodes.get(n);
            if (subNode.getId().equals(id)) {
                if (this.subNodes.remove(subNode)) {
                    return subNode;
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    public final PropertyNode getSubNode(String id) {
        assert (id != null) : "Null id passed";
        if (this.subNodes == null) {
            return null;
        }
        for (PropertyNode subNode : this.subNodes) {
            if (!subNode.getId().equals(id)) continue;
            return subNode;
        }
        return null;
    }

    public final PropertyNode[] getSubNodes() {
        if (this.subNodes == null) {
            return null;
        }
        return this.subNodes.toArray(new PropertyNode[0]);
    }

    public final Control createPageControl(Composite parent) {
        assert (parent != null) : "parent composite is null";
        this.pageControl = this.page.createPageControl(parent);
        assert (this.pageControl != null) : "The page returned a null control";
        return this.pageControl;
    }

    public void removePageControl() {
        this.pageControl = null;
    }

    public final Control getPageControl() {
        return this.pageControl;
    }

    public final boolean isPageControlCreated() {
        return this.pageControl != null;
    }

    public final boolean hasSubNodes() {
        return this.subNodes != null && this.subNodes.size() > 0;
    }

    public final void setContainer(IPropertyPageContainer container) {
        assert (this.page != null) : "There is no page present";
        this.page.setContainer(container);
    }
}

