/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.wizards.product.SynchronizationOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ProductLauncherFormPageHelper
implements ILauncherFormPageHelper {
    PDELauncherFormEditor fEditor;

    public ProductLauncherFormPageHelper(PDELauncherFormEditor editor) {
        this.fEditor = editor;
    }

    public Object getLaunchObject() {
        Object file = this.fEditor.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            return file;
        }
        return ((IProductModel)this.fEditor.getAggregateModel()).getUnderlyingResource();
    }

    public boolean isOSGi() {
        return false;
    }

    public void preLaunch() {
        this.handleSynchronize(false);
    }

    public void handleSynchronize(boolean alert) {
        block3: {
            try {
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                IProject project = this.fEditor.getCommonProject();
                SynchronizationOperation op = new SynchronizationOperation(this.getProduct(), this.fEditor.getSite().getShell(), project);
                service.runInUI((IRunnableContext)service, (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                if (!alert) break block3;
                MessageDialog.openError((Shell)this.fEditor.getSite().getShell(), (String)"Synchronize", (String)e.getTargetException().getMessage());
            }
        }
    }

    public IProduct getProduct() {
        IBaseModel model = this.fEditor.getAggregateModel();
        return ((IProductModel)model).getProduct();
    }
}

