/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFeatureContainersPage
extends EditDirectoryContainerPage {
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fIncludeVersionButton;
    private CheckboxTableViewer fFeatureTable;

    protected AddFeatureContainersPage() {
        super(null, "AddFeatureContainers");
    }

    @Override
    protected String getDefaultTitle() {
        return Messages.AddFeatureContainerPage_0;
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.AddFeatureContainerPage_1;
    }

    @Override
    protected void createLocationArea(Composite parent) {
        super.createLocationArea(parent);
        this.createTableArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.location_add_feature_wizard");
    }

    protected void createTableArea(Composite parent) {
        Composite tableComp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        SWTFactory.createLabel(tableComp, Messages.AddFeatureContainersPage_2, 2);
        this.fFeatureTable = CheckboxTableViewer.newCheckList((Composite)tableComp, (int)2048);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fFeatureTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeatureTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fFeatureTable.setSorter(new ViewerSorter());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        this.fFeatureTable.getControl().setLayoutData((Object)data);
        this.fFeatureTable.getControl().setFont(tableComp.getFont());
        this.fFeatureTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddFeatureContainersPage.this.checkStateChanged();
            }
        });
        this.fFeatureTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    AddFeatureContainersPage.this.fFeatureTable.setChecked(selection, !AddFeatureContainersPage.this.fFeatureTable.getChecked(selection));
                    AddFeatureContainersPage.this.checkStateChanged();
                }
            }
        });
        Composite buttonComp = SWTFactory.createComposite(tableComp, 1, 1, 1040, 0, 0);
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.AddFeatureContainersPage_0, null);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFeatureContainersPage.this.fFeatureTable.setAllChecked(true);
                AddFeatureContainersPage.this.checkStateChanged();
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.AddFeatureContainersPage_1, null);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFeatureContainersPage.this.fFeatureTable.setAllChecked(false);
                AddFeatureContainersPage.this.checkStateChanged();
            }
        });
        this.fIncludeVersionButton = SWTFactory.createCheckButton(tableComp, Messages.AddFeatureContainerPage_3, null, false, 2);
    }

    private void checkStateChanged() {
        if (this.fFeatureTable.getControl().isEnabled()) {
            int total;
            int count = this.fFeatureTable.getCheckedElements().length;
            this.fSelectAllButton.setEnabled(count != (total = ((Object[])this.fFeatureTable.getInput()).length));
            this.fDeselectAllButton.setEnabled(count != 0);
            this.setPageComplete(count > 0);
            this.setErrorMessage(count > 0 ? null : Messages.AddFeatureContainerPage_2);
        } else {
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            this.setPageComplete(false);
        }
    }

    @Override
    protected void containerChanged(long delay) {
        block9: {
            if (this.fInstallLocation.getText().trim().length() > 0) {
                try {
                    ArrayList<ExternalFeatureModel> result;
                    MultiStatus errors;
                    File featureDir;
                    String locationString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fInstallLocation.getText().trim());
                    File location = new File(locationString);
                    if (!location.isDirectory()) {
                        this.fFeatureTable.setInput((Object)new String[]{Messages.AddFeatureContainerPage_4});
                        this.setErrorMessage(Messages.AddDirectoryContainerPage_6);
                        break block9;
                    }
                    if (!location.getName().equalsIgnoreCase("features") && (featureDir = new File(location, "features")).isDirectory()) {
                        location = featureDir;
                    }
                    if ((errors = this.doLoadFeatures(result = new ArrayList<ExternalFeatureModel>(), location)) != null && errors.getChildren().length > 0) {
                        this.setErrorMessage(errors.getChildren()[0].getMessage());
                    } else {
                        this.setErrorMessage(null);
                    }
                    if (result.size() > 0) {
                        this.fFeatureTable.setInput((Object)result.toArray(new IFeatureModel[result.size()]));
                        this.fFeatureTable.getControl().setEnabled(true);
                        this.checkStateChanged();
                        this.setErrorMessage(null);
                        this.storeSettings();
                        break block9;
                    }
                    this.fFeatureTable.setInput((Object)new String[]{Messages.AddFeatureContainerPage_4});
                    this.fFeatureTable.getControl().setEnabled(false);
                    this.checkStateChanged();
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                    this.fFeatureTable.setInput((Object)new String[]{Messages.AddFeatureContainerPage_4});
                    this.fFeatureTable.getControl().setEnabled(false);
                    this.checkStateChanged();
                    this.setErrorMessage(e.getMessage());
                }
            } else {
                this.fFeatureTable.setInput((Object)new String[]{Messages.AddFeatureContainerPage_4});
                this.fFeatureTable.getControl().setEnabled(false);
                this.checkStateChanged();
                this.setPageComplete(false);
            }
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public ITargetLocation[] getBundleContainers() throws CoreException {
        Object[] elements = this.fFeatureTable.getCheckedElements();
        ArrayList<ITargetLocation> containers = new ArrayList<ITargetLocation>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IFeatureModel) {
                File location;
                String version = null;
                if (this.fIncludeVersionButton.getSelection()) {
                    version = ((IFeatureModel)elements[i]).getFeature().getVersion();
                }
                if ((location = new File(this.fInstallLocation.getText())).getName().equalsIgnoreCase("features")) {
                    location = location.getParentFile();
                }
                containers.add(AddFeatureContainersPage.getTargetPlatformService().newFeatureLocation(location.getPath(), ((IFeatureModel)elements[i]).getFeature().getId(), version));
            }
            ++i;
        }
        if (containers.size() == 0) {
            return null;
        }
        return containers.toArray(new ITargetLocation[containers.size()]);
    }

    private MultiStatus doLoadFeatures(List<ExternalFeatureModel> result, File path) {
        if (path == null) {
            return null;
        }
        File[] dirs = path.listFiles();
        if (dirs == null) {
            return null;
        }
        ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
        int i = 0;
        while (i < dirs.length) {
            IStatus status;
            File manifest;
            File dir = dirs[i];
            if (dir.isDirectory() && (manifest = new File(dir, "feature.xml")).exists() && (status = this.doLoadFeature(dir, manifest, result)) != null) {
                resultStatus.add(status);
            }
            ++i;
        }
        return new MultiStatus("org.eclipse.pde.ui", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), Messages.FeatureImportWizard_DetailedPage_problemsLoading, null);
    }

    private IStatus doLoadFeature(File dir, File manifest, List<ExternalFeatureModel> result) {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(dir.getAbsolutePath());
        Status status = null;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(manifest));
            model.load((InputStream)stream, false);
            if (!model.isValid()) {
                status = new Status(2, "org.eclipse.pde.ui", 0, NLS.bind((String)Messages.FeatureImportWizardPage_importHasInvalid, (Object)dir), null);
            }
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), (Throwable)e);
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (status == null) {
            result.add(model);
        }
        return status;
    }
}

