/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.launching.ILaunchingPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizeManifestsWizardPage
extends UserInputWizardPage
implements ILaunchingPreferenceConstants,
IOrganizeManifestsSettings {
    private Button fRemoveUnresolved;
    private Button fCalculateUses;
    private Button fAddMissing;
    private Button fMarkInternal;
    private Text fPackageFilter;
    private Label fPackageFilterLabel;
    private Button fRemoveImport;
    private Button fOptionalImport;
    private Button fModifyDependencies;
    private Button fUnusedDependencies;
    private Button fAdditonalDependencies;
    private Button fFixIconNLSPaths;
    private Button fRemovedUnusedKeys;
    private Button fRemoveLazy;
    private Button fRemoveUselessFiles;
    private Button[] fTopLevelButtons;
    private OrganizeManifestsProcessor fProcessor;
    private Set<?> fCustomProjects;
    private static String title = PDEUIMessages.OrganizeManifestsWizardPage_title;

    protected OrganizeManifestsWizardPage(Set<IProject> customProjects) {
        super(title);
        this.setTitle(title);
        this.setDescription(PDEUIMessages.OrganizeManifestsWizardPage_description);
        this.fCustomProjects = customProjects;
    }

    public void createControl(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 768);
        this.fProcessor = (OrganizeManifestsProcessor)((PDERefactor)this.getRefactoring()).getProcessor();
        if (!this.fCustomProjects.isEmpty()) {
            this.createCustomBuildWarning(container);
        }
        this.createExportedPackagesGroup(container);
        this.createRequireImportGroup(container);
        this.createGeneralGroup(container);
        this.createNLSGroup(container);
        this.setButtonArrays();
        this.presetOptions();
        this.hookListeners();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.organize_manifest");
        Dialog.applyDialogFont((Control)container);
    }

    private void createCustomBuildWarning(Composite container) {
        String message;
        Composite parent = SWTFactory.createComposite(container, 2, 1, 768);
        Label image = new Label(parent, 0);
        image.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        GridData gd = new GridData(32);
        image.setLayoutData((Object)gd);
        if (this.fCustomProjects.size() == 1) {
            message = NLS.bind((String)PDEUIMessages.OrganizeManifestsWizardPage_ProjectsUsingCustomBuildWarning, (Object)((IProject)this.fCustomProjects.iterator().next()).getName());
        } else {
            StringBuffer buf = new StringBuffer();
            Iterator<?> iterator = this.fCustomProjects.iterator();
            while (iterator.hasNext()) {
                IProject project = (IProject)iterator.next();
                buf.append(project.getName());
                if (!iterator.hasNext()) continue;
                buf.append(',').append(' ');
            }
            message = NLS.bind((String)PDEUIMessages.OrganizeManifestsWizardPage_ProjectsUsingCustomBuildWarningPlural, (Object)buf.toString());
        }
        Link link = new Link(parent, 64);
        link.setText(message);
        gd = new GridData(768);
        gd.widthHint = 200;
        link.setLayoutData((Object)gd);
    }

    private void createExportedPackagesGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_exportedGroup, 1, 1, 768);
        this.fAddMissing = new Button((Composite)group, 32);
        this.fAddMissing.setText(PDEUIMessages.OrganizeManifestsWizardPage_addMissing);
        this.fMarkInternal = new Button((Composite)group, 32);
        this.fMarkInternal.setText(PDEUIMessages.OrganizeManifestsWizardPage_markInternal);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fPackageFilterLabel = new Label(comp, 0);
        this.fPackageFilterLabel.setText(PDEUIMessages.OrganizeManifestsWizardPage_packageFilter);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.fPackageFilterLabel.setLayoutData((Object)gd);
        this.fPackageFilter = new Text(comp, 2048);
        this.fPackageFilter.setLayoutData((Object)new GridData(768));
        this.fRemoveUnresolved = new Button((Composite)group, 32);
        this.fRemoveUnresolved.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnresolved);
        gd = new GridData();
        gd.verticalIndent = 5;
        this.fRemoveUnresolved.setLayoutData((Object)gd);
        this.fCalculateUses = new Button((Composite)group, 32);
        this.fCalculateUses.setText(PDEUIMessages.OrganizeManifestsWizardPage_calculateUses);
        gd = new GridData();
        gd.verticalIndent = 5;
        this.fCalculateUses.setLayoutData((Object)gd);
    }

    private void createRequireImportGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_dependenciesGroup, 1, 1, 768);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fModifyDependencies = new Button(comp, 32);
        this.fModifyDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_unresolvedDependencies);
        this.fRemoveImport = new Button(comp, 16);
        this.fRemoveImport.setText(PDEUIMessages.OrganizeManifestsWizardPage_remove);
        this.fOptionalImport = new Button(comp, 16);
        this.fOptionalImport.setText(PDEUIMessages.OrganizeManifestsWizardPage_markOptional);
        this.fUnusedDependencies = new Button((Composite)group, 32);
        this.fUnusedDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnused);
        this.fAdditonalDependencies = new Button((Composite)group, 32);
        this.fAdditonalDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_addDependencies);
    }

    private void createGeneralGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_generalGroup, 1, 1, 768);
        this.fRemoveLazy = new Button((Composite)group, 32);
        this.fRemoveLazy.setText(PDEUIMessages.OrganizeManifestsWizardPage_lazyStart);
        this.fRemoveUselessFiles = new Button((Composite)group, 32);
        this.fRemoveUselessFiles.setText(PDEUIMessages.OrganizeManifestsWizardPage_uselessPluginFile);
    }

    private void createNLSGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_internationalizationGroup, 1, 1, 768);
        this.fFixIconNLSPaths = new Button((Composite)group, 32);
        this.fFixIconNLSPaths.setText(PDEUIMessages.OrganizeManifestsWizardPage_prefixNL);
        this.fRemovedUnusedKeys = new Button((Composite)group, 32);
        this.fRemovedUnusedKeys.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnusedKeys);
    }

    private void presetOptions() {
        IDialogSettings settings = this.getDialogSettings();
        boolean selection = !settings.getBoolean("OrganizeManifests.ExportedPackages.addMissing");
        this.fAddMissing.setSelection(selection);
        this.fProcessor.setAddMissing(selection);
        selection = !settings.getBoolean("OrganizeManifests.ExportedPackages.makeInternal");
        this.fMarkInternal.setSelection(selection);
        this.fProcessor.setMarkInternal(selection);
        String filter = settings.get("OrganizeManifests.ExportedPackages.packageFilter");
        if (filter == null) {
            filter = "*.internal*";
        }
        this.fPackageFilter.setText(filter);
        this.fProcessor.setPackageFilter(filter);
        selection = !settings.getBoolean("OrganizeManifests.ExportedPackages.removeUnresolved");
        this.fRemoveUnresolved.setSelection(selection);
        this.fProcessor.setRemoveUnresolved(selection);
        selection = settings.getBoolean("OrganizeManifests.calculateUses");
        this.fCalculateUses.setSelection(selection);
        this.fProcessor.setCalculateUses(selection);
        selection = !settings.getBoolean("OrganizeManifests.RequireImport.modifyDep");
        this.fModifyDependencies.setSelection(selection);
        this.fProcessor.setModifyDep(selection);
        selection = settings.getBoolean("OrganizeManifests.RequireImport.resolve:markOptional");
        this.fRemoveImport.setSelection(!selection);
        this.fOptionalImport.setSelection(selection);
        this.fProcessor.setRemoveDependencies(!selection);
        selection = settings.getBoolean("OrganizeManifests.RequireImport.findRemoveUnused");
        this.fUnusedDependencies.setSelection(selection);
        this.fProcessor.setUnusedDependencies(selection);
        selection = settings.getBoolean("OrganizeManifests.AddDependencies");
        this.fAdditonalDependencies.setSelection(selection);
        this.fProcessor.setAddDependencies(selection);
        selection = !settings.getBoolean("OrganizeManifests.General.cleanup");
        this.fRemoveLazy.setSelection(selection);
        this.fProcessor.setRemoveLazy(selection);
        selection = !settings.getBoolean("OrganizeManifests.General.cleanup.removeUselessFiles");
        this.fRemoveUselessFiles.setSelection(selection);
        this.fProcessor.setRemoveUselessFiles(selection);
        selection = settings.getBoolean("OrganizeManifests.Translation.nls");
        this.fFixIconNLSPaths.setSelection(selection);
        this.fProcessor.setPrefixIconNL(selection);
        selection = settings.getBoolean("OrganizeManifests.Translation.unusedKeys");
        this.fRemovedUnusedKeys.setSelection(selection);
        this.fProcessor.setUnusedKeys(selection);
        this.setEnabledStates();
        this.setPageComplete();
    }

    protected void performOk() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("OrganizeManifests.ExportedPackages.addMissing", !this.fAddMissing.getSelection());
        settings.put("OrganizeManifests.ExportedPackages.makeInternal", !this.fMarkInternal.getSelection());
        settings.put("OrganizeManifests.ExportedPackages.packageFilter", this.fPackageFilter.getText());
        settings.put("OrganizeManifests.ExportedPackages.removeUnresolved", !this.fRemoveUnresolved.getSelection());
        settings.put("OrganizeManifests.calculateUses", this.fCalculateUses.getSelection());
        settings.put("OrganizeManifests.RequireImport.modifyDep", !this.fModifyDependencies.getSelection());
        settings.put("OrganizeManifests.RequireImport.resolve:markOptional", this.fOptionalImport.getSelection());
        settings.put("OrganizeManifests.RequireImport.findRemoveUnused", this.fUnusedDependencies.getSelection());
        settings.put("OrganizeManifests.AddDependencies", this.fAdditonalDependencies.getSelection());
        settings.put("OrganizeManifests.General.cleanup", !this.fRemoveLazy.getSelection());
        settings.put("OrganizeManifests.General.cleanup.removeUselessFiles", !this.fRemoveUselessFiles.getSelection());
        settings.put("OrganizeManifests.Translation.nls", this.fFixIconNLSPaths.getSelection());
        settings.put("OrganizeManifests.Translation.unusedKeys", this.fRemovedUnusedKeys.getSelection());
    }

    private void setEnabledStates() {
        boolean markInternal = this.fMarkInternal.getSelection();
        this.fPackageFilter.setEnabled(markInternal);
        this.fPackageFilter.setEditable(markInternal);
        this.fPackageFilterLabel.setEnabled(markInternal);
        boolean modifyDependencies = this.fModifyDependencies.getSelection();
        this.fRemoveImport.setEnabled(modifyDependencies);
        this.fOptionalImport.setEnabled(modifyDependencies);
    }

    private void setButtonArrays() {
        this.fTopLevelButtons = new Button[]{this.fRemoveUnresolved, this.fAddMissing, this.fModifyDependencies, this.fMarkInternal, this.fUnusedDependencies, this.fAdditonalDependencies, this.fFixIconNLSPaths, this.fRemovedUnusedKeys, this.fRemoveLazy, this.fRemoveUselessFiles, this.fCalculateUses};
    }

    private void setPageComplete() {
        boolean pageComplete = false;
        int i = 0;
        while (i < this.fTopLevelButtons.length) {
            if (this.fTopLevelButtons[i].getSelection()) {
                pageComplete = true;
                break;
            }
            ++i;
        }
        this.setPageComplete(pageComplete);
    }

    private void hookListeners() {
        this.hookSelectionListener(new Button[]{this.fMarkInternal, this.fModifyDependencies}, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizeManifestsWizardPage.this.setEnabledStates();
                OrganizeManifestsWizardPage.this.doProcessorSetting(e.getSource());
            }
        });
        this.hookSelectionListener(this.fTopLevelButtons, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizeManifestsWizardPage.this.setPageComplete();
                OrganizeManifestsWizardPage.this.doProcessorSetting(e.getSource());
            }
        });
        this.hookSelectionListener(new Button[]{this.fRemoveImport, this.fOptionalImport}, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizeManifestsWizardPage.this.doProcessorSetting(e.getSource());
            }
        });
        this.hookTextListener(new Text[]{this.fPackageFilter}, new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OrganizeManifestsWizardPage.this.doProcessorSetting(e.getSource());
            }
        });
    }

    private void doProcessorSetting(Object source) {
        if (this.fProcessor == null) {
            return;
        }
        if (this.fAddMissing.equals(source)) {
            this.fProcessor.setAddMissing(this.fAddMissing.getSelection());
        } else if (this.fMarkInternal.equals(source)) {
            this.fProcessor.setMarkInternal(this.fMarkInternal.getSelection());
        } else if (this.fPackageFilter.equals(source)) {
            this.fProcessor.setPackageFilter(this.fPackageFilter.getText());
        } else if (this.fRemoveUnresolved.equals(source)) {
            this.fProcessor.setRemoveUnresolved(this.fRemoveUnresolved.getSelection());
        } else if (this.fCalculateUses.equals(source)) {
            this.fProcessor.setCalculateUses(this.fCalculateUses.getSelection());
        } else if (this.fModifyDependencies.equals(source)) {
            this.fProcessor.setModifyDep(this.fModifyDependencies.getSelection());
        } else if (this.fOptionalImport.equals(source)) {
            this.fProcessor.setRemoveDependencies(!this.fOptionalImport.getSelection());
        } else if (this.fRemoveImport.equals(source)) {
            this.fProcessor.setRemoveDependencies(this.fRemoveImport.getSelection());
        } else if (this.fUnusedDependencies.equals(source)) {
            this.fProcessor.setUnusedDependencies(this.fUnusedDependencies.getSelection());
        } else if (this.fAdditonalDependencies.equals(source)) {
            this.fProcessor.setAddDependencies(this.fAdditonalDependencies.getSelection());
        } else if (this.fRemoveLazy.equals(source)) {
            this.fProcessor.setRemoveLazy(this.fRemoveLazy.getSelection());
        } else if (this.fRemoveUselessFiles.equals(source)) {
            this.fProcessor.setRemoveUselessFiles(this.fRemoveUselessFiles.getSelection());
        } else if (this.fFixIconNLSPaths.equals(source)) {
            this.fProcessor.setPrefixIconNL(this.fFixIconNLSPaths.getSelection());
        } else if (this.fRemovedUnusedKeys.equals(source)) {
            this.fProcessor.setUnusedKeys(this.fRemovedUnusedKeys.getSelection());
        }
    }

    private void hookSelectionListener(Button[] buttons, SelectionAdapter adapter) {
        int i = 0;
        while (i < buttons.length) {
            buttons[i].addSelectionListener((SelectionListener)adapter);
            ++i;
        }
    }

    private void hookTextListener(Text[] texts, ModifyListener listener) {
        int i = 0;
        while (i < texts.length) {
            texts[i].addModifyListener(listener);
            ++i;
        }
    }
}

