/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.preferences;

import com.ibm.icu.text.Collator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.internal.ui.script.JSDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.script.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.script.JSSourceViewerConfiguration;
import org.eclipse.birt.report.designer.internal.ui.util.ColorHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.preferences.AbstractSyntaxColoringPage;
import org.eclipse.birt.report.designer.ui.preferences.OverlayPreferenceStore;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ExpressionSyntaxColoringPage
extends AbstractSyntaxColoringPage
implements IWorkbenchPreferencePage {
    private Button fBold;
    private Label fForegroundLabel;
    private Label fBackgroundLabel;
    private Button fClearStyle;
    private Map fContextToStyleMap;
    private Color fDefaultForeground = null;
    private Color fDefaultBackground = null;
    private IDocument fDocument;
    private ColorSelector fForegroundColorEditor;
    private ColorSelector fBackgroundColorEditor;
    private Button fItalic;
    private OverlayPreferenceStore fOverlayStore;
    private Button fStrike;
    private Collection fStylePreferenceKeys;
    private StructuredViewer fStylesViewer = null;
    private Map fStyleToDescriptionMap;
    private StyledText fText;
    private Button fUnderline;
    private ISourceViewer fPreviewViewer;
    private IPreferences preference;

    private void activate(String namedStyle) {
        Color foreground = this.fDefaultForeground;
        Color background = this.fDefaultBackground;
        if (namedStyle == null) {
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fItalic.setEnabled(false);
            this.fStrike.setEnabled(false);
            this.fUnderline.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
            this.fForegroundColorEditor.setEnabled(false);
            this.fBackgroundColorEditor.setEnabled(false);
            this.fBold.setSelection(false);
            this.fItalic.setSelection(false);
            this.fStrike.setSelection(false);
            this.fUnderline.setSelection(false);
        } else {
            TextAttribute attribute = this.getAttributeFor(namedStyle);
            this.fClearStyle.setEnabled(true);
            this.fBold.setEnabled(true);
            this.fItalic.setEnabled(true);
            this.fStrike.setEnabled(true);
            this.fUnderline.setEnabled(true);
            this.fForegroundLabel.setEnabled(true);
            this.fBackgroundLabel.setEnabled(true);
            this.fForegroundColorEditor.setEnabled(true);
            this.fBackgroundColorEditor.setEnabled(true);
            this.fBold.setSelection((attribute.getStyle() & 1) != 0);
            this.fItalic.setSelection((attribute.getStyle() & 2) != 0);
            this.fStrike.setSelection((attribute.getStyle() & 0x20000000) != 0);
            this.fUnderline.setSelection((attribute.getStyle() & 0x40000000) != 0);
            if (attribute.getForeground() != null) {
                foreground = attribute.getForeground();
            }
            if (attribute.getBackground() != null) {
                background = attribute.getBackground();
            }
        }
        this.fForegroundColorEditor.setColorValue(foreground.getRGB());
        this.fBackgroundColorEditor.setColorValue(background.getRGB());
    }

    void applyStyles() {
        if (this.fText == null || this.fText.isDisposed()) {
            return;
        }
        try {
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)"__dftl_partitioning", (int)0, (int)this.fDocument.getLength(), (boolean)true);
            if (regions.length > 0) {
                int i = 0;
                while (i < regions.length) {
                    TextAttribute attribute;
                    ITypedRegion region = regions[i];
                    String namedStyle = (String)this.fContextToStyleMap.get(region.getType());
                    if (namedStyle != null && (attribute = this.getAttributeFor(namedStyle)) != null) {
                        int fontStyle = attribute.getStyle() & 3;
                        StyleRange style = new StyleRange(region.getOffset(), region.getLength(), attribute.getForeground(), attribute.getBackground(), fontStyle);
                        style.strikeout = (attribute.getStyle() & 0x20000000) != 0;
                        style.underline = (attribute.getStyle() & 0x40000000) != 0;
                        style.font = attribute.getFont();
                        this.fText.setStyleRange(style);
                    }
                    ++i;
                }
            }
        }
        catch (BadLocationException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(final Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fDefaultForeground = UIUtil.getEclipseEditorForeground();
        this.fDefaultBackground = UIUtil.getEclipseEditorBackground();
        Composite pageComponent = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.birt.cshelp.Preference_BIRT_ExpressionSyntaxColor_ID");
        Link link = new Link(pageComponent, 64);
        link.setText(Messages.getString((String)"ExpressionSyntaxColoringPage.Link.ColorAndFont"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData linkData = new GridData(4, 1, true, false, 2, 1);
        linkData.widthHint = 150;
        link.setLayoutData((Object)linkData);
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        SashForm editor = new SashForm(pageComponent, 512);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.horizontalSpan = 2;
        editor.setLayoutData((Object)gridData2);
        SashForm top = new SashForm((Composite)editor, 256);
        Composite styleEditor = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginRight = 5;
        ((GridLayout)styleEditor.getLayout()).marginLeft = 0;
        this.createLabel(styleEditor, Messages.getString((String)"ExpressionSyntaxColoringPage.Label.SyntaxElement"));
        this.fStylesViewer = this.createStylesViewer(styleEditor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 0;
        Iterator iterator = this.fStyleToDescriptionMap.values().iterator();
        while (iterator.hasNext()) {
            gridData.widthHint = Math.max(gridData.widthHint, this.convertWidthInCharsToPixels(iterator.next().toString().length()));
        }
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.fStylesViewer.getControl().setLayoutData((Object)gridData);
        Composite editingComposite = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginLeft = 5;
        this.createLabel(editingComposite, "");
        Button enabler = this.createCheckbox(editingComposite, Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Enable"));
        enabler.setEnabled(false);
        enabler.setSelection(true);
        Composite editControls = this.createComposite(editingComposite, 2);
        ((GridLayout)editControls.getLayout()).marginLeft = 20;
        this.fForegroundLabel = this.createLabel(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Label.Foreground"));
        ((GridData)this.fForegroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fForegroundLabel.setEnabled(false);
        this.fForegroundColorEditor = new ColorSelector(editControls);
        Button fForegroundColor = this.fForegroundColorEditor.getButton();
        GridData gd = new GridData(1, 4, false, false);
        fForegroundColor.setLayoutData((Object)gd);
        this.fForegroundColorEditor.setEnabled(false);
        this.fForegroundColorEditor.getButton().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString((String)"ExpressionSyntaxColoringPage.Accessible.Name.Foreground");
            }
        });
        this.fBackgroundLabel = this.createLabel(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Label.Background"));
        ((GridData)this.fBackgroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fBackgroundLabel.setEnabled(false);
        this.fBackgroundColorEditor = new ColorSelector(editControls);
        Button fBackgroundColor = this.fBackgroundColorEditor.getButton();
        gd = new GridData(1, 4, false, false);
        fBackgroundColor.setLayoutData((Object)gd);
        this.fBackgroundColorEditor.setEnabled(false);
        this.fBackgroundColorEditor.getButton().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString((String)"ExpressionSyntaxColoringPage.Accessible.Name.Background");
            }
        });
        this.fBold = this.createCheckbox(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Bold"));
        this.fBold.setEnabled(false);
        ((GridData)this.fBold.getLayoutData()).horizontalSpan = 2;
        this.fItalic = this.createCheckbox(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Italic"));
        this.fItalic.setEnabled(false);
        ((GridData)this.fItalic.getLayoutData()).horizontalSpan = 2;
        this.fStrike = this.createCheckbox(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Strikethrough"));
        this.fStrike.setEnabled(false);
        ((GridData)this.fStrike.getLayoutData()).horizontalSpan = 2;
        this.fUnderline = this.createCheckbox(editControls, Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Underline"));
        this.fUnderline.setEnabled(false);
        ((GridData)this.fUnderline.getLayoutData()).horizontalSpan = 2;
        this.fClearStyle = new Button(editingComposite, 8);
        this.fClearStyle.setText(Messages.getString((String)"ExpressionSyntaxColoringPage.Button.Restore"));
        this.fClearStyle.setLayoutData((Object)new GridData(1));
        ((GridData)this.fClearStyle.getLayoutData()).horizontalIndent = 20;
        this.fClearStyle.setEnabled(false);
        Composite sampleArea = this.createComposite((Composite)editor, 1);
        ((GridLayout)sampleArea.getLayout()).marginLeft = 5;
        ((GridLayout)sampleArea.getLayout()).marginTop = 5;
        this.createLabel(sampleArea, Messages.getString((String)"ExpressionSyntaxColoringPage.Label.SampleText"));
        this.fPreviewViewer = new SourceViewer(sampleArea, null, 33557258);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new JSSourceViewerConfiguration());
        this.fText = this.fPreviewViewer.getTextWidget();
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.widthHint = this.convertWidthInCharsToPixels(20);
        gridData3.heightHint = this.convertHeightInCharsToPixels(5);
        gridData3.horizontalSpan = 2;
        this.fText.setLayoutData((Object)gridData3);
        this.fText.setEditable(false);
        this.fText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, Messages.getString((String)"ExpressionSyntaxColoringPage.Label.SampleText"));
        JSEditorInput editorInput = new JSEditorInput(this.loadPreviewContentFromFile());
        JSDocumentProvider documentProvider = new JSDocumentProvider();
        try {
            documentProvider.connect((Object)editorInput);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.fDocument = documentProvider.getDocument((Object)editorInput);
        this.initializeSourcePreviewColors(this.fPreviewViewer);
        this.fPreviewViewer.setDocument(this.fDocument);
        top.setWeights(new int[]{1, 1});
        editor.setWeights(new int[]{1, 1});
        this.fStylesViewer.setInput((Object)this.getStylePreferenceKeys());
        this.applyStyles();
        this.fStylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    ExpressionSyntaxColoringPage.this.activate(namedStyle);
                    if (namedStyle == null) {
                        return;
                    }
                }
            }
        });
        this.fForegroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[0];
                        String newValue = ColorHelper.toRGBString((RGB)ExpressionSyntaxColoringPage.this.fForegroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[0] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            ExpressionSyntaxColoringPage.this.applyStyles();
                            ExpressionSyntaxColoringPage.this.fText.redraw();
                        }
                    }
                }
            }
        });
        this.fBackgroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[1];
                        String newValue = ColorHelper.toRGBString((RGB)ExpressionSyntaxColoringPage.this.fBackgroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[1] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            ExpressionSyntaxColoringPage.this.applyStyles();
                            ExpressionSyntaxColoringPage.this.fText.redraw();
                            ExpressionSyntaxColoringPage.this.activate(namedStyle);
                        }
                    }
                }
            }
        });
        this.fBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[2];
                    String newValue = String.valueOf(ExpressionSyntaxColoringPage.this.fBold.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[2] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        ExpressionSyntaxColoringPage.this.applyStyles();
                        ExpressionSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[3];
                    String newValue = String.valueOf(ExpressionSyntaxColoringPage.this.fItalic.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[3] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        ExpressionSyntaxColoringPage.this.applyStyles();
                        ExpressionSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fStrike.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[4];
                    String newValue = String.valueOf(ExpressionSyntaxColoringPage.this.fStrike.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[4] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        ExpressionSyntaxColoringPage.this.applyStyles();
                        ExpressionSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fUnderline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = ExpressionSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[5];
                    String newValue = String.valueOf(ExpressionSyntaxColoringPage.this.fUnderline.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[5] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        ExpressionSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        ExpressionSyntaxColoringPage.this.applyStyles();
                        ExpressionSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fClearStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection().isEmpty()) {
                    return;
                }
                String namedStyle = ((IStructuredSelection)ExpressionSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement().toString();
                ExpressionSyntaxColoringPage.this.getOverlayStore().setToDefault(namedStyle);
                ExpressionSyntaxColoringPage.this.applyStyles();
                ExpressionSyntaxColoringPage.this.fText.redraw();
                ExpressionSyntaxColoringPage.this.activate(namedStyle);
            }
        });
        return pageComponent;
    }

    private String loadPreviewContentFromFile() {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ColorSettingPreviewCode.txt")));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        label.setBackground(parent.getBackground());
        return label;
    }

    protected ISourceViewer getSourcePreviewViewer() {
        return this.fPreviewViewer;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator i = this.getStylePreferenceKeys().iterator();
        while (i.hasNext()) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, (String)i.next()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private StructuredViewer createStylesViewer(Composite parent) {
        ListViewer stylesViewer = new ListViewer(parent, 2820);
        stylesViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object description = ExpressionSyntaxColoringPage.this.fStyleToDescriptionMap.get(element);
                if (description != null) {
                    return description.toString();
                }
                return super.getText(element);
            }
        });
        stylesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return ExpressionSyntaxColoringPage.this.getStylePreferenceKeys().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return ExpressionSyntaxColoringPage.this.getStylePreferenceKeys();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        return stylesViewer;
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
        }
        super.dispose();
    }

    private TextAttribute getAttributeFor(String namedStyle) {
        String prefString;
        String[] stylePrefs;
        TextAttribute ta = new TextAttribute(this.fDefaultForeground, this.fDefaultBackground, 0);
        if (namedStyle != null && this.fOverlayStore != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getOverlayStore().getString(namedStyle)))) != null) {
            boolean on;
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            int fontModifier = 0;
            if (stylePrefs.length > 2 && (on = Boolean.valueOf(stylePrefs[2]).booleanValue())) {
                fontModifier |= 1;
            }
            if (stylePrefs.length > 3 && (on = Boolean.valueOf(stylePrefs[3]).booleanValue())) {
                fontModifier |= 2;
            }
            if (stylePrefs.length > 4 && (on = Boolean.valueOf(stylePrefs[4]).booleanValue())) {
                fontModifier |= 0x20000000;
            }
            if (stylePrefs.length > 5 && (on = Boolean.valueOf(stylePrefs[5]).booleanValue())) {
                fontModifier |= 0x40000000;
            }
            ta = new TextAttribute(foreground != null ? ColorManager.getColor((RGB)foreground) : null, background != null ? ColorManager.getColor((RGB)background) : null, fontModifier);
        }
        return ta;
    }

    private String getNamedStyleAtOffset(int offset) {
        if (offset >= this.fDocument.getLength()) {
            return this.getNamedStyleAtOffset(this.fDocument.getLength() - 1);
        }
        if (offset < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        try {
            String regionContext = this.fDocument.getPartition(offset).getType();
            String namedStyle = (String)this.fContextToStyleMap.get(regionContext);
            if (namedStyle != null) {
                return namedStyle;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    private Collection getStylePreferenceKeys() {
        if (this.fStylePreferenceKeys == null) {
            ArrayList<String> styles = new ArrayList<String>();
            styles.add("org.eclipse.birt.report.designer.ui.preference.expression.content.color.preferencestore");
            styles.add("org.eclipse.birt.report.designer.ui.preference.expression.comment.color.preferencestore");
            styles.add("org.eclipse.birt.report.designer.ui.preference.expression.keyword.color.preferencestore");
            styles.add("org.eclipse.birt.report.designer.ui.preference.expression.string.color.preferencestore");
            this.fStylePreferenceKeys = styles;
        }
        return this.fStylePreferenceKeys;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    ExpressionSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    ExpressionSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    ExpressionSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExpressionSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                ExpressionSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.widget instanceof StyledText && (e.detail == 16 || e.detail == 8)) {
                    e.doit = true;
                }
            }
        };
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.getString((String)"ExpressionSyntaxColoringPage.Decscription"));
        this.fStyleToDescriptionMap = new HashMap();
        this.fContextToStyleMap = new HashMap();
        this.initStyleToDescriptionMap();
        this.initRegionContextToStyleMap();
        this.preference = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportPlugin.getDefault());
        this.fOverlayStore = new OverlayPreferenceStore(this.preference, this.createOverlayStoreKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    private void initRegionContextToStyleMap() {
        this.fContextToStyleMap.put("__dftl_partition_content_type", "org.eclipse.birt.report.designer.ui.preference.expression.content.color.preferencestore");
        this.fContextToStyleMap.put("__js_comment", "org.eclipse.birt.report.designer.ui.preference.expression.comment.color.preferencestore");
        this.fContextToStyleMap.put("__js_keyword", "org.eclipse.birt.report.designer.ui.preference.expression.keyword.color.preferencestore");
        this.fContextToStyleMap.put("__js_string", "org.eclipse.birt.report.designer.ui.preference.expression.string.color.preferencestore");
    }

    private void initStyleToDescriptionMap() {
        this.fStyleToDescriptionMap.put("org.eclipse.birt.report.designer.ui.preference.expression.content.color.preferencestore", Messages.getString((String)"ExpressionSyntaxColoringPage.Element.Default"));
        this.fStyleToDescriptionMap.put("org.eclipse.birt.report.designer.ui.preference.expression.comment.color.preferencestore", Messages.getString((String)"ExpressionSyntaxColoringPage.Element.Comment"));
        this.fStyleToDescriptionMap.put("org.eclipse.birt.report.designer.ui.preference.expression.keyword.color.preferencestore", Messages.getString((String)"ExpressionSyntaxColoringPage.Element.Keyword"));
        this.fStyleToDescriptionMap.put("org.eclipse.birt.report.designer.ui.preference.expression.string.color.preferencestore", Messages.getString((String)"ExpressionSyntaxColoringPage.Element.String"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getOverlayStore().loadDefaults();
        this.applyStyles();
        this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.activate(null);
        this.fText.redraw();
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        if (this.preference != null) {
            try {
                this.preference.save();
            }
            catch (IOException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    private void selectColorAtOffset(int offset) {
        String namedStyle = this.getNamedStyleAtOffset(offset);
        if (namedStyle != null) {
            this.fStylesViewer.setSelection((ISelection)new StructuredSelection((Object)namedStyle));
            this.fStylesViewer.reveal((Object)namedStyle);
        } else {
            this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.activate(namedStyle);
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }
}

