/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.style;

import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.w3c.dom.css.CSSValue;

public class StyleBuilder {
    public static final String C_PATTERN = "(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)";
    public static final Pattern colorp = Pattern.compile("(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)", 2);
    private static final Set<Integer> NON_INHERITABLE_PROPS;
    private static Logger logger;

    static {
        logger = Logger.getLogger(StyleBuilder.class.getName());
        HashSet<Integer> props = new HashSet<Integer>();
        int i = 10;
        while (i <= 21) {
            props.add(i);
            ++i;
        }
        i = 29;
        while (i <= 34) {
            props.add(i);
            ++i;
        }
        i = 51;
        while (i <= 56) {
            props.add(i);
            ++i;
        }
        NON_INHERITABLE_PROPS = Collections.unmodifiableSet(props);
    }

    public static StyleEntry createStyleEntry(IStyle style, int type) {
        return StyleBuilder.createStyleEntry(style, type, null);
    }

    public static StyleEntry createStyleEntry(IStyle style, StyleEntry parent) {
        return StyleBuilder.createStyleEntry(style, parent.getType());
    }

    public static StyleEntry createStyleEntry(IStyle style, int type, StyleEntry parent) {
        StyleEntry entry = new StyleEntry(style, type);
        StyleBuilder.populateColor(style, 8, entry, 6);
        CSSValue borderWidth = style.getProperty(11);
        int width = PropertyUtil.getDimensionValue(borderWidth);
        if (width > 0) {
            StyleBuilder.populateColor(style, 15, entry, 10);
            entry.setProperty(11, style.getBorderBottomStyle());
            entry.setProperty(12, borderWidth);
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(41))) > 0) {
            StyleBuilder.populateColor(style, 13, entry, 13);
            entry.setProperty(14, style.getBorderTopStyle());
            entry.setProperty(15, borderWidth);
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(42))) > 0) {
            StyleBuilder.populateColor(style, 46, entry, 16);
            entry.setProperty(17, style.getBorderLeftStyle());
            entry.setProperty(18, borderWidth);
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(10))) > 0) {
            StyleBuilder.populateColor(style, 14, entry, 19);
            entry.setProperty(20, style.getBorderRightStyle());
            entry.setProperty(21, borderWidth);
        }
        StyleBuilder.populateColor(style, 0, entry, 7);
        entry.setProperty(0, OdfUtil.getValue(style.getFontFamily()));
        entry.setProperty(1, StyleBuilder.convertFontSize(style.getProperty(39)));
        entry.setProperty(2, "italic".equalsIgnoreCase(style.getFontStyle()));
        entry.setProperty(3, style.getFontWeight());
        entry.setProperty(4, "line-through".equalsIgnoreCase(style.getTextLineThrough()));
        entry.setProperty(5, "underline".equalsIgnoreCase(style.getTextUnderline()));
        entry.setProperty(59, "overline".equalsIgnoreCase(style.getTextOverline()));
        entry.setProperty(8, StyleBuilder.convertHAlign(style.getTextAlign(), style.getDirection()));
        entry.setProperty(9, StyleBuilder.convertVAlign(parent, style.getVerticalAlign()));
        entry.setProperty(22, style.getDateFormat());
        entry.setProperty(23, style.getNumberFormat());
        entry.setProperty(24, style.getStringFormat());
        entry.setProperty(26, style.getTextTransform());
        entry.setProperty(27, style.getDirection());
        entry.setProperty(28, style.getWhiteSpace());
        entry.setProperty(38, style.getProperty(6));
        entry.setProperty(39, style.getProperty(18));
        entry.setProperty(40, style.getProperty(3));
        entry.setProperty(41, style.getProperty(4));
        entry.setProperty(42, style.getProperty(19));
        entry.setProperty(43, style.getProperty(31));
        entry.setProperty(44, style.getProperty(16));
        entry.setProperty(45, style.getProperty(17));
        entry.setProperty(46, style.getProperty(2));
        entry.setProperty(47, style.getProperty(44));
        entry.setProperty(65, style.getProperty(20));
        String imageUri = style.getBackgroundImage();
        if (imageUri != null && imageUri.length() > 0 && !"none".equals(imageUri)) {
            entry.setProperty(51, style.getBackgroundImage());
            entry.setProperty(52, style.getBackgroundWidth());
            entry.setProperty(53, style.getBackgroundHeight());
            entry.setProperty(54, style.getBackgroundPositionX());
            entry.setProperty(55, style.getBackgroundPositionY());
            entry.setProperty(56, style.getBackgroundRepeat());
        }
        return entry;
    }

    public static StyleEntry createEmptyStyleEntry(int type) {
        StyleEntry entry = new StyleEntry(type);
        return entry;
    }

    public static StyleEntry applyDiagonalLine(StyleEntry entry, Color color, String style, int width) {
        if (width > 0) {
            entry.setProperty(29, color);
            entry.setProperty(30, style);
            entry.setProperty(31, width);
        }
        return entry;
    }

    private static void populateColor(IStyle style, int styleIndex, StyleEntry entry, int index) {
        CSSValue value = style.getProperty(styleIndex);
        if (value != null && !"transparent".equals(value.getCssText()) && !"auto".equals(value.getCssText())) {
            entry.setProperty(index, value.getCssText());
        }
    }

    public static Integer convertFontSize(CSSValue fontSize) {
        int size = PropertyUtil.getDimensionValue(fontSize);
        Integer fsize = null;
        try {
            fsize = size / 1000;
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return fsize;
    }

    public static String convertHAlign(String align, String direction) {
        if ((align = OdfUtil.getValue(align)) == null || "NULL".equals(align)) {
            if ("rtl".equals(direction)) {
                return "end";
            }
            return "start";
        }
        if ("left".equals(align)) {
            return "start";
        }
        if ("right".equals(align)) {
            return "end";
        }
        return align;
    }

    public static String convertVAlign(StyleEntry parent, String align) {
        if ((align = OdfUtil.getValue(align)) == null) {
            return "auto";
        }
        return align;
    }

    public static boolean isHeritable(int id) {
        return !NON_INHERITABLE_PROPS.contains(id);
    }

    public static void mergeInheritableProp(StyleEntry cEntry, StyleEntry entry) {
        int i = 0;
        while (i < 66) {
            if (StyleBuilder.isHeritable(i) && StyleEntry.isNull(entry.getProperty(i))) {
                entry.setProperty(i, cEntry.getProperty(i));
            }
            ++i;
        }
    }

    public static void applyRightBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 19);
        StyleBuilder.overwriteProp(cEntry, entry, 20);
        StyleBuilder.overwriteProp(cEntry, entry, 21);
    }

    public static void applyLeftBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 16);
        StyleBuilder.overwriteProp(cEntry, entry, 17);
        StyleBuilder.overwriteProp(cEntry, entry, 18);
    }

    public static void applyTopBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 13);
        StyleBuilder.overwriteProp(cEntry, entry, 14);
        StyleBuilder.overwriteProp(cEntry, entry, 15);
    }

    public static boolean applyBottomBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return false;
        }
        boolean isChanged = false;
        isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 10);
        isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 11);
        return isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 12);
    }

    private static boolean overwriteProp(StyleEntry cEntry, StyleEntry entry, int id) {
        if (StyleEntry.isNull(entry.getProperty(id))) {
            Object property = cEntry.getProperty(id);
            if (property != null) {
                entry.setProperty(id, property);
                return true;
            }
            return false;
        }
        return false;
    }
}

