/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.mongodb.BasicDBList;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.BSONTimestamp;
import org.eclipse.birt.data.oda.mongodb.impl.MDbQuery;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.internal.impl.ResultDataHandler;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.impl.Blob;

public class MDbResultSet
implements IResultSet {
    private Iterator<DBObject> m_resultsIterator;
    private DBCursor m_mongoCursor;
    private MDbResultSetMetaData m_metadata;
    private QueryProperties m_queryProps;
    private DBObject m_currentRow;
    private int m_currentRowId = 0;
    private int m_maxRows = 0;
    private boolean m_wasNull = true;
    private ResultDataHandler m_dataHandler;
    private static Logger sm_logger = DriverUtil.getLogger();

    public MDbResultSet(Iterator<DBObject> resultsIterator, MDbResultSetMetaData rsmd, QueryProperties queryProps) {
        if (resultsIterator == null || rsmd == null) {
            throw new IllegalArgumentException("null DBCursor");
        }
        this.m_resultsIterator = resultsIterator;
        if (resultsIterator instanceof DBCursor) {
            this.m_mongoCursor = (DBCursor)resultsIterator;
        }
        this.m_metadata = rsmd;
        QueryProperties queryProperties = this.m_queryProps = queryProps != null ? queryProps : QueryProperties.defaultValues();
        if (this.projectsFlattenedRows()) {
            this.m_dataHandler = new ResultDataHandler(this.m_metadata);
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.m_metadata;
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
        if (this.m_maxRows > 0 && this.m_mongoCursor != null) {
            this.m_mongoCursor.limit(this.m_maxRows);
        }
    }

    protected int getMaxRows() {
        return this.m_maxRows >= 0 ? this.m_maxRows : 0;
    }

    private boolean hasNoMaxLimit() {
        return this.m_maxRows <= 0;
    }

    private boolean projectsFlattenedRows() {
        return this.m_queryProps.isAutoFlattening();
    }

    public boolean next() throws OdaException {
        if (this.projectsFlattenedRows() && this.m_dataHandler != null && this.m_dataHandler.next()) {
            return true;
        }
        this.m_currentRow = null;
        if (this.m_resultsIterator == null || !this.m_resultsIterator.hasNext()) {
            return false;
        }
        if (this.hasNoMaxLimit() || this.m_currentRowId < this.getMaxRows()) {
            this.m_currentRow = this.m_resultsIterator.next();
            ++this.m_currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.m_currentRow = null;
        this.m_currentRowId = 0;
        this.m_resultsIterator = null;
        if (this.m_mongoCursor != null) {
            this.m_mongoCursor.close();
            this.m_mongoCursor = null;
        }
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        return this.getString(this.findFieldName(index));
    }

    public String getString(String columnName) throws OdaException {
        List fromList;
        Object columnValue = this.getFieldValue(columnName);
        if (columnValue instanceof String) {
            return (String)columnValue;
        }
        if (columnValue instanceof List && !(columnValue instanceof BasicDBList) && !(fromList = (List)columnValue).isEmpty()) {
            BasicDBList fieldValuesList = new BasicDBList();
            int index = 0;
            while (index < fromList.size()) {
                fieldValuesList.put(index, fromList.get(index));
                ++index;
            }
            fieldValuesList.markAsPartialObject();
            return fieldValuesList.toString();
        }
        return columnValue != null ? columnValue.toString() : null;
    }

    public int getInt(int index) throws OdaException {
        return this.getInt(this.findFieldName(index));
    }

    public int getInt(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Integer.class)) instanceof Integer) {
            return (Integer)columnValue;
        }
        if (columnValue instanceof List) {
            return (Integer)this.getFirstFieldValue((List)columnValue, Integer.class, columnName);
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get int value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return 0;
    }

    public double getDouble(int index) throws OdaException {
        return this.getDouble(this.findFieldName(index));
    }

    public double getDouble(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Double.class)) instanceof Double) {
            return (Double)columnValue;
        }
        if (columnValue instanceof List) {
            return (Double)this.getFirstFieldValue((List)columnValue, Double.class, columnName);
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get double value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.getBigDecimal(this.findFieldName(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, BigDecimal.class)) instanceof BigDecimal) {
            return (BigDecimal)columnValue;
        }
        if (columnValue instanceof List) {
            return (BigDecimal)this.getFirstFieldValue((List)columnValue, BigDecimal.class, columnName);
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get BigDecimal value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return null;
    }

    public Date getDate(int index) throws OdaException {
        return this.getDate(this.findFieldName(index));
    }

    public Date getDate(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Date.class)) instanceof Date) {
            return (Date)columnValue;
        }
        if (columnValue instanceof List) {
            return MDbResultSet.convertToSqlDate((java.util.Date)this.getFirstFieldValue((List)columnValue, java.util.Date.class, columnName));
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get Date value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return null;
    }

    private static Date convertToSqlDate(java.util.Date utilDateValue) {
        if (utilDateValue == null) {
            return null;
        }
        return new Date(utilDateValue.getTime());
    }

    public Time getTime(int index) throws OdaException {
        return this.getTime(this.findFieldName(index));
    }

    public Time getTime(String columnName) throws OdaException {
        Date dateValue = this.getDate(columnName);
        if (dateValue == null) {
            return null;
        }
        return new Time(dateValue.getTime());
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.getTimestamp(this.findFieldName(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Timestamp.class)) instanceof Timestamp) {
            return (Timestamp)columnValue;
        }
        if (columnValue instanceof BSONTimestamp) {
            return MDbResultSet.convertToSqlTimestamp((BSONTimestamp)columnValue);
        }
        if (columnValue instanceof List) {
            return MDbResultSet.convertToSqlTimestamp((BSONTimestamp)this.getFirstFieldValue((List)columnValue, BSONTimestamp.class, columnName));
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get Timestamp value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return null;
    }

    private static Timestamp convertToSqlTimestamp(BSONTimestamp ts) {
        if (ts == null) {
            return null;
        }
        return new Timestamp((long)ts.getTime() * 1000L);
    }

    public IBlob getBlob(int index) throws OdaException {
        return this.getBlob(this.findFieldName(index));
    }

    public IBlob getBlob(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if (columnValue instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, byte[].class, columnName);
        }
        if (columnValue instanceof byte[]) {
            return new Blob((byte[])columnValue);
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get IBlob value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return null;
    }

    public IClob getClob(int index) throws OdaException {
        throw MDbQuery.sm_unSupportedOpEx;
    }

    public IClob getClob(String columnName) throws OdaException {
        throw MDbQuery.sm_unSupportedOpEx;
    }

    public boolean getBoolean(int index) throws OdaException {
        return this.getBoolean(this.findFieldName(index));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Boolean.class)) instanceof Boolean) {
            return (Boolean)columnValue;
        }
        if (columnValue instanceof List) {
            return (Boolean)this.getFirstFieldValue((List)columnValue, Boolean.class, columnName);
        }
        if (columnValue != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get boolean value from the {0} field, whose fetched value is of {1} data type.", (Object)columnName, (Object)columnValue.getClass().getSimpleName()));
        }
        return false;
    }

    public Object getObject(int index) throws OdaException {
        return this.getObject(this.findFieldName(index));
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getFieldValue(columnName);
    }

    public boolean wasNull() throws OdaException {
        return this.m_wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        return this.m_metadata.getColumnNumber(columnName);
    }

    private String findFieldName(int columnNumber) throws OdaException {
        return this.getMetaData().getColumnName(columnNumber);
    }

    private Object getFieldValue(String columnName) throws OdaException {
        Object fieldValue = this.doGetFieldValue(columnName);
        this.m_wasNull = fieldValue == null;
        return fieldValue;
    }

    private Object doGetFieldValue(String columnName) throws OdaException {
        if (!this.projectsFlattenedRows()) {
            MDbMetaData.FieldMetaData fieldMD = this.m_metadata.getColumnMetaData(columnName);
            return ResultDataHandler.fetchFieldValues(columnName, fieldMD, this.m_currentRow);
        }
        return this.m_dataHandler.getFieldValue(columnName, this.m_currentRow);
    }

    private Object getFirstFieldValue(List<?> valuesList, Class<?> valueDataType, String logColumnName) {
        Object value = MDbResultSet.getFirstElementFromList(valuesList, logColumnName);
        if (valueDataType.isInstance(value)) {
            return value;
        }
        if (value instanceof List) {
            return this.getFirstFieldValue((List)value, valueDataType, logColumnName);
        }
        this.m_wasNull = true;
        return null;
    }

    private static Object getFirstElementFromList(List<?> valuesList, String columnName) {
        if (valuesList.size() == 0) {
            return null;
        }
        Object firstValue = null;
        firstValue = valuesList instanceof BasicDBList ? ((BasicDBList)valuesList).get(String.valueOf(0)) : (Object)valuesList.get(0);
        MDbResultSet.logFetchedFirstElementFromArray(columnName, valuesList.size());
        return firstValue;
    }

    private static Object tryConvertToDataType(Object value, Class<?> valueDataType) throws OdaException {
        if (value == null || valueDataType.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                if (valueDataType == Integer.class) {
                    return Integer.valueOf(stringValue);
                }
                if (valueDataType == Double.class) {
                    return Double.valueOf(stringValue);
                }
                if (valueDataType == BigDecimal.class) {
                    return new BigDecimal(stringValue);
                }
                if (valueDataType == Boolean.class) {
                    return Boolean.valueOf(stringValue);
                }
                if (valueDataType == Date.class) {
                    return Date.valueOf(stringValue);
                }
                if (valueDataType == Timestamp.class) {
                    return Timestamp.valueOf(stringValue);
                }
            }
            catch (NumberFormatException ex) {
                throw new OdaException((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw new OdaException((Throwable)ex);
            }
        }
        if (value instanceof java.util.Date) {
            java.util.Date utilDateValue = (java.util.Date)value;
            if (valueDataType == Date.class) {
                return MDbResultSet.convertToSqlDate(utilDateValue);
            }
            if (valueDataType == Timestamp.class) {
                return new Timestamp(utilDateValue.getTime());
            }
        }
        return value;
    }

    private static void logFetchedFirstElementFromArray(String columnName, int arraySize) {
        if (arraySize > 1 && MDbResultSet.getLogger().isLoggable(Level.FINER)) {
            MDbResultSet.getLogger().finer(Messages.bind((String)"Fetching only the first value out of {0} for the field {1}.", (Object)arraySize, (Object)columnName));
        }
    }

    private static Logger getLogger() {
        return sm_logger;
    }
}

