/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.impl.internal.ClassMethodFieldBuffer;
import org.eclipse.birt.data.oda.pojo.impl.internal.MethodIdentifier;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MethodSource
implements IMappingSource {
    private String name;
    private IMethodParameter[] parameters;
    private MethodIdentifier mi;
    private Object[] parameterValues;

    public MethodSource(String name, IMethodParameter[] parameters) {
        assert (name != null);
        this.name = name;
        this.parameters = parameters == null ? new IMethodParameter[]{} : parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IMethodParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public void prepareParameterValues(Map<String, Object> paramValues, ClassLoader pojoClassLoader) throws OdaException {
        this.parameterValues = new Object[this.parameters.length];
        int i = 0;
        IMethodParameter[] iMethodParameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodParameter mp = iMethodParameterArray[n2];
            mp.prepareValue(paramValues, pojoClassLoader);
            this.parameterValues[i++] = mp.getTargetValue();
            ++n2;
        }
    }

    @Override
    public Object fetchValue(Object from, ClassLoader pojoClassLoader) throws OdaException {
        if (from == null) {
            return null;
        }
        if (this.mi == null) {
            this.mi = MethodIdentifier.newInstance(this, pojoClassLoader);
        }
        Method m = ClassMethodFieldBuffer.getInstance().getMethod(from.getClass(), this.mi);
        try {
            return m.getReturnType().equals(Void.TYPE) ? null : m.invoke(from, this.parameterValues);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OdaException(String.valueOf(Messages.getString("IllegalArgument.errorMessage")) + this.mi.getName());
        }
        catch (IllegalAccessException e) {
            throw new OdaException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OdaException(String.valueOf(Messages.getString("IllegalArgument.errorMessage")) + this.mi.getName() + "\n" + e.getTargetException().getLocalizedMessage());
        }
    }

    @Override
    public Element createElement(Document doc) {
        Element ele = doc.createElement("Method");
        ele.setAttribute("name", this.getName());
        IMethodParameter[] iMethodParameterArray = this.getParameters();
        int n = iMethodParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodParameter p = iMethodParameterArray[n2];
            ele.appendChild(p.createElement(doc));
            ++n2;
        }
        return ele;
    }

    public void updateMethodParameter(IMethodParameter old, IMethodParameter newParam) {
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].equals(old)) {
                this.parameters[i] = newParam;
            }
            ++i;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSource other = (MethodSource)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }
}

