/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.device.render;

import java.io.File;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.tests.device.render.ImageOutputBaseTest;
import org.eclipse.birt.core.framework.PlatformConfig;

public class ImageRenderTest {
    protected static final String OUTDIR = "output";
    protected static final String INDIR = "input";
    protected static final String CONTROLDIR = "golden";
    protected static final String DRAWEXT = ".drw";
    protected String fixedDir;
    protected String workspaceDir;
    protected String type;
    protected TestSuite suite;

    public ImageRenderTest(TestSuite suite) {
        this.suite = suite;
    }

    protected void processDir(File dir, String dirName) throws Exception {
        File[] files = dir.listFiles();
        int x = 0;
        while (x < files.length) {
            File file = files[x];
            if (file.isDirectory()) {
                File outFileDir = new File(String.valueOf(this.workspaceDir) + File.separator + OUTDIR + dirName + File.separator + file.getName());
                outFileDir.mkdirs();
                this.processDir(file, String.valueOf(dirName) + File.separator + file.getName());
            } else if (file.getName().endsWith(DRAWEXT)) {
                String fileName = file.getName();
                fileName = fileName.substring(0, fileName.length() - DRAWEXT.length());
                this.suite.addTest((Test)new ImageOutputBaseTest(file, dirName, fileName, this.workspaceDir));
            }
            ++x;
        }
    }

    public void process() throws Exception {
        Properties p = System.getProperties();
        PlatformConfig config = new PlatformConfig();
        config.setProperty("STANDALONE", (Object)"true");
        ChartEngine.instance((PlatformConfig)config);
        this.fixedDir = String.valueOf(File.separator) + "src" + File.separator + "org" + File.separator + "eclipse" + File.separator + "birt" + File.separator + "chart" + File.separator + "tests" + File.separator + "device";
        this.workspaceDir = String.valueOf((String)p.get("user.dir")) + this.fixedDir;
        File inputDir = new File(String.valueOf(this.workspaceDir) + File.separator + INDIR);
        this.processDir(inputDir, "");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Test for render devices");
        ImageRenderTest processSuite = new ImageRenderTest(suite);
        try {
            processSuite.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suite;
    }
}

