/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.device.render;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.birt.chart.device.image.PngRendererImpl;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;

public class Png24PrimitiveGen {
    protected PngRendererImpl renderer;
    protected InputStream fileName;
    protected String outFile;
    protected Fill fillColor;
    protected LineAttributes lineAttr;
    protected ColorDefinition strokeColor;
    protected ColorDefinition shadowColor;
    protected FontDefinition font;

    public Png24PrimitiveGen(InputStream fileName, String outFile) {
        this.fileName = fileName;
        this.outFile = outFile;
        this.startup();
    }

    protected void startup() {
        this.renderer = new PngRendererImpl();
        this.renderer.setProperty("device.file.identifier", (Object)this.outFile);
    }

    protected void readFile() throws Exception {
        InputStreamReader isr = new InputStreamReader(this.fileName);
        BufferedReader br = new BufferedReader(isr);
        String lineStr = null;
        while ((lineStr = br.readLine()) != null) {
            Location[] locations;
            PolygonRenderEvent shape;
            StringTokenizer st = new StringTokenizer(lineStr, " ");
            String type = st.nextToken();
            if (type == null) {
                throw new Exception("primitive type string is null");
            }
            if (type.equals("font")) {
                String fontName = st.nextToken();
                float size = Float.parseFloat(st.nextToken());
                boolean bold = Boolean.getBoolean(st.nextToken());
                boolean italic = Boolean.getBoolean(st.nextToken());
                boolean underline = Boolean.getBoolean(st.nextToken());
                boolean strike = Boolean.getBoolean(st.nextToken());
                boolean wordwrap = Boolean.getBoolean(st.nextToken());
                double rotation = Double.parseDouble(st.nextToken());
                TextAlignment ta = TextAlignmentImpl.create();
                try {
                    ta.setHorizontalAlignment(HorizontalAlignment.get((int)Integer.parseInt(st.nextToken())));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    ta.setVerticalAlignment(VerticalAlignment.get((int)Integer.parseInt(st.nextToken())));
                }
                catch (NumberFormatException numberFormatException) {}
                this.font = FontDefinitionImpl.create((String)fontName, (float)size, (boolean)bold, (boolean)italic, (boolean)underline, (boolean)strike, (boolean)wordwrap, (double)rotation, (TextAlignment)ta);
                continue;
            }
            if (type.equals("size")) {
                this.renderer.setProperty("device.bounds", (Object)BoundsImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                this.renderer.before();
                continue;
            }
            if (type.equals("fill")) {
                this.fillColor = ColorDefinitionImpl.create((int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()));
                continue;
            }
            if (type.equals("lineAttr")) {
                this.lineAttr = LineAttributesImpl.create((ColorDefinition)this.strokeColor, (LineStyle)LineStyle.get((int)Integer.parseInt(st.nextToken())), (int)Integer.parseInt(st.nextToken()));
                continue;
            }
            if (type.equals("stroke")) {
                this.strokeColor = ColorDefinitionImpl.create((int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()));
                continue;
            }
            if (type.equals("shadow")) {
                this.shadowColor = ColorDefinitionImpl.create((int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()), (int)Integer.parseInt(st.nextToken()));
                continue;
            }
            if (type.startsWith("arc")) {
                ArcRenderEvent are = new ArcRenderEvent((Object)this);
                are.setBackground(this.fillColor);
                are.setTopLeft(LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                are.setStartAngle(Double.parseDouble(st.nextToken()));
                are.setEndAngle(Double.parseDouble(st.nextToken()));
                are.setHeight(Double.parseDouble(st.nextToken()));
                are.setWidth(Double.parseDouble(st.nextToken()));
                are.setOutline(this.lineAttr);
                are.setDepth(Double.parseDouble(st.nextToken()));
                if (type.endsWith("fill")) {
                    this.renderer.fillArc(are);
                    continue;
                }
                this.renderer.drawArc(are);
                continue;
            }
            if (type.startsWith("line")) {
                LineRenderEvent line = new LineRenderEvent((Object)this);
                line.setStart(LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                line.setEnd(LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                line.setDepth(Double.parseDouble(st.nextToken()));
                line.setLineAttributes(this.lineAttr);
                this.renderer.drawLine(line);
                continue;
            }
            if (type.startsWith("oval")) {
                OvalRenderEvent oval = new OvalRenderEvent((Object)this);
                oval.setBackground(this.fillColor);
                oval.setBounds(BoundsImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                oval.setOutline(this.lineAttr);
                oval.setDepth(Double.parseDouble(st.nextToken()));
                if (type.endsWith("fill")) {
                    this.renderer.fillOval(oval);
                    continue;
                }
                this.renderer.drawOval(oval);
                continue;
            }
            if (type.startsWith("rect")) {
                RectangleRenderEvent rect = new RectangleRenderEvent((Object)this);
                rect.setBackground(this.fillColor);
                rect.setBounds(BoundsImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                rect.setOutline(this.lineAttr);
                rect.setDepth(Double.parseDouble(st.nextToken()));
                if (type.endsWith("fill")) {
                    this.renderer.fillRectangle(rect);
                    continue;
                }
                this.renderer.drawRectangle(rect);
                continue;
            }
            if (type.startsWith("polygon")) {
                shape = new PolygonRenderEvent((Object)this);
                shape.setBackground(this.fillColor);
                shape.setOutline(this.lineAttr);
                shape.setDepth(Double.parseDouble(st.nextToken()));
                int pointLength = Integer.parseInt(st.nextToken());
                locations = new Location[pointLength];
                int x = 0;
                while (x < pointLength) {
                    locations[x] = LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()));
                    ++x;
                }
                shape.setPoints(locations);
                if (type.endsWith("fill")) {
                    this.renderer.fillPolygon(shape);
                    continue;
                }
                this.renderer.drawPolygon(shape);
                continue;
            }
            if (type.startsWith("text")) {
                shape = new TextRenderEvent((Object)this);
                shape.setAction(Integer.parseInt(st.nextToken()));
                switch (shape.getAction()) {
                    case 1: {
                        shape.setTextPosition(Integer.parseInt(st.nextToken()));
                        shape.setLocation(LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                        break;
                    }
                    case 2: {
                        shape.setTextPosition(Integer.parseInt(st.nextToken()));
                        shape.setLocation(LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                        break;
                    }
                    case 3: {
                        shape.setBlockBounds(BoundsImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken())));
                        TextAlignment ta = TextAlignmentImpl.create();
                        try {
                            ta.setHorizontalAlignment(HorizontalAlignment.get((int)Integer.parseInt(st.nextToken())));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        try {
                            ta.setVerticalAlignment(VerticalAlignment.get((int)Integer.parseInt(st.nextToken())));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        shape.setBlockAlignment(ta);
                    }
                }
                Label label = LabelImpl.create();
                label.setBackground(this.fillColor);
                label.setOutline(this.lineAttr);
                String strLabel = "";
                String strDepth = "";
                while (st.hasMoreTokens()) {
                    strDepth = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    strLabel = strLabel.equals("") ? strDepth : String.valueOf(strLabel) + " " + strDepth;
                }
                Text text = TextImpl.create((String)strLabel);
                text.setFont(this.font);
                text.setColor(ColorDefinitionImpl.BLACK());
                label.setCaption(text);
                if (this.shadowColor != null) {
                    label.setShadowColor(this.shadowColor);
                }
                shape.setLabel(label);
                shape.setDepth(Double.parseDouble(strDepth));
                this.renderer.drawText((TextRenderEvent)shape);
                continue;
            }
            if (type.equals("transform")) {
                TransformationEvent trans = new TransformationEvent((Object)this);
                trans.setTransform(Integer.parseInt(st.nextToken()));
                trans.setDepth(Double.parseDouble(st.nextToken()));
                trans.setRotation(Double.parseDouble(st.nextToken()));
                trans.setScale(Double.parseDouble(st.nextToken()));
                trans.setTranslation(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                this.renderer.applyTransformation(trans);
                continue;
            }
            if (type.equals("clip")) {
                ClipRenderEvent clip = new ClipRenderEvent((Object)this);
                clip.setDepth(Double.parseDouble(st.nextToken()));
                int pointLength = Integer.parseInt(st.nextToken());
                locations = new Location[pointLength];
                int x = 0;
                while (x < pointLength) {
                    locations[x] = LocationImpl.create((double)Double.parseDouble(st.nextToken()), (double)Double.parseDouble(st.nextToken()));
                    ++x;
                }
                clip.setVertices(locations);
                this.renderer.setClip(clip);
                continue;
            }
            if (type.startsWith("area")) {
                AreaRenderEvent area = new AreaRenderEvent((Object)this);
                area.setDepth(Double.parseDouble(st.nextToken()));
                area.setBackground(this.fillColor);
                area.setOutline(this.lineAttr);
                this.renderer.drawArea(area);
                continue;
            }
            if (!type.equals("image")) continue;
            ImageRenderEvent image = new ImageRenderEvent((Object)this);
            this.renderer.drawImage(image);
        }
        br.close();
    }

    public void generate() throws Exception {
        this.readFile();
    }

    public void flush() throws Exception {
        this.renderer.after();
    }
}

