/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.computation;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;

public class MonthDateFormatTest
extends TestCase {
    public void testFormat() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2013);
        calendar.set(2, 5);
        calendar.set(5, 8);
        Date date = calendar.getTime();
        Hashtable<ULocale, String> locales = new Hashtable<ULocale, String>();
        locales.put(ULocale.CANADA, "2013-06");
        locales.put(ULocale.CHINA, "2013-6");
        locales.put(ULocale.ENGLISH, "Jun 2013");
        locales.put(ULocale.FRANCE, "juin 2013");
        locales.put(ULocale.GERMAN, "06.2013");
        locales.put(ULocale.ITALY, "giu/2013");
        locales.put(ULocale.JAPAN, "2013/06");
        locales.put(ULocale.KOREA, "2013. 6");
        locales.put(ULocale.SIMPLIFIED_CHINESE, "2013-6");
        locales.put(ULocale.TAIWAN, "2013/6");
        locales.put(ULocale.TRADITIONAL_CHINESE, "2013/6");
        locales.put(ULocale.UK, "Jun 2013");
        for (ULocale locale : locales.keySet()) {
            IDateFormatWrapper formatter = DateFormatWrapperFactory.getPreferredDateFormat((int)2, (ULocale)locale, (boolean)true);
            MonthDateFormatTest.assertTrue((boolean)((String)locales.get(locale)).equals(formatter.format(date)));
        }
    }
}

